<?php $__env->startSection('content'); ?>

    <div class="container-fluid">
        <a href="/operario/actividades/" class="text-dark d-flex align-items-center mt-3">
            <i class="fa-solid fa-arrow-left"></i>
            <div class="semibold ms-2 fs-6">Volver</div>
        </a>

        <!-- TItel general -->
        <div class="headline-main mb-4">
            <h4 class="font-weight-bolder mt-4 ">Servicio de <?php echo e($mascota->nombre_mascota); ?></h4>
        </div>
        <!-- Line separator -->
        <div class="position-relative d-flex justify-content-center">
            <svg xmlns="http://www.w3.org/2000/svg" width="" height="18" viewBox="0 0 1105 18" fill="none">
                <path
                    d="M0 17H539.182C547.993 17 556.738 15.4676 565.025 12.4713L584.225 5.52866C592.512 2.53238 601.257 1 610.068 1H1105"
                    stroke="#CFCFCF" stroke-width="1.5"/>
            </svg>
        </div>

        <!-- Timeline compost -->
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-md-12">
                <!-- card general -->
                <div class="card my-4 py-5">
                    <div class="row justify-content-center">
                        <div class="col-11">
                            <!-- description  -->
                            <div class="card">
                                <div class="description border-radius-lg">

                                    <h5 class="f-weight pb-3">Datos </h5>

                                    <div class="card-body border border-radius-md">
                                        <div class="row">

                                            <!-- info -->
                                            <div class="col-lg-8">
                                                <div class="mb-3 row dates-pets">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Nombres :</label>
                                                    <div class="col-auto"><span class="black-main labeltext f-weight-40"><?php echo e($usuario->nombres); ?> <?php echo e($usuario->apellidos); ?></span></div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Celular :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40"><?php echo e($usuario->celular); ?></span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Nombre de Mascota :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40"><?php echo e($mascota->nombre_mascota); ?></span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Tipo :</label>
                                                    <div class="col-auto">
                                                        <span
                                                            class="black-main labeltext f-weight-40"><?php echo e($mascota->tipo_mascota); ?></span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Peso :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40"><?php echo e($mascota->peso_mascota); ?>kg.</span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Hora de recojo :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40"><?php echo e($horario->horario); ?></span>
                                                    </div>
                                                </div>

                                                <div class="mb-3 row">
                                                    <label class="ms-0 mb-2 col-12 col-sm-auto">Dirección de recojo :</label>
                                                    <div class="col-auto">
                                                        <span class="black-main labeltext f-weight-40"><?php echo e($recojos->direccion_recojo); ?></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- image -->
                                            <div class="col-lg-4 d-flex justify-content-center align-items-center">
                                                <div class="imagePets w-full h-full border-radius-md shadow-czi">
                                                    <?php if($mascota->tipo_mascota == 'Gat@'): ?>
                                                        <img src="<?php echo e(asset('assets/img/mascotas/gato.svg')); ?>" width="170" alt="gato">
                                                    <?php elseif($mascota->tipo_mascota == 'Perr@'): ?>
                                                        <img src="<?php echo e(asset('assets/img/mascotas/perro.png')); ?>" width="170" alt="perro">
                                                    <?php elseif($mascota->tipo_mascota == 'Conej@'): ?>
                                                        <img src="<?php echo e(asset('assets/img/mascotas/conejo.png')); ?>" width="170" alt="conejo">
                                                    <?php elseif($mascota->tipo_mascota == 'Pajarito'): ?>
                                                        <img src="<?php echo e(asset('assets/img/mascotas/pajarito.png')); ?>" width="170" alt="pajarito">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('assets/img/mascotas/gato.svg')); ?>" width="170" alt="gato">
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>

                            <div class="card border border-radius-lg">
                                <!-- compostaje -->
                                <div class="timeline-kanban">
                                    <h5 class="f-weight px-4 py-4">Timeline de compostaje y cosecha </h5>
                                    <hr>
                                    <!-- oper asigned -->
                                    <div class="asignado position-relative mx-4 my-4">
                                        <p class="f-weight labeltext color-grey">Operario Asignado</p>

                                        <form method="POST" action="<?php echo e(route('confirmar_operario')); ?>"
                                              class="col-lg-4 col-md-6 col-12 conductor-asignado">
                                            <?php echo csrf_field(); ?>
                                            <div class="border input-name">
                                                <span class="text-dark"><?php echo e($operario->nombres); ?></span>
                                            </div>
                                            <input type="hidden" id="id_compostaje" name="id_compostaje"
                                                   value="<?php echo e($compostaje->id_compostaje); ?>">
                                            <input type="hidden" id="confirmacion" name="confirmacion" value="1">
                                            <?php if($compostaje->operario_confirmado === 1): ?>
                                                <button role="button" disabled type="submit"
                                                        class="btn-lg btn btn-success labeltext w-full">Confirmado
                                                </button>
                                            <?php else: ?>
                                                <button role="button" type="submit"
                                                        class="btn-lg btn btn-success labeltext w-full">Confirmar
                                                </button>
                                            <?php endif; ?>
                                        </form>
                                    </div>
                                    <?php if($compostaje->operario_confirmado === 1): ?>

                                        <!-- timeline -->
                                        <hr>
                                        <div class="timeline-label">
                                            <div class="recojo-mascota">
                                                <!-- begin::Item 1  -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            1
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div class="timeline-activity card-body p-0">
                                                            <h5 class="f-weight">Recepción de Mascota</h5>
                                                            <p class="labeltext"><?php echo e($mascota->nombre_mascota); ?> ha llegado bien
                                                                al compostario</p>
                                                        </div>
                                                    </div>
                                                    <form method="POST"
                                                          action="<?php echo e(route('registro_actividad_operario_paso1')); ?>" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="1">
                                                        <?php if($compostaje->estado_etapa >= 1): ?>
                                                            <button role="button" disabled type="submit"
                                                                    class="btn btn-success labeltext">Realizado
                                                            </button>
                                                        <?php else: ?>
                                                            <button role="button" type="submit"
                                                                    class="btn btn-outline-dark">Realizado
                                                            </button>
                                                        <?php endif; ?>
                                                    </form>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                                <!-- begin::Item 2 -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            2
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div class="timeline-activity card-body p-0">
                                                            <h5 class="f-weight">Subir foto del print de la huella de la mascota </h5>
                                                            <!-- <p class="labeltext">He llegado al punto de recojo</p> -->
                                                            <form id="enviar-constancia-huella" class="mt-4" method="POST" enctype="multipart/form-data" action="<?php echo e(route('subir_fotografia')); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                                <div class="row">
                                                                    <?php if($compostaje->estado_etapa < 2 ): ?>
                                                                        <div class="col-md-9">
                                                                            <div class="">
                                                                                <div class="constans-content">
                                                                                    <div class="upload-hover position-relative border-radius-md px-3 py-4">
                                                                                        <label for="foto_huella" class="w-full h-full cursor-pointer top-0 start-0 position-absolute">
                                                                                            <input id="foto_huella" multiple accept="image/*" name="foto_huella" type="file" class="visually-hidden">
                                                                                        </label>
                                                                                        <div class="text-center d-flex align-items-center">
                                                                                            <i class="ri-upload-cloud-2-line t-verde" style="font-size: 35px;"></i>
                                                                                            <span class="labeltext black-main mx-3 f-weight-50">Has clic en el botón para cargar tu imagen</span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="d-flex justify-content-between mt-2">
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Tipo: JPG, PNG
                                                                                        </p>
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Peso máximo 1MB
                                                                                        </p>
                                                                                    </div>
                                                                                </div>
                                                                                <button type="submit" class="mb-0 mt-3 btn btn-success px-5">Enviar</button>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <div class="col-md-2">
                                                                        <?php if($compostaje->foto_huella): ?>
                                                                            <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green d-flex justify-content-center">
                                                                                <a href="<?php echo e(asset('storage/' . $compostaje->foto_huella)); ?>" target="_blank">
                                                                                    <img src="<?php echo e(asset('storage/' . $compostaje->foto_huella)); ?>" alt="Foto Huella" width="150" class="d-block mx-auto">
                                                                                </a>
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <form method="POST" action="<?php echo e(route('registro_actividad_operario_paso2')); ?>" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <input type="hidden" id="id_usuario" name="id_usuario" value="<?php echo e($usuario->id); ?>">
                                                        <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="<?php echo e($mascota->nombre_mascota); ?>">
                                                        <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="<?php echo e($usuario->nombres); ?> <?php echo e($usuario->apellidos); ?>">
                                                        <input type="hidden" id="email" name="email" value="<?php echo e($usuario->email); ?>">
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="2">
                                                        <?php if(isset($compostaje->foto_huella)): ?>
                                                            <?php if($compostaje->estado_etapa >= 3 ): ?>
                                                                <button role="button" disabled type="submit"
                                                                        class="btn btn-success labeltext">Realizado
                                                                </button>
                                                            <?php else: ?>
                                                                <button role="button" type="submit"
                                                                        class="btn btn-outline-dark">Realizado
                                                                </button>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </form>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                                <!-- begin::Item 4 -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            3
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div class="timeline-activity card-body p-0">
                                                            <h5 class="f-weight">Subir foto de la mascota antes de tapar la cuna</h5>
                                                            <form id="enviar-constancia-taparcuna" class="mt-4" method="POST" enctype="multipart/form-data" action="<?php echo e(route('subir_fotografia')); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                                <div class="row">
                                                                    <?php if($compostaje->estado_etapa < 3 ): ?>
                                                                        <div class="col-md-9">
                                                                            <div class="">
                                                                                <div class="constans-content">
                                                                                    <div class="upload-hover position-relative border-radius-md px-3 py-4">
                                                                                        <label for="foto_taparcuna" class="w-full h-full cursor-pointer top-0 start-0 position-absolute">
                                                                                            <input id="foto_taparcuna" accept="image/*" name="foto_taparcuna" type="file" class="visually-hidden">
                                                                                        </label>
                                                                                        <div class="text-center d-flex align-items-center">
                                                                                            <i class="ri-upload-cloud-2-line t-verde" style="font-size: 35px;"></i>
                                                                                            <span class="labeltext black-main mx-3 f-weight-50">Has clic en el botón para cargar tu imagen</span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="d-flex justify-content-between mt-2">
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Tipo: JPG, PNG
                                                                                        </p>
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Peso máximo 1MB
                                                                                        </p>
                                                                                    </div>
                                                                                </div>
                                                                                <button type="submit" class="mb-0 mt-3 btn btn-success px-5">Enviar</button>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <div class="col-md-2">
                                                                        <?php if($compostaje->foto_cunatapar): ?>
                                                                            <p class="p-2 image-constance position-relative border-radius-md greese-green d-flex justify-content-center">
                                                                                <a href="<?php echo e(asset('storage/' . $compostaje->foto_cunatapar)); ?>" target="_blank">
                                                                                    <img src="<?php echo e(asset('storage/' . $compostaje->foto_cunatapar)); ?>" alt="Foto Huella" width="150" class="d-block mx-auto">
                                                                                </a>
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <form method="POST" action="<?php echo e(route('registro_actividad_operario_paso2')); ?>" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="3">
                                                        <?php if(isset($compostaje->foto_cunatapar)): ?>
                                                            <?php if($compostaje->estado_etapa >= 3 ): ?>
                                                                <button role="button" disabled type="submit"
                                                                        class="btn btn-success labeltext">Realizado
                                                                </button>
                                                            <?php else: ?>
                                                                <button role="button" type="submit"
                                                                        class="btn btn-outline-dark">Realizado
                                                                </button>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </form>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>

                                                <!-- begin::Item 3 -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div class="text-center rounded-circle badge-circle border labeltext black-main c-princi">4</div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div class="timeline-activity card-body p-0">
                                                            <h5 class="f-weight">Subir foto de la mascota en la cuna lista</h5>
                                                            <form id="enviar-constancia-operario" class="mt-4" method="POST" enctype="multipart/form-data" action="<?php echo e(route('subir_fotografia')); ?>">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                                <div class="row">
                                                                    <?php if($compostaje->estado_etapa < 4 ): ?>
                                                                        <div class="col-md-9">
                                                                            <div class="">
                                                                                <div class="constans-content">
                                                                                    <div class="upload-hover position-relative border-radius-md px-3 py-4">
                                                                                        <label for="foto_cunalista" class="w-full h-full cursor-pointer top-0 start-0 position-absolute">
                                                                                            <input id="foto_cunalista" accept="image/*" name="foto_cunalista" type="file" class="visually-hidden">
                                                                                        </label>
                                                                                        <div class="text-center d-flex align-items-center">
                                                                                            <i class="ri-upload-cloud-2-line t-verde" style="font-size: 35px;"></i>
                                                                                            <span class="labeltext black-main mx-3 f-weight-50">Has clic en el botón para cargar tu imagen</span>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="d-flex justify-content-between mt-2">
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Tipo: JPG, PNG
                                                                                        </p>
                                                                                        <p class="text-sm f-weight-50 color-grey">
                                                                                            Peso máximo 1MB
                                                                                        </p>
                                                                                    </div>
                                                                                </div>
                                                                                <button type="submit" class="mb-0 mt-3 btn btn-success px-5">Enviar</button>
                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>
                                                                    <div class="col-md-2">
                                                                        <?php if($compostaje->foto_cunalista): ?>
                                                                            <p class="p-2 image-constance position-relative border-radius-md greese-green d-flex justify-content-center">
                                                                                <a href="<?php echo e(asset('storage/' . $compostaje->foto_cunalista)); ?>" target="_blank">
                                                                                    <img src="<?php echo e(asset('storage/' . $compostaje->foto_cunalista)); ?>" alt="Foto Huella" width="150" class="d-block mx-auto">
                                                                                </a>
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                    <form method="POST" action="<?php echo e(route('registro_actividad_operario_paso2')); ?>" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="4">
                                                        <?php if(isset($compostaje->foto_cunalista)): ?>
                                                            <?php if($compostaje->estado_etapa >= 4 ): ?>
                                                                <button role="button" disabled type="submit"
                                                                        class="btn btn-success labeltext">Realizado
                                                                </button>
                                                            <?php else: ?>
                                                                <button role="button" type="submit"
                                                                        class="btn btn-outline-dark">Realizado
                                                                </button>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </form>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>

                                                <!-- begin::Item 5 -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            5
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div>
                                                            <form method="POST"
                                                                  action="<?php echo e(route('registro_actividad_operario_paso3')); ?>"
                                                                  class="d-flex">
                                                                <div class="timeline-activity card-body p-0 w-90">
                                                                    <?php echo csrf_field(); ?>
                                                                    
                                                                    <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                                    <input type="hidden" id="estado_etapa" name="estado_etapa" value="5">
                                                                    <input type="hidden" id="id_usuario" name="id_usuario" value="<?php echo e($pedido->id_usuario); ?>">
                                                                    <input type="hidden" id="id_pedido" name="id_pedido" value="<?php echo e($pedido->id_pedido); ?>">
                                                                    <input type="hidden" id="email" name="email" value="<?php echo e($usuario->email); ?>">
                                                                    <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="<?php echo e($usuario->nombres); ?> <?php echo e($usuario->apellidos); ?>">
                                                                    <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="<?php echo e($mascota->nombre_mascota); ?>">
                                                                    <h5 class="f-weight">Fecha de inicio de compostaje</h5>
                                                                    <p class="labeltext">Inicio de compost</p>
                                                                    <!-- Time & Our -->
                                                                    <div class="row mt-5">
                                                                        <div class="col-xl-10">
                                                                            <div class="row pb-4">
                                                                                <!-- input date -->
                                                                                <div class="col-xl-6">
                                                                                    <div class="caler-selec">
                                                                                        <label for="staticEmail"
                                                                                               class="f-weight mb-1 labeltext">Fecha</label>
                                                                                        <div class="field-date">
                                                                                            <?php if(isset($compostaje->inicio_fecha)): ?>
                                                                                                <input disabled type="text"
                                                                                                       class="form-control col-xl-12 px-2 py-2" value="<?php echo e($compostaje->inicio_fecha); ?>">
                                                                                            <?php else: ?>
                                                                                                <input type="date"
                                                                                                       class="col-xl-12 px-2 py-2 form-control"
                                                                                                       id="inicio_fecha"
                                                                                                       name="inicio_fecha"
                                                                                                       onfocus="focused(this)"
                                                                                                       onfocusout="defocused(this)">
                                                                                            <?php endif; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                                <!-- input time -->
                                                                                <div class="col-xl-6">
                                                                                    <div class="our-selec">
                                                                                        <label for="staticEmail"
                                                                                               class="f-weight mb-1 labeltext">Hora</label>
                                                                                        <div class="field-date">
                                                                                            <?php if(isset($compostaje->inicio_hora)): ?>
                                                                                                <input disabled type="text"
                                                                                                       class="form-control col-xl-12 px-2 py-2" value="<?php echo e($compostaje->inicio_hora); ?>">
                                                                                            <?php else: ?>
                                                                                                <input type="time"
                                                                                                       class="col-xl-12 px-2 py-2 form-control"
                                                                                                       iid="inicio_hora"
                                                                                                       name="inicio_hora"
                                                                                                       onfocus="focused(this)"
                                                                                                       onfocusout="defocused(this)">
                                                                                            <?php endif; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div>
                                                                    <?php if($compostaje->estado_etapa >= 5): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </form>
                                                        </div>
                                                        <!-- Monitoreo 1 -->
                                                        <div class="w-full position-relative mt-3">
                                                            <div class="row">
                                                                <div id="contenedorMonitoreo" class="monitoreo">
                                                                    <?php $__currentLoopData = $monitoreos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $monitoreo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php echo $__env->make('components.monitoreo-form', ['operario' => $operario->id_operario,'mascota' => $mascota->id_mascota, 'compostaje' => $compostaje->id_compostaje, 'count' => $index + 1, 'monitoreo' => $monitoreo], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                                <div class="col-lg-11 d-flex justify-content-end mt-3">
                                                                    <div class="w-full monitor">
                                                                        <div class="row">
                                                                            <div
                                                                                class="col-lg-10 d-flex justify-content-end mt-3">
                                                                                <?php if(isset($compostaje->inicio_fecha)): ?>
                                                                                    <button disabled href="" id="agregarMonitoreo" role="button"
                                                                                            class="btn btn-success disabled btn-disabled px-4 py-3">Añadir
                                                                                        Monitoreo
                                                                                    </button>
                                                                                <?php else: ?>
                                                                                    <button href="" id="agregarMonitoreo" role="button"
                                                                                            class="btn btn-success px-4 py-3">Añadir
                                                                                        Monitoreo
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <!-- <button id="agregarMonitoreo" class="btn btn-primary mb-3">Agregar Monitoreo</button> -->
                                                        <div id="contenedorMonitoreo"></div>

                                                        <script>
                                                            $(document).ready(function () {
                                                                let contadorMonitoreo = <?php echo e($ultimoNumero + 1); ?>;

                                                                $("#agregarMonitoreo").click(function () {
                                                                    $.ajax({
                                                                        url: '/get-monitoreo-form',
                                                                        method: 'GET',
                                                                        data: {
                                                                            count: contadorMonitoreo,
                                                                            id_compostaje: '<?php echo e($compostaje->id_compostaje); ?>',
                                                                            id_operario: '<?php echo e($operario->id_operario); ?>',
                                                                            id_mascota: '<?php echo e($mascota->id_mascota); ?>'
                                                                        },
                                                                        success: function (response) {
                                                                            $("#contenedorMonitoreo").append(response);
                                                                            contadorMonitoreo++;
                                                                        },
                                                                        error: function (xhr) {
                                                                            console.error('Error al cargar el formulario:', xhr.responseText);
                                                                        }
                                                                    });
                                                                });
                                                            });
                                                        </script>
                                                    </div>

                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                                <!-- begin::Item 6 -->
                                                <div class="timeline-item item-border pt-5 border-bottom">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            6
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div>
                                                            <form method="POST" action="<?php echo e(route('registro_actividad_operario_paso4')); ?>" class="d-flex">
                                                                <?php echo csrf_field(); ?>
                                                                <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                                <input type="hidden" id="estado_etapa" name="estado_etapa" value="6">
                                                                <div class="timeline-activity card-body p-0 w-90">
                                                                    <h5 class="f-weight">Fecha de fin de compostaje</h5>
                                                                    <!-- date one -->
                                                                    <div class="row mt-5">
                                                                        <div class="col-xl-9">
                                                                            <div class="row pb-4">
                                                                                <!-- input date -->
                                                                                <div class="col-xl-6">
                                                                                    <div class="caler-selec">
                                                                                        <label for="staticEmail" class="f-weight mb-1 labeltext">Fecha Tentativa</label>
                                                                                        <div class="field-date">
                                                                                            <?php if(isset($compostaje->fin_tentativo)): ?>
                                                                                                <input disabled type="text" class="form-control col-xl-12 px-2 py-2" value="<?php echo e($compostaje->fin_tentativo); ?>">
                                                                                            <?php else: ?>
                                                                                                <input type="date" class="col-xl-12 px-2 py-2 form-control" id="fin_tentativo" name="fin_tentativo" onfocus="focused(this)"
                                                                                                       onfocusout="defocused(this)">
                                                                                            <?php endif; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <!-- Time & Our -->
                                                                    <div class="row">
                                                                        <div class="col-xl-9">
                                                                            <div class="row pb-4">
                                                                                <!-- input date -->
                                                                                <div class="col-xl-6">
                                                                                    <div class="caler-selec">
                                                                                        <label for="staticEmail"
                                                                                               class="f-weight mb-1 labeltext">Fecha</label>
                                                                                        <div class="field-date">
                                                                                            <?php if(isset($compostaje->fin_fecha)): ?>
                                                                                                <input disabled type="text" class="form-control col-xl-12 px-2 py-2" value="<?php echo e($compostaje->fin_fecha); ?>">
                                                                                            <?php else: ?>
                                                                                                <input type="date" class="col-xl-12 px-2 py-2 form-control" id="fin_fecha" name="fin_fecha" onfocus="focused(this)"
                                                                                                       onfocusout="defocused(this)">
                                                                                            <?php endif; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="caler-selec">
                                                                                        <label for="staticEmail"
                                                                                               class="f-weight mb-1 labeltext">Peso total tamizado</label>
                                                                                        <div class="d-md-flex">
                                                                                            <div
                                                                                                class="d-block col-md-8 me-md-3">
                                                                                                <?php if(isset($compostaje->peso_cosecha)): ?>
                                                                                                    <input disabled type="text"
                                                                                                           class="form-control col-xl-12 px-2 py-2" value="<?php echo e($compostaje->peso_cosecha); ?>">
                                                                                                <?php else: ?>
                                                                                                    <input type="text"
                                                                                                           class="form-control col-xl-12 px-2 py-2"
                                                                                                           id="peso_cosecha"
                                                                                                           name="peso_cosecha"
                                                                                                           onfocus="focused(this)"
                                                                                                           onfocusout="defocused(this)">
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                            <div class="d-block col-md-3">
                                                                                                <div
                                                                                                    class="position-relative cosecha-label">

                                                                                                    <input type="text"
                                                                                                           class="form-control form-control-alternative"
                                                                                                           disabled=""
                                                                                                           onfocus="focused(this)"
                                                                                                           onfocusout="defocused(this)">
                                                                                                    <label for=""
                                                                                                           class="f-weight">Kg.</label>

                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>


                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                                <div>
                                                                    <?php if($compostaje->estado_etapa >= 6): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </div>

                                                            </form>
                                                        </div>
                                                    </div>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                                <!-- begin::Item 7 -->
                                                <div class="timeline-item item-border pt-5 border-bottoms">
                                                    <!--begin::Date-->

                                                    <!--begin::Badge-->
                                                    <div class="timeline-badge">
                                                        <div
                                                            class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                            7
                                                        </div>
                                                    </div>
                                                    <div class="timeline-content w-90">
                                                        <div class="timeline-activity card-body p-0">
                                                            <h5 class="f-weight">Entrega de Compost y huellas a Logística</h5>
                                                            
                                                        </div>
                                                    </div>
                                                    <form method="POST" action="<?php echo e(route('registro_actividad_operario_paso2')); ?>" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" id="estado_etapa" name="estado_etapa" value="7">
                                                        <input type="hidden" id="estado" name="estado" value="4">
                                                        <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($compostaje->id_compostaje); ?>">
                                                        <?php if($compostaje->estado_etapa >= 7): ?>
                                                            <button role="button" disabled type="submit"
                                                                    class="btn btn-success labeltext">Realizado
                                                            </button>
                                                        <?php else: ?>
                                                            <button role="button" type="submit"
                                                                    class="btn btn-outline-dark">Realizado
                                                            </button>
                                                        <?php endif; ?>
                                                    </form>
                                                    <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                </div>
                                            </div>
                                        </div>

                                        <!-- timeline -->
                                    <?php endif; ?>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.useroperario', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/operario/actividades_id.blade.php ENDPATH**/ ?>