<?php $__env->startSection('content'); ?>

    <section class="container">
        <div class="mt-4 card-header pb-0 text-start">
            <h2 class="semibold t-verde fs-4">Creando más vida con Vuelve</h2>
        </div>

        <div class="card-header pb-0 text-start mt-4 mb-5">
            <h3 class="f-weight fs-4 mb-2 text-dark">Productos Extras</h3>
            <p class="text-sm">Tenemos algunos productos adicionales para que puedas recordar por siempre a tu mascota</p>
        </div>

        <div class=" w-xl-60 w-md-80 w-sm-100 alert alert-success alert-dismissible text-white fade show" role="alert"
             id="successAlert" style="display: none;">
            <div class="d-flex">
                <span class="alert-icon d-flex align-items-center">
                    <div
                        class="me-2 rounded-circle border border-white icono-check d-flex align-items-center justify-content-center">
                        <i class="fa-solid fa-check fs-7"></i>
                    </div>
                </span>
                <span class="alert-text normal">Se ha agregado este producto extra</span>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        </div>

        <form class="row mb-5" method="GET" action="<?php echo e(route('registrovuelveacasa_cuotas')); ?>" id="registro">
            <?php echo csrf_field(); ?>
            <?php if($productos): ?>
                <?php $__currentLoopData = $productos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $producto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-sm-6 col-lg-4 col-xl-3">
                        <div class="mb-4">
                            <div class="border bg-white card">
                                <div class="m-3">
                                    <div class="card-header p-0 d-flex justify-content-center">
                                        <div class="d-block blur-shadow-image">
                                            <img height="200" src="<?php echo e(asset('assets/img/' . $producto->imagen)); ?>"
                                                 class="img-fxluid no-select border-radius-lg">

                                        </div>
                                    </div>
                                    <div class="card-body pb-0 px-0 ">
                                        <p class="text-center semibold card-description mb-3 text-uppercase text-sm text-center"
                                           style="min-height: 52px"><?php echo e($producto->nombre_producto); ?></p>
                                        <div class="row justify-content-between cantidad-extra mb-3">
                                            <div class="col-12">
                                                <p class="f-weight text-center h4">S/.<?php echo e($producto->precio); ?></p>
                                            </div>
                                            <div
                                                class="col-5 col-sm-4 col-md-7 col-xxl-5 d-flex justify-content-end align-items-center">
                                                <div class="w-80 h-60 border rounded-2 cantidad hide">
                                                    <div class="d-flex justify-content-center">
                                                        <button type="button" id="sub2" class="sub">-</button>
                                                        <input type="number" id="cant-<?php echo e($producto->id_producto); ?>" name="extra[<?php echo e($producto->id_producto); ?>]" value="0"/>
                                                        <button type="button" id="add" class="add">+</button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <a type="button" href="#" class="mb-0 anadir w-100 btn-add-cart mb-0 btn px-0 btn-success btn-lg fs-6 semibold">Añadir Producto</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
            <div class="col-12">
                <div class="card-header text-md-end text-sm-center d-flex justify-content-between">
                    <a type="button" href="<?php echo e(route('registro_vuelve_acasa')); ?>" class=" mx-1 btn btn-outline-dark btn-lg  fs-6 semibold">Volver</a>
                    <button type="submit" class="mx-1 btn btn-success btn-lg fs-6 semibold ">Continuar</button>
                </div>
            </div>
        </form>
        <!-- Footer -->
        <div class="row">
            <div class="col-xl-6 col-lg-7 col-md-12">
                <div class=" mb-4">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="text-center rounded-circle orden border border-success border-2 text-xs normal"><i class="t-verde fa-solid fa-check"></i></div>
                        <hr class="flex-grow-1 hr-v">
                        <div class="text-center rounded-circle orden border border-success border-2 text-xs normal"><i class="t-verde fa-solid fa-check"></i></div>
                        <hr class="flex-grow-1 hr-v">
                        <div class="text-center rounded-circle orden border border-success border-2 text-xs normal"><i class="t-verde fa-solid fa-check"></i></div>
                        <hr class="flex-grow-1 hr-v">
                        <div class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">4</div>
                        <hr class="flex-grow-1 hr-v">
                        <div class="text-center rounded-circle orden border text-xs normal">5</div>
                        <hr class="flex-grow-1 hr-o">
                        <div class="text-center rounded-circle orden border text-xs normal">6</div>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <h6 class="f-weight  text-xs">Datos</h6>
                        <hr class="flex-grow-1 hr-t">
                        <h6 class="f-weight  text-xs">Mascota</h6>
                        <hr class="flex-grow-1 hr-t">
                        <h6 class="f-weight  text-xs">Recojo</h6>
                        <hr class="flex-grow-1 hr-t">
                        <h6 class="f-weight  text-xs">Extras</h6>
                        <hr class="flex-grow-1 hr-t">
                        <h6 class="semibold  text-xs text-secondary">Cuotas</h6>
                        <hr class="flex-grow-1 hr-t">
                        <h6 class="semibold  text-xs text-secondary">Pago</h6>
                    </div>
                </div>
            </div>
        </div>

    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $(function () {
            $('.anadir').click(function (e) {
                e.preventDefault();
                let bloque = $(this).parent().parent();
                bloque.find('.cantidad-extra .cantidad').toggleClass('hide');
                if (bloque.find('.cantidad-extra .cantidad').hasClass('hide')) {
                    bloque.find('.cantidad-extra input').val(0);
                    $(this).text('Añadir Servicio');
                } else {
                    bloque.find('.cantidad-extra input').val(1);
                    $(this).text('Quitar Servicio');
                }
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.web', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/registro/vuelveacasa/extras.blade.php ENDPATH**/ ?>