<?php $__env->startSection('content'); ?>

    <?php
        use Carbon\Carbon;

        // Configurar Carbon en español
        Carbon::setLocale('es');
    ?>

    <div class="container-fluid">
        <?php if(session('exito')): ?>
            <div class="alert alert-success mb-5 white-color" role="alert">
                <?php echo e(session('exito')); ?>

            </div>
        <?php endif; ?>
        <a href="/admin/pedido/" class="text-dark d-flex align-items-center mt-3">
            <i class="fa-solid fa-arrow-left"></i>
            <div class="semibold ms-2 fs-6">Volver</div>
        </a>


        <!-- TItel general -->
        <div class="headline-main mb-4">
            <h4 class="font-weight-bolder mt-4 ">Servicio de <?php echo e($mascota->nombre_mascota); ?></h4>
        </div>

        <div class="card">
            <div class="tabsNavtop admin mt-5 mb-3">
                <ul class="nav nav-tabs nav border-bottom ul-nav px-4" id="mainTabs" role="tablist">
                    <li class="nav-item" role="presentation">
                        <button class="nav-link w-100 text-sm active" id="tab1-tab" data-bs-toggle="tab"
                                data-bs-target="#tab1" type="button" role="tab" aria-controls="tab1"
                                aria-selected="true">Datos
                        </button>
                    </li>
                    
                </ul>
            </div>

            <div class="tab-content p-5" id="mainTabsContent">

                <div class="tab-pane fade show active" id="tab1" role="tabpanel" aria-labelledby="tab1-tab">
                    <div class="row d-flex justify-content-center">

                        <div class="col-12">
                            <div class="card border border-radius-lg mb-6">
                                <div class="card-body">
                                    <div class="row">

                                        <!-- info -->
                                        <div class="col-12">

                                        </div>
                                        <div class="col-lg-8">
                                            <div class="mb-3 row dates-pets">
                                                <label
                                                    class="col-lg-4 col-md-4 col-sm-4 labeltext f-weight label-first">Nombres</label>
                                                <label
                                                    class="col-lg-1 col-md-1 col-sm-auto labeltext f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($usuario->nombres); ?>

                                                        <?php echo e($usuario->apellidos); ?></span>
                                                </div>
                                            </div>
                                            <div class="mb-3 row dates-pets">
                                                <label
                                                    class="col-lg-4 col-md-4 col-sm-4 labeltext f-weight label-first">Email</label>
                                                <label
                                                    class="col-lg-1 col-md-1 col-sm-auto labeltext f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span class="black-main labeltext f-weight-40"><?php echo e($usuario->email); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label
                                                    class="col-lg-4 col-md-4 col-sm-4 f-weight labeltext label-first">Celular</label>
                                                <label class="col-lg-1 col-md-1 col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($usuario->celular); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label
                                                    class="col-lg-4 col-md-4 col-sm-4 f-weight labeltext label-first">Nombre
                                                    de Mascota</label>
                                                <label class="col-lg-1 col-md-1  col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($mascota->nombre_mascota); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label
                                                    class="col-lg-4 col-md-4 labeltext col-sm-4 f-weight label-first">Tipo</label>
                                                <label
                                                    class="col-lg-1 col-md-1 labeltext col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5  col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($mascota->tipo_mascota); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label
                                                    class="col-lg-4 col-md-4 labeltext col-sm-4 f-weight label-first">Peso</label>
                                                <label
                                                    class="col-lg-1 col-md-1 labeltext col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($mascota->peso_mascota); ?>

                                                        kg.</span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <label
                                                    class="col-lg-4 col-md-4 labeltext col-sm-4 f-weight label-first">Hora
                                                    de recojo</label>
                                                <label
                                                    class="col-lg-1 col-md-1 labeltext col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($recojo_ida->horario); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-5 row">
                                                <label
                                                    class="col-lg-4 col-md-4 labeltext col-sm-4 f-weight label-first">Dirección</label>
                                                <label
                                                    class="col-lg-1 col-md-1 labeltext col-sm-auto f-weight points">:</label>
                                                <div class="col-lg-6 col-md-5 col-sm-auto">
                                                    <span
                                                        class="black-main labeltext f-weight-40"><?php echo e($recojo_ida->direccion_recojo); ?></span>
                                                </div>
                                            </div>

                                            <div class="mb-3 row">
                                                <div class="col-3">

                                                    <form action="" method="POST" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" class="text-center" name="id_usuario" id="id_usuario" value="<?php echo e($objPedidos->id_usuario); ?>">
                                                        <input type="hidden" class="text-center" name="id_pedido" id="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                                        <input type="hidden" class="text-center" name="action" id="action" value="restablecer-contrasenia">
                                                        <button style="line-height: 40px;" type="submit" class="w-100 h-25 text-white nav-link border rounded bg-warning">
                                                            <i class="ri-mail-add-fill" style="margin: 0 4px"></i>
                                                            <span>Restablecer Contraseña</span>
                                                        </button>
                                                    </form>
                                                </div>
                                                <div class="col-3">

                                                    <form action="" method="POST" class="">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" class="text-center" name="id_usuario" id="id_usuario" value="<?php echo e($objPedidos->id_usuario); ?>">
                                                        <input type="hidden" class="text-center" name="action" id="action" value="eliminar">
                                                        <button style="line-height: 40px;" type="submit" class="w-100 h-25 text-white nav-link border rounded bg-danger">
                                                            <i class="ri-delete-bin-line" style="margin: 0 4px"></i>
                                                            <span>Eliminar pedido</span>
                                                        </button>
                                                    </form>
                                                </div>
                                            </div>


                                        </div>
                                        <!-- image -->
                                        <div class="col-lg-4 d-flex justify-content-center align-items-center">
                                            <div class="imagePets w-full h-full border-radius-md shadow-czi">
                                                <?php if($mascota->tipo_mascota == 'Gat@'): ?>
                                                    <img src="<?php echo e(asset('assets/img/mascotas/gato.svg')); ?>" width="170" alt="gato">
                                                <?php elseif($mascota->tipo_mascota == 'Perr@'): ?>
                                                    <img src="<?php echo e(asset('assets/img/mascotas/perro.png')); ?>" width="170" alt="perro">
                                                <?php elseif($mascota->tipo_mascota == 'Conej@'): ?>
                                                    <img src="<?php echo e(asset('assets/img/mascotas/conejo.png')); ?>" width="170" alt="conejo">
                                                <?php elseif($mascota->tipo_mascota == 'Pajarito'): ?>
                                                    <img src="<?php echo e(asset('assets/img/mascotas/pajarito.png')); ?>" width="170" alt="pajarito">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/img/mascotas/gato.svg')); ?>" width="170" alt="gato">
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card border border-radius-lg">

                                <?php if($objPedidos->pedido_activo == 0): ?>
                                    <div class="timeline-kanban p-4">
                                        <h5 class="f-weight">Activar Servicio</h5>
                                        <p>El cliente ha realizado el pago con Yape/Plim validar los pagos antes de realizar la activación del pedido.
                                            <img src="../../../assets/img/yape.png" alt="" class="me-3">
                                            <img src="../../../assets/img/plin.png" alt="">
                                        </p>
                                        <hr>
                                        <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12 border border-1 rounded mb-0 p-4">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <p><strong>Detalle de pago</strong></p>
                                                        <p class="mb-0 text-sm"><strong>Total a pagar:</strong> S/. <?php echo e($pago['total_pagar']); ?></p>
                                                        <p class="mb-0 text-sm"><strong>Metodo de pago:</strong> <?php echo e($pago['metodo_pago']); ?></p>
                                                        <p class="mb-0 text-sm"><strong>Tipo de pago:</strong> <span class="text-uppercase"> <?php echo e($pago['tipo_pago']); ?> - <?php echo e($pago['nombre_servicio']); ?> </span></p>
                                                        <p class="mb-0 text-sm"><strong>Forma de pago:</strong> <?php echo e($pago['forma_pago']); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        <div class="my-2">
                                            <p class="text-sm">Constancias:</p>
                                            <?php $__currentLoopData = $objConstancias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $constancia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(asset('storage/' . $constancia->foto)); ?>" class="me-4"
                                                   data-bs-toggle="modal" data-bs-target="#prom-<?php echo e($key); ?>">
                                                    <img src="<?php echo e(asset('storage/' . $constancia->foto)); ?>" alt=""
                                                         height="150">
                                                </a>
                                                <div class="modal modal-sm fade" id="prom-<?php echo e($key); ?>" tabindex="-1"
                                                     aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content p-4">
                                                            <img src="<?php echo e(asset('storage/' . $constancia->foto)); ?>" alt="">
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <form action="" method="POST" class="eee">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" class="text-center" name="servicio" id="servicio" value="vuelve-a-casa">
                                            <input type="hidden" class="text-center" name="id_pedido" id="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                            <input type="hidden" class="text-center" name="id_usuario" id="id_usuario" value="<?php echo e($objPedidos->id_usuario); ?>">
                                            <br/>
                                            <button type="submit" style="width: 150px" class="btn mt-1 p-1 btn-lg btn-success ">Activar</button>
                                        </form>
                                    </div>
                                <?php elseif($objPedidos->pedido_activo == 2): ?>
                                    <div class="timeline-kanban p-4">
                                        <h5 class="f-weight">Activar Servicio</h5>
                                        <p>El cliente ha realizado el pago en cuotas, validar los pagos antes de realizar la activación del pedido.</p>
                                        <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-12 border border-1 rounded mb-0 p-4">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <p><strong>Detalle de pago</strong></p>
                                                        <p class="mb-0 text-sm"><strong>Total a pagar:</strong>S/. <?php echo e($pago['total_pagar']); ?></p>
                                                        <p class="mb-0 text-sm"><strong>Metodo de pago:</strong> <?php echo e($pago['metodo_pago']); ?></p>
                                                        <p class="mb-0 text-sm text-uppercase"><strong>Tipo de pago:</strong> <span class="text-uppercase"> <?php echo e($pago['tipo_pago']); ?> - <?php echo e($pago['nombre_servicio']); ?> </span></p>
                                                        <p class="mb-0 text-sm"><strong>Forma de pago:</strong> <?php echo e($pago['forma_pago']); ?></p>
                                                        <p class="mb-0 text-sm"><strong>Número de cuotas:</strong> <?php echo e($pago['cantidad_cuotas']); ?></p>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <form action="" method="POST" class="ddd">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" class="text-center" name="servicio" id="servicio" value="siempre-juntos">
                                            <input type="hidden" class="text-center" name="id_pedido" id="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                            <input type="hidden" class="text-center" name="id_mascota" id="id_mascota" value="<?php echo e($objPedidos->id_mascota); ?>">
                                            <input type="hidden" class="text-center" name="id_usuario" id="id_usuario" value="<?php echo e($objPedidos->id_usuario); ?>">
                                            <input type="hidden" class="text-center" name="id_recojo_ida" id="id_recojo_ida" value="<?php echo e($objPedidos->id_recojo_ida); ?>">
                                            <br/>
                                            <div id="servicio-recojo-programado-info" class="px-2 mb-4">
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="card-header pt-0 px-0 pb-0 text-start">
                                                            <h5 class="f-weight">Datos para el recojo</h5>
                                                            <p>Seleccione la fecha y hora para la programación del recojo</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4 col-lg-2 mb-2">

                                                        <label for="fecha_recojo" class="text-dark form-label mb-1">Día</label>
                                                        
                                                        <input type="date" class="form-control" id="fecha_recojo" name="fecha_recojo" placeholder="Placeholder" value="">
                                                    </div>

                                                    <div class="col-md-4 col-lg-2 mb-2">
                                                        <label for="hora_recojo" class="text-dark form-label mb-1">Hora</label>
                                                        
                                                        <select class="form-select" id="hora_recojo" name="hora_recojo" aria-label="Default select example">
                                                            <option selected disabled>Seleccionar</option>

                                                            <?php if($horarios): ?>
                                                                <?php $__currentLoopData = $horarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $horario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($horario->id_horario); ?>" data-costo="<?php echo e($horario->costo); ?>" class="text-dark"><?php echo e($horario->horario); ?></option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            <?php endif; ?>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>

                                            <button type="submit" style="width: 150px" class="btn mt-1 p-1 btn-lg btn-success ">Activar</button>
                                        </form>

                                        <hr>
                                        <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kex => $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <div class="row">
                                                    <div class="col-12">
                                                        <p><strong>Boleta de pagox</strong></p>
                                                        <?php if($pago['cantidad_cuotas'] > 1): ?>
                                                            <p class="mb-0 text-sm"><strong>Número de cuota:</strong> #<?php echo e($kex + 1); ?></p>
                                                            <p class="mb-0 text-sm"><strong>Fecha de pago:</strong> <?php echo e($cuota['fecha_pagada']); ?></p>
                                                            <p class="mb-0 text-sm"><strong>Monto pagado:</strong> S/. <?php echo e($cuota['monto']); ?></p>
                                                        <?php else: ?>
                                                            <p class="mb-0 text-sm"><strong>Fecha de pago:</strong> <?php echo e($cuota['fecha_pagada']); ?></p>
                                                            <p class="mb-0 text-sm"><strong>Monto pagado:</strong> S/. <?php echo e($cuota['monto']); ?></p>
                                                        <?php endif; ?>
                                                    </div>

                                                    <div class="col-12 mt-3">
                                                        <div class="row">
                                                            <div class="col-3">
                                                                <?php if(!empty($cuota['boleta'])): ?>
                                                                    <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                        <p class="p-2 image-constance position-relative border-radius-md greese-green">
                                                                            <span class="mb-2 text-center d-block text-sm font-weight-bold">Boleta Enviada</span>
                                                                            <img src="<?php echo e(asset('assets/img/pdf.png')); ?>"
                                                                                 alt="Foto Huella"
                                                                                 width="55"
                                                                                 class="d-block mx-auto">
                                                                        </p>
                                                                    </a>
                                                                <?php else: ?>
                                                                    <p class="p-2 image-constance position-relative border-radius-md greese-green opacity-50">
                                                                        <span class="mb-2 text-center d-block text-sm font-weight-bold">Boleta no enviada</span>
                                                                        <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="55" class="d-block mx-auto">
                                                                    </p>
                                                                <?php endif; ?>
                                                            </div>
                                                            <?php if(empty($cuota['boleta'])): ?>
                                                                <div class="col-9">
                                                                    <form id="enviar-boleta" class="mt-0" method="POST" enctype="multipart/form-data" action="<?php echo e(route('subir_boleta')); ?>">
                                                                        <?php echo csrf_field(); ?>

                                                                        <input type="hidden" id="id_cuota" name="id_cuota" value="<?php echo e($cuota['id']); ?>">
                                                                        <input type="hidden" id="id_pago" name="id_pago" value="<?php echo e($pago['id_cuota_pago']); ?>">
                                                                        <input type="hidden" id="id_pedido" name="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                        <input type="hidden" id="id_user" name="id_user" value="<?php echo e($pago['user_id']); ?>">

                                                                        <div
                                                                            class="constans-content">
                                                                            <div
                                                                                class="upload-hover position-relative border-radius-md px-3 py-4">
                                                                                <label
                                                                                    for="boleta_pdf"
                                                                                    class="w-full h-full cursor-pointer top-0 start-0 position-absolute">
                                                                                    <input
                                                                                        id="boleta_pdf"
                                                                                        accept="application/pdf"
                                                                                        name="boleta_pdf"
                                                                                        type="file"
                                                                                        class="visually-hidden">
                                                                                </label>
                                                                                <div
                                                                                    class="text-center d-flex align-items-center">
                                                                                    <i class="ri-upload-cloud-2-line t-verde"
                                                                                       style="font-size: 35px;"></i>
                                                                                    <span
                                                                                        class="labeltext black-main mx-3 f-weight-50">Has clic en el botón para cargar la boleta</span>
                                                                                </div>
                                                                            </div>
                                                                            <div
                                                                                class="d-flex justify-content-between mt-2">
                                                                                <div>
                                                                                    <button
                                                                                        type="submit"
                                                                                        class="m-0 btn btn-success px-4">
                                                                                        Enviar
                                                                                    </button>
                                                                                </div>
                                                                                <div
                                                                                    class="d-flex justify-content-between">
                                                                                    <p class="text-xs f-weight-50 color-grey pe-2">
                                                                                        Formato: PDF
                                                                                    </p>
                                                                                    <p class="text-xs f-weight-50 color-grey">
                                                                                        Peso máximo:
                                                                                        2MB
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </div>
                                <?php else: ?>
                                    <div class="timeline-kanban">
                                        <h5 class="f-weight px-4 py-4">Timeline de Actividad</h5>
                                        <hr>
                                    </div>
                                    <div class="tabsNavtop admin mt-5 mb-3 ">
                                        <ul class="nav nav-tabs nav border-bottom ul-nav px-4" id="tab1Tabs"
                                            role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link w-100 text-sm " id="tab1-subtab1-tab"
                                                        data-bs-toggle="tab"
                                                        data-bs-target="#tab1-subtab1" type="button" role="tab"
                                                        aria-controls="tab1-subtab1" aria-selected="true">Conductor
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link w-100 text-sm" id="tab1-subtab2-tab"
                                                        data-bs-toggle="tab"
                                                        data-bs-target="#tab1-subtab2" type="button" role="tab"
                                                        aria-controls="tab1-subtab2" aria-selected="false">Operario
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link w-100 text-sm" id="tab1-subtab3-tab"
                                                        data-bs-toggle="tab"
                                                        data-bs-target="#tab1-subtab3" type="button" role="tab"
                                                        aria-controls="tab1-subtab3" aria-selected="false">Logistica
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link w-100 text-sm active" id="tab1-subtab4-tab"
                                                        data-bs-toggle="tab"
                                                        data-bs-target="#tab1-subtab4" type="button" role="tab"
                                                        aria-controls="tab1-subtab4" aria-selected="false">Pagos
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="tab-content" id="tab1TabsContent">
                                        <div class="tab-pane fade " id="tab1-subtab1" role="tabpanel"
                                             aria-labelledby="tab1-subtab1-tab">
                                            <div class="py-3 mx-4">
                                                <!-- Conductor -->
                                                <div>
                                                    <div class="">
                                                        <!-- recojo -->
                                                        <div class="timeline-kanban">
                                                            <h5 class="f-weight px-4 py-4">Timeline del conductor para
                                                                el recojo de la mascota</h5>
                                                            <hr>
                                                            <!-- oper asigned -->
                                                            <div class="asignado position-relative mx-4 my-4">
                                                                <p class="f-weight labeltext color-grey">Conductor
                                                                    Asignado
                                                                </p>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('conductor_confirmar_ida')); ?>"
                                                                      class="col-lg-4 col-md-6 col-12 conductor-asignado">
                                                                    <?php echo csrf_field(); ?>
                                                                    <div class="">
                                                                        <?php if($recojo_ida->id_conductor > 0): ?>
                                                                            <div class="border input-name px-2">
                                                                                <span
                                                                                    class="text-dark"><?php echo e($recojo_ida->nombres ?? ''); ?></span>
                                                                            </div>
                                                                        <?php else: ?>
                                                                            <select
                                                                                class="form-select border input-name px-2"
                                                                                name="id_conductor" id="id_conductor">
                                                                                <option value="0" disabled selected>
                                                                                    Seleccionar
                                                                                </option>
                                                                                <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conductor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <option class="text-dark"
                                                                                            value="<?php echo e($conductor->id_conductor); ?>">
                                                                                        <?php echo e($conductor->nombre_conductor); ?></option>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </select>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                    <input type="hidden" id="id_recojo" name="id_recojo"
                                                                           value="<?php echo e($recojo_ida->id_recojo); ?>">
                                                                    <input type="hidden" id="confirmacion"
                                                                           name="confirmacion" value="1">
                                                                    <?php if($recojo_ida->conductor_confirmado === 1): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn-lg btn btn-success labeltext w-full">
                                                                            Confirmado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn-lg btn btn-success labeltext w-full">
                                                                            Confirmar
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                            </div>
                                                            <!-- timeline -->
                                                            <hr>
                                                            <div class="timeline-label">
                                                                <div class="recojo-mascota pb-0">
                                                                    <!-- begin::Item 1  -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->

                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                1
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Conductor salió al
                                                                                    punto de
                                                                                    recojo</h5>
                                                                                <p class="labeltext">El conductor
                                                                                    llegara en:</p>
                                                                                <div>
                                                                                    <input disabled type="text"
                                                                                           class="form-control col-6 px-2 py-2"
                                                                                           value="<?php echo e($recojo_ida->tiempo_llegada); ?>">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if($recojo_ida->estado_etapa >= 1): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                    <!-- begin::Item 2 -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->

                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                2
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Conductor llegó al
                                                                                    punto de
                                                                                    recojo</h5>
                                                                                <p class="labeltext">He llegado al
                                                                                    punto de
                                                                                    recojo</p>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if($recojo_ida->estado_etapa >= 2): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                    <!-- begin::Item 3 -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->

                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                3
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">El recojo ha sido
                                                                                    realizado
                                                                                </h5>
                                                                                <p class="labeltext">Ha sido recogido
                                                                                    la
                                                                                    mascota de su casa</p>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if($recojo_ida->estado_etapa >= 3): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                    <!-- begin::Item 4 -->
                                                                    <div class="timeline-item item-border pt-5 ">
                                                                        <!--begin::Date-->

                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                4
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Llegada al
                                                                                    compostario</h5>
                                                                                <p class="labeltext">He llegado al
                                                                                    compostario,
                                                                                    estoy haciendo
                                                                                    entrega al operario</p>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if($recojo_ida->estado_etapa >= 4): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <hr>
                                                            <!-- timeline -->
                                                        </div>
                                                    </div>

                                                    <div class="">
                                                        <!-- ida -->
                                                        <div class="timeline-kanban">
                                                            <h5 class="f-weight px-4 py-4">Timeline del conductor para
                                                                la entrega de la maceta</h5>
                                                            <hr>
                                                            <!-- oper asigned -->
                                                            <div class="asignado position-relative mx-4 my-4">
                                                                <p class="f-weight labeltext color-grey">Conductor
                                                                    Asignado
                                                                </p>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('conductor_confirmar_ida')); ?>"
                                                                      class="col-lg-4 col-md-6 col-12 conductor-asignado">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php if(empty($recojo_vuelta->id_conductor)): ?>
                                                                        <div class="border input-name px-2">
                                                                            <span
                                                                                class="text-dark"><?php echo e($recojo_ida->nombres ?? ''); ?></span>
                                                                        </div>
                                                                    <?php else: ?>
                                                                        <select
                                                                            class="form-select border input-name px-2"
                                                                            name="id_conductor" id="id_conductor">
                                                                            <option value="0" disabled selected>
                                                                                Seleccionar
                                                                            </option>
                                                                            <?php $__currentLoopData = $conductores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $conductor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option class="text-dark"
                                                                                        value="<?php echo e($conductor->id_conductor); ?>">
                                                                                    <?php echo e($conductor->nombre_conductor); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    <?php endif; ?>
                                                                    <input type="hidden" id="id_recojo" name="id_recojo"
                                                                           value="<?php echo e($recojo_vuelta->id_recojo ?? ''); ?>">
                                                                    <input type="hidden" id="confirmacion"
                                                                           name="confirmacion" value="1">
                                                                    <?php if(empty($recojo_vuelta->conductor_confirmado)): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn-lg btn btn-success labeltext w-full">
                                                                            Confirmado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn-lg btn btn-success labeltext w-full">
                                                                            Confirmar
                                                                        </button>
                                                                    <?php endif; ?>

                                                                </form>
                                                            </div>


                                                            <!-- timeline -->
                                                            <hr>
                                                            <div class="timeline-label">
                                                                <div class="recojo-mascota pb-0">
                                                                    <!-- begin::Item 1  -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->
                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                1
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">El recojo de la
                                                                                    maceta ha sido realizado
                                                                                </h5>
                                                                                <p class="labeltext"></p>
                                                                            </div>
                                                                        </div>

                                                                        <div>
                                                                            <?php if(!empty($recojo_vuelta) && $recojo_vuelta->estado_etapa >= 1): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>

                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                    <!-- begin::Item 2 -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->
                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                2
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Salió de la
                                                                                    oficina para
                                                                                    entregar maceta</h5>

                                                                                <p class="labeltext">El conductor
                                                                                    llegara en:</p>
                                                                                <div>
                                                                                    <?php if(!empty($recojo_vuelta->tiempo_llegada)): ?>
                                                                                        <input disabled type="text"
                                                                                               class="form-control col-6 px-2 py-2"
                                                                                               value="<?php echo e($recojo_vuelta->tiempo_llegada); ?>">
                                                                                    <?php endif; ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div>
                                                                            <?php if(!empty($recojo_vuelta) && $recojo_vuelta->estado_etapa >= 2): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                    <!-- begin::Item 3 -->
                                                                    <div
                                                                        class="timeline-item item-border pt-5 border-bottom">
                                                                        <!--begin::Date-->
                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                3
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Llegada al
                                                                                    lugar de entrega
                                                                                </h5>
                                                                                <p class="labeltext"></p>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if(!empty($recojo_vuelta) && $recojo_vuelta->estado_etapa >= 3): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                    <!-- begin::Item 4 -->
                                                                    <div class="timeline-item item-border pt-5 ">
                                                                        <!--begin::Date-->
                                                                        <!--begin::Badge-->
                                                                        <div class="timeline-badge">
                                                                            <div
                                                                                class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                                4
                                                                            </div>
                                                                        </div>
                                                                        <div class="timeline-content w-90">
                                                                            <div
                                                                                class="timeline-activity card-body p-0">
                                                                                <h5 class="f-weight">Se entregó la
                                                                                    maceta</h5>
                                                                                <p class="labeltext"></p>
                                                                                <?php if(!empty($recojo_vuelta->foto_entrega)): ?>
                                                                                    <p class="p-2 image-constance position-relative border-radius-md greese-green d-flex justify-content-center">
                                                                                        <a href="<?php echo e(asset('storage/' . $recojo_vuelta->foto_entrega)); ?>"
                                                                                           target="_blank">
                                                                                            <img
                                                                                                src="<?php echo e(asset('storage/' . $recojo_vuelta->foto_entrega)); ?>"
                                                                                                alt="Foto Huella"
                                                                                                width="150"
                                                                                                class="d-block mx-auto">
                                                                                        </a>
                                                                                    </p>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </div>
                                                                        <div>
                                                                            <?php if(!empty($recojo_vuelta) && $recojo_vuelta->estado_etapa >= 4): ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-success labeltext">
                                                                                    Realizado
                                                                                </button>
                                                                            <?php else: ?>
                                                                                <button role="button" disabled
                                                                                        type="submit"
                                                                                        class="btn btn-outline-dark">
                                                                                    Pendiente
                                                                                </button>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                        <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                                    </div>
                                                                </div>
                                                            </div>

                                                            <!-- timeline -->


                                                        </div>

                                                        <!-- recojo -->


                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade " id="tab1-subtab2" role="tabpanel"
                                             aria-labelledby="tab1-subtab2-tab">
                                            <div class="py-3 mx-4">
                                                <!-- compostaje -->
                                                <div class="timeline-kanban">
                                                    <h5 class="f-weight px-4 py-4">Timeline de compostaje y
                                                        cosecha </h5>
                                                    <hr>
                                                    <!-- oper asigned -->
                                                    <div class="asignado position-relative mx-4 my-4">
                                                        <p class="f-weight labeltext color-grey">Operario Asignado</p>

                                                        <form method="POST" action="<?php echo e(route('confirmar_operario')); ?>"
                                                              class="col-lg-4 col-md-6 col-12 conductor-asignado">
                                                            <?php echo csrf_field(); ?>
                                                            <div class="">
                                                                <?php if(isset($objCompostajes) && $objCompostajes->operario_confirmado === 1): ?>
                                                                    <div class="border input-name px-2">
                                                                        <span
                                                                            class="text-dark"><?php echo e($objCompostajes->nombres); ?></span>
                                                                    </div>
                                                                <?php else: ?>
                                                                    <select class="form-select border input-name px-2"
                                                                            name="id_operario" id="id_operario">
                                                                        <option value="0" disabled selected>Seleccionar
                                                                        </option>
                                                                        <?php $__currentLoopData = $operarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $operario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <option class="text-dark"
                                                                                    value="<?php echo e($operario->id_operario); ?>">
                                                                                <?php echo e($operario->nombres); ?></option>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </select>
                                                                <?php endif; ?>
                                                            </div>

                                                            <?php if(isset($objCompostajes)): ?>
                                                                <input type="hidden" id="id_compostaje" name="id_compostaje" value="<?php echo e($objCompostajes->id_compostaje); ?>">
                                                            <?php endif; ?>
                                                            <input type="hidden" id="confirmacion" name="confirmacion" value="1">
                                                            <?php if(isset($objCompostajes) && $objCompostajes->operario_confirmado === 1): ?>
                                                                <button role="button" disabled type="submit" class="btn-lg btn btn-success labeltext w-full">Confirmado</button>
                                                            <?php else: ?>
                                                                <button role="button" type="submit" class="btn-lg btn btn-success labeltext w-full">Confirmar</button>
                                                            <?php endif; ?>


                                                        </form>
                                                    </div>

                                                    <!-- timeline -->
                                                    <hr>
                                                    <div class="timeline-label">
                                                        <div class="recojo-mascota">
                                                            <!-- begin::Item 1  -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        1
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Recepción de Mascota</h5>
                                                                        <p class="labeltext">
                                                                            <?php echo e($mascota->nombre_mascota); ?> ha
                                                                            llegado bien
                                                                            al compostario</p>
                                                                    </div>
                                                                </div>
                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 1): ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-success labeltext">Realizado
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-outline-dark">Pendiente
                                                                    </button>
                                                                <?php endif; ?>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <!-- begin::Item 2 -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        2
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Subir foto del print de la
                                                                            huella de la mascota</h5>
                                                                        <p class="labeltext">Foto de la huella:</p>
                                                                        <div class="col-4">
                                                                            <?php if(isset($objCompostajes) && $objCompostajes->foto_huella): ?>
                                                                                <p class="p-2 image-constance position-relative mb-0 border-radius-md greese-green d-flex justify-content-center">
                                                                                    <a href="<?php echo e(asset('storage/' . $objCompostajes->foto_huella)); ?>"
                                                                                       target="_blank">
                                                                                        <img
                                                                                            src="<?php echo e(asset('storage/' . $objCompostajes->foto_huella)); ?>"
                                                                                            alt="Foto Huella"
                                                                                            width="150"
                                                                                            class="d-block mx-auto">
                                                                                    </a>
                                                                                </p>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 2): ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-success labeltext">Realizado
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-outline-dark">Pendiente
                                                                    </button>
                                                                <?php endif; ?>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        3
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Subir foto de la mascota en
                                                                            la cuna lista</h5>
                                                                        <p class="labeltext">Foto de la mascota:</p>
                                                                        <div class="col-4">
                                                                            <?php if(isset($objCompostajes) && $objCompostajes->foto_cunalista): ?>
                                                                                <p class="p-2 image-constance position-relative mb-0 border-radius-md greese-green d-flex justify-content-center">
                                                                                    <a href="<?php echo e(asset('storage/' . $objCompostajes->foto_cunalista)); ?>"
                                                                                       target="_blank">
                                                                                        <img
                                                                                            src="<?php echo e(asset('storage/' . $objCompostajes->foto_cunalista)); ?>"
                                                                                            alt="Foto Huella"
                                                                                            width="150"
                                                                                            class="d-block mx-auto">
                                                                                    </a>
                                                                                </p>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 3): ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-success labeltext">Realizado
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-outline-dark">Pendiente
                                                                    </button>
                                                                <?php endif; ?>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <!-- begin::Item 3 -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        5
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div>
                                                                        <form method="POST"
                                                                              action="<?php echo e(route('registro_actividad_operario_paso3')); ?>"
                                                                              class="d-flex">
                                                                            <div
                                                                                class="timeline-activity card-body p-0 w-90">
                                                                                <?php echo csrf_field(); ?>
                                                                                <input type="hidden" id="id_compostaje"
                                                                                       name="id_compostaje"
                                                                                       value="<?php echo e($objCompostajes->id_compostaje ??''); ?>">
                                                                                <input type="hidden" id="estado_etapa"
                                                                                       name="estado_etapa" value="3">
                                                                                <h5 class="f-weight">Fecha de inicio de
                                                                                    compostaje</h5>
                                                                                <p class="labeltext">Inicio de
                                                                                    compost</p>
                                                                                <!-- Time & Our -->
                                                                                <?php if(isset($objCompostajes->inicio_fecha) && isset($objCompostajes->inicio_hora)): ?>
                                                                                    <div class="row mt-5">
                                                                                        <div class="col-xl-10">
                                                                                            <div class="row pb-4">
                                                                                                <!-- input date -->
                                                                                                <?php if(isset($objCompostajes->inicio_fecha)): ?>
                                                                                                    <div
                                                                                                        class="col-xl-6">
                                                                                                        <div
                                                                                                            class="caler-selec">
                                                                                                            <label
                                                                                                                for="staticEmail"
                                                                                                                class="f-weight mb-1 labeltext">Fecha</label>
                                                                                                            <div
                                                                                                                class="field-date">
                                                                                                                <input
                                                                                                                    disabled
                                                                                                                    type="text"
                                                                                                                    class="form-control col-xl-12 px-2 py-2"
                                                                                                                    value="<?php echo e($objCompostajes->inicio_fecha); ?>">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                <?php endif; ?>

                                                                                                <!-- input time -->
                                                                                                <?php if(isset($objCompostajes->inicio_hora)): ?>
                                                                                                    <div
                                                                                                        class="col-xl-6">
                                                                                                        <div
                                                                                                            class="our-selec">
                                                                                                            <label
                                                                                                                for="staticEmail"
                                                                                                                class="f-weight mb-1 labeltext">Hora</label>
                                                                                                            <div
                                                                                                                class="field-date">
                                                                                                                <input
                                                                                                                    disabled
                                                                                                                    type="text"
                                                                                                                    class="form-control col-xl-12 px-2 py-2"
                                                                                                                    value="<?php echo e($objCompostajes->inicio_hora); ?>">
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endif; ?>

                                                                            </div>
                                                                            <div>
                                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 5): ?>
                                                                                    <button role="button" disabled
                                                                                            type="submit"
                                                                                            class="btn btn-success labeltext">
                                                                                        Realizado
                                                                                    </button>
                                                                                <?php else: ?>
                                                                                    <button role="button" disabled
                                                                                            type="submit"
                                                                                            class="btn btn-outline-dark">
                                                                                        Pendiente
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                    <?php if($ultimoNumero > 1): ?>
                                                                        <!-- Monitoreo 1 -->
                                                                        <div class="w-full position-relative mt-3">
                                                                            <div class="row">
                                                                                <div id="contenedorMonitoreo"
                                                                                     class="monitoreo">
                                                                                    <?php $__currentLoopData = $monitoreos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $monitoreo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <?php echo $__env->make(
                                                                                            'components.monitoreo-form',
                                                                                            [
                                                                                                'operario' =>
                                                                                                    $operario->id_operario,
                                                                                                'mascota' =>
                                                                                                    $mascota->id_mascota,
                                                                                                'compostaje' =>
                                                                                                    $objCompostajes->id_compostaje,
                                                                                                'count' =>
                                                                                                    $index + 1,
                                                                                                'monitoreo' => $monitoreo,
                                                                                            ]
                                                                                        , \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </div>

                                                                            </div>
                                                                        </div>
                                                                    <?php endif; ?>


                                                                </div>

                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        4
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Subir foto de la mascota
                                                                            antes de tapar la cuna</h5>
                                                                        <p class="labeltext">Foto de la mascota:</p>
                                                                        <div class="col-4">
                                                                            <?php if(isset($objCompostajes) && $objCompostajes->foto_cunatapar): ?>
                                                                                <p class="p-2 image-constance position-relative mb-0 border-radius-md greese-green d-flex justify-content-center">
                                                                                    <a href="<?php echo e(asset('storage/' . $objCompostajes->foto_cunatapar)); ?>"
                                                                                       target="_blank">
                                                                                        <img
                                                                                            src="<?php echo e(asset('storage/' . $objCompostajes->foto_cunatapar)); ?>"
                                                                                            alt="Foto Huella"
                                                                                            width="150"
                                                                                            class="d-block mx-auto">
                                                                                    </a>
                                                                                </p>
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 4): ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-success labeltext">Realizado
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-outline-dark">Pendiente
                                                                    </button>
                                                                <?php endif; ?>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                            <!-- begin::Item 4 -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        6
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div>
                                                                        <form method="POST"
                                                                              action="<?php echo e(route('registro_actividad_operario_paso4')); ?>"
                                                                              class="d-flex">
                                                                            <?php echo csrf_field(); ?>
                                                                            <input type="hidden" id="id_compostaje"
                                                                                   name="id_compostaje"
                                                                                   value="<?php echo e($objCompostajes->id_compostaje ?? ''); ?>">
                                                                            <input type="hidden" id="estado_etapa"
                                                                                   name="estado_etapa" value="4">
                                                                            <div
                                                                                class="timeline-activity card-body p-0 w-90">
                                                                                <h5 class="f-weight">Fecha de fin de compostaje
                                                                                </h5>
                                                                                <?php if(isset($objCompostajes->fin_tentativo)): ?>
                                                                                    <!-- date one -->
                                                                                    <div class="row mt-5">
                                                                                        <div class="col-xl-9">
                                                                                            <div class="row pb-4">
                                                                                                <!-- input date -->
                                                                                                <div class="col-xl-6">
                                                                                                    <div
                                                                                                        class="caler-selec">
                                                                                                        <label
                                                                                                            for="staticEmail"
                                                                                                            class="f-weight mb-1 labeltext">Fecha
                                                                                                            Tentativa</label>
                                                                                                        <div
                                                                                                            class="field-date">
                                                                                                            <?php if(isset($objCompostajes->fin_tentativo)): ?>
                                                                                                                <input
                                                                                                                    disabled
                                                                                                                    type="text"
                                                                                                                    class="form-control col-xl-12 px-2 py-2"
                                                                                                                    value="<?php echo e($objCompostajes->fin_tentativo); ?>">
                                                                                                            <?php endif; ?>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>

                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endif; ?>
                                                                                <?php if(isset($objCompostajes->fin_fecha)): ?>
                                                                                    <!-- Time & Our -->
                                                                                    <div class="row">
                                                                                        <div class="col-xl-9">
                                                                                            <div class="row pb-4">
                                                                                                <!-- input date -->
                                                                                                <div class="col-xl-6">
                                                                                                    <div
                                                                                                        class="caler-selec">
                                                                                                        <label
                                                                                                            for="staticEmail"
                                                                                                            class="f-weight mb-1 labeltext">Fecha</label>
                                                                                                        <div
                                                                                                            class="field-date">
                                                                                                            <?php if(isset($objCompostajes->fin_fecha)): ?>
                                                                                                                <input
                                                                                                                    disabled
                                                                                                                    type="text"
                                                                                                                    class="form-control col-xl-12 px-2 py-2"
                                                                                                                    value="<?php echo e($objCompostajes->fin_fecha); ?>">
                                                                                                            <?php endif; ?>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>

                                                                                                <!-- input time -->
                                                                                                <div class="col-xl-6 d-none">
                                                                                                    <div
                                                                                                        class="our-selec">
                                                                                                        <label
                                                                                                            for="staticEmail"
                                                                                                            class="f-weight mb-1 labeltext">Hora</label>
                                                                                                        <div
                                                                                                            class="field-date">
                                                                                                            <?php if(isset($objCompostajes->fin_hora)): ?>
                                                                                                                <input
                                                                                                                    disabled
                                                                                                                    type="text"
                                                                                                                    class="form-control col-xl-12 px-2 py-2"
                                                                                                                    value="<?php echo e($objCompostajes->fin_hora); ?>">
                                                                                                            <?php else: ?>
                                                                                                                <input
                                                                                                                    type="time"
                                                                                                                    class="col-xl-12 px-2 py-2 form-control"
                                                                                                                    id="fin_hora"
                                                                                                                    name="fin_hora"
                                                                                                                    onfocus="focused(this)"
                                                                                                                    onfocusout="defocused(this)">
                                                                                                            <?php endif; ?>
                                                                                                            <label
                                                                                                                for=""
                                                                                                                class=""></label>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endif; ?>
                                                                                <?php if(isset($objCompostajes->peso_cosecha)): ?>
                                                                                    <!-- cosecha -->
                                                                                    <div class="row">
                                                                                        <div class="col-xl-9">
                                                                                            <div class="row pb-4">
                                                                                                <!-- cosecha -->
                                                                                                <div class="col-md-6">
                                                                                                    <div
                                                                                                        class="caler-selec">
                                                                                                        <label
                                                                                                            for="staticEmail"
                                                                                                            class="f-weight mb-1 labeltext">Peso
                                                                                                            total
                                                                                                            de
                                                                                                            cosecha</label>
                                                                                                        <div
                                                                                                            class="d-md-flex">
                                                                                                            <div
                                                                                                                class="d-block col-md-8 me-md-3">
                                                                                                                <?php if(isset($objCompostajes->peso_cosecha)): ?>
                                                                                                                    <input
                                                                                                                        disabled
                                                                                                                        type="text"
                                                                                                                        class="form-control col-xl-12 px-2 py-2"
                                                                                                                        value="<?php echo e($objCompostajes->peso_cosecha); ?>">
                                                                                                                <?php endif; ?>
                                                                                                            </div>
                                                                                                            <div
                                                                                                                class="d-block col-md-3">
                                                                                                                <div
                                                                                                                    class="position-relative cosecha-label">

                                                                                                                    <input
                                                                                                                        type="text"
                                                                                                                        class="form-control form-control-alternative"
                                                                                                                        disabled=""
                                                                                                                        onfocus="focused(this)"
                                                                                                                        onfocusout="defocused(this)">
                                                                                                                    <label
                                                                                                                        for=""
                                                                                                                        class="f-weight">Kg.</label>

                                                                                                                </div>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <!-- restos -->
                                                                                                <div class="col-md-6 d-none">
                                                                                                    <div
                                                                                                        class="caler-selec">
                                                                                                        <label
                                                                                                            for="staticEmail"
                                                                                                            class="f-weight mb-1 labeltext">Peso
                                                                                                            total
                                                                                                            de
                                                                                                            restos</label>
                                                                                                        <div
                                                                                                            class="d-md-flex">
                                                                                                            <div
                                                                                                                class="d-block col-md-8 me-md-3">
                                                                                                                <?php if(isset($objCompostajes->peso_restos)): ?>
                                                                                                                    <input
                                                                                                                        disabled
                                                                                                                        type="text"
                                                                                                                        class="form-control col-xl-12 px-2 py-2"
                                                                                                                        value="<?php echo e($objCompostajes->peso_restos); ?>">
                                                                                                                <?php else: ?>
                                                                                                                    <input
                                                                                                                        type="text"
                                                                                                                        class="form-control col-xl-12 px-2 py-2"
                                                                                                                        id="peso_restos"
                                                                                                                        name="peso_restos"
                                                                                                                        onfocus="focused(this)"
                                                                                                                        onfocusout="defocused(this)">
                                                                                                                <?php endif; ?>
                                                                                                            </div>
                                                                                                            <div
                                                                                                                class="d-block col-md-3">
                                                                                                                <div
                                                                                                                    class="position-relative cosecha-label">
                                                                                                                    <input
                                                                                                                        type="text"
                                                                                                                        class="form-control form-control-alternative"
                                                                                                                        disabled=""
                                                                                                                        onfocus="focused(this)"
                                                                                                                        onfocusout="defocused(this)">
                                                                                                                    <label
                                                                                                                        for=""
                                                                                                                        class="f-weight">Kg.</label>
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                            <div>
                                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 6): ?>
                                                                                    <button role="button" disabled
                                                                                            type="submit"
                                                                                            class="btn btn-success labeltext">
                                                                                        Realizado
                                                                                    </button>
                                                                                <?php else: ?>
                                                                                    <button role="button" disabled
                                                                                            type="submit"
                                                                                            class="btn btn-outline-dark">
                                                                                        Pendiente
                                                                                    </button>
                                                                                <?php endif; ?>
                                                                            </div>

                                                                        </form>
                                                                    </div>
                                                                </div>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <!-- begin::Item 5 -->
                                                            <div class="timeline-item item-border pt-5 border-bottoms">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        4
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Entrega de Compost para
                                                                            envió a oficina
                                                                        </h5>
                                                                        <p class="labeltext">Mascota trasladado del
                                                                            compostario
                                                                            a oficina
                                                                        </p>
                                                                    </div>
                                                                </div>

                                                                <?php if(isset($objCompostajes) && $objCompostajes->estado_etapa >= 7): ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-success labeltext">Realizado
                                                                    </button>
                                                                <?php else: ?>
                                                                    <button role="button" disabled type="submit"
                                                                            class="btn btn-outline-dark">Pendiente
                                                                    </button>
                                                                <?php endif; ?>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <!-- timeline -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="tab1-subtab3" role="tabpanel"
                                             aria-labelledby="tab1-subtab3-tab">
                                            <div class="py-3 mx-4">
                                                <div class="timeline-kanban">
                                                    <h5 class="f-weight px-4 py-4">Timeline de logistica:</h5>

                                                    <!-- timeline -->
                                                    <hr>
                                                    <div class="timeline-label">
                                                        <div class="recojo-mascota">
                                                            <!-- begin::Item 1  -->

                                                            <!-- begin::Item 1  -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        2
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Traslado de compost y
                                                                            huellas a la oficina </h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('registro_actividadlogistica')); ?>"
                                                                      class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_pedido" name="id_pedido"
                                                                           value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="estado_logistica"
                                                                           name="estado_logistica" value="1">
                                                                    <input type="hidden" id="inicio_logistica"
                                                                           name="inicio_logistica" value="1">

                                                                    <?php if($objPedidos->estado_logistica >= 1): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>

                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>
                                                            <!-- begin::Item 2 -->
                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        3
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Se recibió el compost y
                                                                            huellas en oficina</h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('registro_actividadlogistica')); ?>"
                                                                      class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_pedido" name="id_pedido"
                                                                           value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="estado_logistica"
                                                                           name="estado_logistica" value="2">
                                                                    <?php if($objPedidos->estado_logistica >= 2): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>


                                                            <!-- begin::Item 3 -->

                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        4
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Se recibió la maceta</h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('registro_actividadlogistica')); ?>"
                                                                      class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_pedido" name="id_pedido"
                                                                           value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="estado_logistica"
                                                                           name="estado_logistica" value="3">
                                                                    <?php if($objPedidos->estado_logistica >= 3): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                            <!-- begin::Item 4 -->

                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        5
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Se recibió los pedidos
                                                                            extras</h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('registro_actividadlogistica')); ?>"
                                                                      class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_pedido" name="id_pedido"
                                                                           value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="estado_logistica"
                                                                           name="estado_logistica" value="4">
                                                                    <?php if($objPedidos->estado_logistica >= 4): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                            <!-- begin::Item 5 -->

                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        6
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Pedido listo para entregar</h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST" action="<?php echo e(route('registro_actividadlogistica')); ?>" class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="estado_logistica" name="estado_logistica" value="5">
                                                                    <input type="hidden" id="id_usuario" name="id_usuario" value="<?php echo e($objPedidos->id_usuario); ?>">
                                                                    <input type="hidden" id="id_pedido" name="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="email" name="email" value="<?php echo e($usuario->email); ?>">
                                                                    <input type="hidden" id="nombre_usuario" name="nombre_usuario" value="<?php echo e($usuario->nombres); ?> <?php echo e($usuario->apellidos); ?>">
                                                                    <input type="hidden" id="nombre_mascota" name="nombre_mascota" value="<?php echo e($mascota->nombre_mascota); ?>">
                                                                    <?php if($objPedidos->estado_logistica >= 5): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                            <!-- begin::Item 6 -->

                                                            <div class="timeline-item item-border pt-5 border-bottom">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        7
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Cliente eligió la fecha
                                                                            para la entrega</h5>
                                                                        <?php

                                                                            // dd($recojo_vuelta);

                                                                            if(!empty($recojo_vuelta->fecha_recojo)){

                                                                                $fechaBase = Carbon::parse($recojo_vuelta->fecha_recojo);

                                                                                $fechaFormateada = ucfirst($fechaBase->translatedFormat('l, d \d\e F \d\e\l Y'));
                                                                            }else{
                                                                                $fechaFormateada = 'Aun no ha registrado fecha de recojo el cliente';
                                                                            }
                                                                            // 2025-03-14

                                                                        ?>


                                                                        <p class="labeltext mb-2">Fecha para la
                                                                            entrega</p>
                                                                        <div class="border input-name px-2 w-50">

                                                                            <p class="text-dark mb-0 text-xs"><?php echo e($fechaFormateada); ?></p>
                                                                        </div>


                                                                    </div>
                                                                </div>
                                                                <form method="POST" action="" class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_recojo" name="id_recojo"
                                                                           value="">
                                                                    <input type="hidden" id="estado_etapa"
                                                                           name="estado_etapa" value="2">
                                                                    <input type="hidden" id="email" name="email"
                                                                           value="">
                                                                    <?php if(!empty($recojo_vuelta->direccion_recojo)): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                            <!-- begin::Item 7 -->

                                                            <div class="timeline-item item-border pt-5">
                                                                <!--begin::Date-->

                                                                <!--begin::Badge-->
                                                                <div class="timeline-badge">
                                                                    <div
                                                                        class="text-center rounded-circle badge-circle border labeltext black-main c-princi">
                                                                        8
                                                                    </div>
                                                                </div>
                                                                <div class="timeline-content w-90">
                                                                    <div class="timeline-activity card-body p-0">
                                                                        <h5 class="f-weight">Entregado a conductor para
                                                                            el envió</h5>
                                                                        
                                                                    </div>
                                                                </div>
                                                                <form method="POST"
                                                                      action="<?php echo e(route('registro_actividadlogistica')); ?>"
                                                                      class="">
                                                                    <?php echo csrf_field(); ?>
                                                                    <input type="hidden" id="id_pedido" name="id_pedido"
                                                                           value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                    <input type="hidden" id="estado_logistica"
                                                                           name="estado_logistica" value="7">
                                                                    <?php if($objPedidos->estado_logistica >= 7): ?>
                                                                        <button role="button" disabled type="submit"
                                                                                class="btn btn-success labeltext">
                                                                            Realizado
                                                                        </button>
                                                                    <?php else: ?>
                                                                        <button role="button" type="submit"
                                                                                class="btn btn-outline-dark">Realizado
                                                                        </button>
                                                                    <?php endif; ?>
                                                                </form>
                                                                <!-- <a href="" class="btn btn-outline-dark">Realizado</a> -->
                                                            </div>

                                                        </div>
                                                    </div>

                                                    <!-- timeline -->

                                                </div>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade show active" id="tab1-subtab4" role="tabpanel" aria-labelledby="tab1-subtab3-tab">
                                            <div class="py-3 mx-4">
                                                <div class="timeline-kanban">
                                                    <h5 class="f-weight px-4 py-4">Pagos:</h5>
                                                    <hr>
                                                    <div class="timeline-labelx p-4">
                                                        <div class="row">
                                                            <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <div class="col-12 border border-1 rounded mb-0 p-4">
                                                                    <div class="row">
                                                                        <div class="col-3">
                                                                            <p><strong>Detalle de pago</strong></p>
                                                                            <p class="mb-0 text-sm"><strong>Total a pagar:</strong> S/. <?php echo e($pago['total_pagar']); ?></p>
                                                                            <p class="mb-0 text-sm"><strong>Metodo de pago:</strong> <?php echo e($pago['metodo_pago']); ?></p>
                                                                            <p class="mb-0 text-sm text-uppercase"><strong>Tipo de pago:</strong> <span class="text-uppercase"> <?php echo e($pago['tipo_pago']); ?> - <?php echo e($pago['nombre_servicio']); ?> </span>
                                                                            </p>
                                                                            <p class="mb-0 text-sm"><strong>Forma de pago:</strong> <?php echo e($pago['forma_pago']); ?></p>
                                                                        </div>
                                                                        <div class="col-3">
                                                                            <p><strong>Constancias de pago</strong></p>
                                                                            <?php
                                                                                $objConstancia = DB::table('pagos_constancias')->where('id_pago', $pago['id'])->get();
                                                                            ?>

                                                                            <div class="d-flex flex-wrap mb-3">
                                                                                <?php $__currentLoopData = $objConstancia; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $constancia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <a href="<?php echo e(asset('storage/' . $constancia->foto)); ?>"
                                                                                       class="me-4 mb-2 border p-2 d-block rounded"
                                                                                       data-bs-toggle="modal"
                                                                                       data-bs-target="#prom-<?php echo e($key); ?>">
                                                                                        <img src="<?php echo e(asset('storage/' . $constancia->foto)); ?>" alt="" height="60">
                                                                                    </a>
                                                                                    <div class="modal modal-sm fade"
                                                                                         id="prom-<?php echo e($key); ?>"
                                                                                         tabindex="-1"
                                                                                         aria-hidden="true">
                                                                                        <div class="modal-dialog">
                                                                                            <div
                                                                                                class="modal-content p-4">
                                                                                                <img
                                                                                                    src="<?php echo e(asset('storage/' . $constancia->foto)); ?>"
                                                                                                    alt="" height="600"
                                                                                                    class="img-fluid">
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </div>
                                                                            <div class="">
                                                                                <?php if($pago['metodo_pago'] == 'transferencia'): ?>
                                                                                    <p class="font-weight-bold text-md mb-0">
                                                                                        <img src="../../../assets/img/yape.png" alt="" class="me-3"><img src="../../../assets/img/plin.png" alt=""></p>
                                                                                <?php else: ?>
                                                                                    <p class="font-weight-bold text-md mb-0">
                                                                                        <img src="../../../assets/img/master.png" alt="" class="me-3"><img src="../../../assets/img/visa.png" alt=""></p>
                                                                                <?php endif; ?>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                                <div class="col-12 mt-3">
                                                                    <div class="row">
                                                                        <div class="col-8">
                                                                            <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                

                                                                                <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kex => $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <div class="row">
                                                                                        <div class="col-12">
                                                                                            <p><strong>Boleta de pago</strong></p>
                                                                                            <?php if($pago['cantidad_cuotas'] > 1): ?>
                                                                                                <p class="mb-0 text-sm"><strong>Número de cuota:</strong> #<?php echo e($kex + 1); ?></p>
                                                                                                <p class="mb-0 text-sm"><strong>Fecha de pago:</strong> <?php echo e($cuota['fecha_pagada']); ?></p>
                                                                                                <p class="mb-0 text-sm"><strong>Monto pagado:</strong> S/. <?php echo e($cuota['monto']); ?></p>
                                                                                            <?php else: ?>
                                                                                                <p class="mb-0 text-sm"><strong>Fecha de pago:</strong> <?php echo e($cuota['fecha_pagada']); ?></p>
                                                                                                <p class="mb-0 text-sm"><strong>Monto pagado:</strong> S/. <?php echo e($cuota['monto']); ?></p>
                                                                                            <?php endif; ?>
                                                                                        </div>

                                                                                        <div class="col-12 mt-3">
                                                                                            <div class="row">
                                                                                                <div class="col-3">
                                                                                                    <?php if(!empty($cuota['boleta'])): ?>
                                                                                                        <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>"
                                                                                                           target="_blank">
                                                                                                            <p class="p-2 image-constance position-relative border-radius-md greese-green">
                                                                                                                <span class="mb-2 text-center d-block text-sm font-weight-bold">Boleta Enviada</span>
                                                                                                                <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="80" class="d-block mx-auto">
                                                                                                            </p>
                                                                                                        </a>
                                                                                                    <?php else: ?>
                                                                                                        <p class="p-2 image-constance position-relative border-radius-md greese-green opacity-50">
                                                                                                            <span class="mb-2 text-center d-block text-sm font-weight-bold">Boleta no enviada</span>
                                                                                                            <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="80" class="d-block mx-auto">
                                                                                                        </p>
                                                                                                    <?php endif; ?>
                                                                                                </div>
                                                                                                <?php if(empty($cuota['boleta'])): ?>
                                                                                                    <div class="col-9">
                                                                                                        <form id="enviar-boleta" class="mt-0" method="POST" enctype="multipart/form-data" action="<?php echo e(route('subir_boleta')); ?>">
                                                                                                            <?php echo csrf_field(); ?>
                                                                                                            <input type="hidden" id="id_cuota" name="id_cuota" value="<?php echo e($cuota['id']); ?>">
                                                                                                            <input type="hidden" id="id_pago" name="id_pago" value="<?php echo e($pago['id_cuota_pago']); ?>">
                                                                                                            <input type="hidden" id="id_pedido" name="id_pedido" value="<?php echo e($objPedidos->id_pedido); ?>">
                                                                                                            <input type="hidden" id="id_user" name="id_user" value="<?php echo e($pago['user_id']); ?>">
                                                                                                            <div
                                                                                                                class="constans-content">
                                                                                                                <div
                                                                                                                    class="upload-hover position-relative border-radius-md px-3 py-4">
                                                                                                                    <label
                                                                                                                        for="boleta_pdf"
                                                                                                                        class="w-full h-full cursor-pointer top-0 start-0 position-absolute">
                                                                                                                        <input
                                                                                                                            id="boleta_pdf"
                                                                                                                            accept="application/pdf"
                                                                                                                            name="boleta_pdf"
                                                                                                                            type="file"
                                                                                                                            class="visually-hidden">
                                                                                                                    </label>
                                                                                                                    <div
                                                                                                                        class="text-center d-flex align-items-center">
                                                                                                                        <i class="ri-upload-cloud-2-line t-verde"
                                                                                                                           style="font-size: 35px;"></i>
                                                                                                                        <span
                                                                                                                            class="labeltext black-main mx-3 f-weight-50">Has clic en el botón para cargar la boleta</span>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                                <div
                                                                                                                    class="d-flex justify-content-between mt-2">
                                                                                                                    <div>
                                                                                                                        <button
                                                                                                                            type="submit"
                                                                                                                            class="m-0 btn btn-success px-4">
                                                                                                                            Enviar
                                                                                                                        </button>
                                                                                                                    </div>
                                                                                                                    <div
                                                                                                                        class="d-flex justify-content-between">
                                                                                                                        <p class="text-xs f-weight-50 color-grey pe-2">
                                                                                                                            Formato: PDF
                                                                                                                        </p>
                                                                                                                        <p class="text-xs f-weight-50 color-grey">
                                                                                                                            Peso máximo:
                                                                                                                            2MB
                                                                                                                        </p>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </div>
                                                                                                        </form>
                                                                                                    </div>
                                                                                                <?php endif; ?>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>

                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </div>
                                                    </div>


                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>


                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.useradministrador', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/admin/compostario_id.blade.php ENDPATH**/ ?>