<section id="tab4" class="tab-panel">
    <div class="row mb-5">
        <div class="col-md-12">
            <h5 class="f-weight mb-4 text-dark">Resumen de pagos</h5>
        </div>
        <div class="col-md-12">

            <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $cuotasPagadas = collect($pago['cuotas'])->keyBy('numero_cuota');
                    $montoPorCuota = $pago['total_pagar'] / $pago['cantidad_cuotas'];
                    // Fecha base: la de la primera cuota pagada
                    $fechaInicio = $cuotasPagadas->first()['fecha_pagada'] ?? now();
//                    @dd($pagadasPorNumero);
                ?>

                <?php if($pago['forma_pago'] == 'cuotas' ): ?>
                    <div class="">
                        <div class="card z-index-2 shadow-lg">
                            <div class="row m-2 my-3">
                                <div class="col-md-8">
                                    <div class="row">
                                        <div class="col-lg-12 col-xl-12">
                                            <h5 class="f-weight mb-3 text-dark">Servicio <?php echo e($servicio->nombre_servicio); ?></h5>
                                            <div class="t-verde d-flex align-items-center mb-3">
                                                <i class="fa-regular fa-circle-check fs-4"></i>
                                                <h5 class="t-verde font-weight-bold ms-2 mb-0">Pago en cuotas | Nº de cuotas:</strong> <?php echo e($pago['cantidad_cuotas']); ?></h5>
                                            </div>
                                            <div class="row">
                                                <?php for($i = 1; $i <= $pago['cantidad_cuotas']; $i++): ?>
                                                    <?php
                                                        $cuota = $cuotasPagadas->get($i);
                                                        $esPagada = !is_null($cuota);
                                                        $fechaProgramada = \Carbon\Carbon::parse($fechaInicio)->addMonths($i - 1)->format('Y-m-d');
                                                    ?>

                                                    <div class="col-xl-6 cuotax cuota-<?php echo e($i); ?>">
                                                        <div class="rounded-3 border mb-3 <?php echo e($esPagada ? 'bg-success-bj' : 'bg-warning-bj'); ?>">
                                                            <div class="row d-flex align-items-center">
                                                                <div class="col-7">
                                                                    <div class="m-3">
                                                                        <h1 class="semibold fs-6 text-secondary2">Pago cuota Nº <?php echo e($i); ?></h1>
                                                                        <h2 class="normal f-weight text-secondary2">
                                                                            S/. <span class="costo-cuota">
                                                                                <?php echo e($esPagada ? $cuota['monto'] : number_format($montoPorCuota, 2)); ?>

                                                                            </span>
                                                                        </h2>
                                                                        <div class="d-flex mt-4 align-items-center">
                                                                            <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs">
                                                                                <?php echo e($esPagada ? $cuota['fecha_pagada'] : $fechaProgramada); ?>

                                                                            </h5>
                                                                        </div>
                                                                        <div class="d-flex mt-2 align-items-center">
                                                                            <i class="me-2 <?php echo e($esPagada ? 'fa-solid fa-circle-check' : 'fa-solid fa-circle-xmark'); ?> text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs">
                                                                                <?php echo e($esPagada ? 'Pagado' : 'Pendiente'); ?>

                                                                            </h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-5">
                                                                    <div class="pe-4">
                                                                        <?php if($esPagada && $cuota['boleta']): ?>
                                                                            <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                                <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green">
                                                                                    <span class="mb-2 text-center d-block">Boleta</span>
                                                                                    <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Boleta" width="50" class="d-block mx-auto">
                                                                                </p>
                                                                            </a>
                                                                        <?php else: ?>
                                                                            <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green opacity-5">
                                                                                <span class="mb-2 text-xs text-center d-block">
                                                                                    <?php echo e($esPagada ? 'Estamos preparando su boleta' : 'Boleta no disponible'); ?>

                                                                                </span>
                                                                                <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Boleta" width="50" class="d-block mx-auto">
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endfor; ?>
                                            </div>
                                            <div class="row d-none">
                                                <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kex => $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-xl-6  cuotax cuota-1">
                                                        <div class="rounded-3 border mb-3 bg-success-bj">
                                                            <div class="row d-flex align-items-center">
                                                                <div class="col-7">
                                                                    <div class="m-3">
                                                                        <h1 class="semibold fs-6 text-secondary2">Pago cuota Nº <?php echo e($kex + 1); ?></h1>
                                                                        <h2 class="normal f-weight text-secondary2">S/. <span class="costo-cuota"><?php echo e($cuota['monto']); ?></span></h2>
                                                                        <div class="d-flex mt-4 align-items-center">
                                                                            <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs"><?php echo e($cuota['fecha_pagada']); ?></h5>
                                                                        </div>
                                                                        <div class="d-flex mt-2 align-items-center">
                                                                            <i class="me-2 fa-solid fa-circle-check text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs">Pagado</h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-5">
                                                                    <div class="pe-4">
                                                                        <?php if($cuota['boleta']): ?>
                                                                            <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                                <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green">
                                                                                    <span class="mb-2 text-center d-block">Boleta</span>
                                                                                    <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                                </p>
                                                                            </a>
                                                                        <?php else: ?>
                                                                            <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green opacity-5">
                                                                                <span class="mb-2 text-xs text-center d-block">Estamos preparando su boleta</span>
                                                                                <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>

                                        </div>
                                        <div class="col-lg-12 col-xl-12">

                                            <?php if($pago['prod_extras']): ?>
                                                <div class="mt-4">
                                                    <h5 class="f-weight mb-4 text-dark">Productos Extras</h5>
                                                    <div class="card z-index-2 shadow-lg mt-3">
                                                        <div class="row m-2 my-3">
                                                            <div class=" col-xl-12">
                                                                <div>
                                                                    <?php
                                                                        $productosExtras = json_decode($pago['prod_extras'], true); // Decodificar JSON directamente en Blade
//                                                                                         dd($productosExtras);
                                                                    ?>
                                                                    <?php $__currentLoopData = $productosExtras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extraId => $cantidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $productos = DB::table('productos')->where('id_producto',$extraId)->first();
                                                                        ?>
                                                                        <div class="rounded-4 p-2 cont-macetaplanta active mb-2">
                                                                            <div class="row d-flex align-items-center">
                                                                                <div class="col-3 text-center">
                                                                                    <img height="100" src="<?php echo e(asset('assets/img/'.$productos->imagen)); ?>" class="img-fxluid no-select border-radius-lg">
                                                                                </div>
                                                                                <div class="col-5">
                                                                                    <?php echo e($productos->nombre_producto); ?>

                                                                                </div>
                                                                                <div class="col-3">
                                                                                    <p class="mb-0">Cantidad:
                                                                                        <strong>
                                                                                            <?php echo e($cantidad); ?>

                                                                                        </strong>
                                                                                    </p>

                                                                                </div>
                                                                                <div class="col-1">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-lg-4">
                                    <div class="card bg-success z-index-2 mt-5 mt-md-0">
                                        <div>
                                            <h6 class="semibold text-white mx-4 my-3">Resumen</h6>
                                            <hr>
                                            <div class="">
                                                <div class="mx-4 mx-lg-4 mx-xxl-5 my-4">
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Servicio</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['pago_peso']); ?></h6>
                                                        </div>
                                                    </div>
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Extra</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['pago_extra']); ?></h6>
                                                        </div>
                                                    </div>
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Extra por recojo</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['costo_envio']); ?>

                                                            </h6>
                                                        </div>
                                                    </div>
                                                    <?php if(!empty($pago['fee_adicional'])): ?>
                                                        <div class="d-none row justify-content-between">
                                                            <hr>
                                                            <div class="col-6">
                                                                <h6 class="normal text-start text-white fs-7">Fee adicional (10%)</h6>
                                                            </div>
                                                            <div class="col-6">
                                                                <h6 class="normal text-start text-white text-end fs-7">
                                                                    S/.<?php echo e($pago['fee_adicional']); ?>

                                                                </h6>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="">
                                                <div class="mx-4 mx-lg-4 mx-xxl-5 my-3">
                                                    <div class="row justify-content-between">
                                                        <div class="col-5">
                                                            <h5 class="semibold text-start text-white">Total a pagar</h5>
                                                        </div>
                                                        <div class="col-7">
                                                            <h4 class="semibold text-start text-white text-end ">
                                                                S/.<?php echo e($pago['total_pagar']); ?>

                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="">
                        <div class="card z-index-2 shadow-lg mb-3">
                            <div class="row m-2 my-3">
                                <div class="col-12 col-sm-8">
                                    <div class="row">
                                        <div class=" col-12 col-sm-6">

                                            <?php if($pago['tipo_pago'] == 'extra'): ?>
                                                <h5 class="f-weight mb-4 text-dark">Productos Extras </h5>
                                            <?php else: ?>
                                                <h5 class="f-weight mb-4 text-dark">Servicio <?php echo e($servicio->nombre_servicio); ?></h5>
                                            <?php endif; ?>

                                            <div class="t-verde d-flex align-items-center mb-2">
                                                <i class="fa-regular fa-circle-check fs-4"></i>
                                                <h5 class="t-verde font-weight-bold ms-2 mb-0">Pago total</h5>
                                            </div>
                                            <div>

                                            </div>
                                            <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row">
                                                    <div class="col-xl-6 cuotax cuota-1">

                                                        <div class="row d-flex align-items-center rounded-3 border mb-3 bg-success-bj">
                                                            <div class="col-7">
                                                                <div class="my-3">
                                                                    <h1 class="semibold fs-6 text-secondary2">Pago directo</h1>
                                                                    <h2 class="normal f-weight text-secondary2">S/. <span class="costo-cuota"><?php echo e($cuota['monto']); ?></span></h2>
                                                                    <div class="d-flex mt-4 align-items-center">
                                                                        <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                                        <h5 class="fs-6 text-secondary2 mb-0 text-xs"><?php echo e($cuota['fecha_pagada']); ?></h5>
                                                                    </div>
                                                                    <div class="d-flex mt-2 align-items-center">
                                                                        <i class="me-2 fa-solid fa-circle-check text-secondary2"></i>
                                                                        <h5 class="fs-6 text-secondary2 mb-0 text-xs">Pagado</h5>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-5">
                                                                <?php if($cuota['boleta']): ?>
                                                                    <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                        <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green">
                                                                            <span class="mb-2 text-center d-block">Boleta</span>
                                                                            <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                        </p>
                                                                    </a>

                                                                <?php else: ?>
                                                                    <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green opacity-5">
                                                                        <span class="mb-2 text-xs text-center d-block">Estamos preparando su boleta</span>
                                                                        <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                    </p>
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>

                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php if($pago['prod_extras']): ?>

                                            <div class="col-12 col-sm-6">
                                                <div class="mt-4">
                                                    <?php if($pago['tipo_pago'] == 'servicio'): ?>
                                                        <h5 class="f-weight mb-4 text-dark">Productos Extras </h5>
                                                    <?php endif; ?>
                                                    <div class="card z-index-2 shadow-lg mt-3">
                                                        <div class="row m-2 my-3">
                                                            <div class=" col-xl-12">
                                                                <div>
                                                                    <?php
                                                                        $productosExtras = json_decode($pago['prod_extras'], true); // Decodificar JSON directamente en Blade
//                                                                                             dd($productosExtras);
                                                                    ?>
                                                                    <?php $__currentLoopData = $productosExtras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extraId => $cantidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $productos = DB::table('productos')->where('id_producto',$extraId)->first();
                                                                        ?>
                                                                        <div class="rounded-4 p-2 cont-macetaplanta active mb-2">
                                                                            <div class="row d-flex align-items-center">
                                                                                <div class="col-3 text-center">
                                                                                    <img height="100" src="<?php echo e(asset('assets/img/'.$productos->imagen)); ?>" class="img-fxluid no-select border-radius-lg">
                                                                                </div>
                                                                                <div class="col-5">
                                                                                    <?php echo e($productos->nombre_producto); ?>

                                                                                </div>
                                                                                <div class="col-3">
                                                                                    <p class="mb-0">Cantidad:
                                                                                        <strong>
                                                                                            <?php echo e($cantidad); ?>

                                                                                        </strong>
                                                                                    </p>

                                                                                </div>
                                                                                <div class="col-1">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                                <div class="col-12 col-sm-4">
                                    <div class="card bg-success z-index-2 mt-5 mt-md-0">
                                        <div>
                                            <h6 class="semibold text-white mx-4 my-3">Resumen</h6>
                                            <hr>
                                            <div class="">
                                                <div class="mx-4 mx-lg-4 mx-xxl-5 my-4">
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Servicio</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['pago_peso']); ?></h6>
                                                        </div>
                                                    </div>
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Extra</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['pago_extra']); ?></h6>
                                                        </div>
                                                    </div>
                                                    <div class="row justify-content-between">
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white fs-7">Extra por recojo</h6>
                                                        </div>
                                                        <div class="col-6">
                                                            <h6 class="normal text-start text-white text-end fs-7">
                                                                S/.<?php echo e($pago['costo_envio']); ?>

                                                            </h6>
                                                        </div>
                                                    </div>
                                                    <?php if(!empty($pago['fee_adicional'])): ?>
                                                        <div class="d-none row justify-content-between">
                                                            <hr>
                                                            <div class="col-6">
                                                                <h6 class="normal text-start text-white fs-7">Fee adicional (10%)</h6>
                                                            </div>
                                                            <div class="col-6">
                                                                <h6 class="normal text-start text-white text-end fs-7">
                                                                    S/.<?php echo e($pago['fee_adicional']); ?>

                                                                </h6>
                                                            </div>
                                                        </div>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                            <hr>
                                            <div class="">
                                                <div class="mx-4 mx-lg-4 mx-xxl-5 my-3">
                                                    <div class="row justify-content-between">
                                                        <div class="col-5">
                                                            <h5 class="semibold text-start text-white">Total a pagar</h5>
                                                        </div>
                                                        <div class="col-7">
                                                            <h4 class="semibold text-start text-white text-end ">
                                                                S/.<?php echo e($pago['total_pagar']); ?>

                                                            </h4>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </div>
    </div>
</section>
<?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/servicio/pagos.blade.php ENDPATH**/ ?>