<?php $__env->startSection('content'); ?>
    <section>

        <div class="page-header py-3">
            <input type="hidden" name="id_user" id="id_user" value="<?php echo e($user_id); ?>">
            <div class="container">
                <?php if(isset($_GET)): ?>
                    <?php $__currentLoopData = $_GET; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($key != '_token' && is_array($value)): ?>
                            <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key2 => $value2): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <input type="hidden" name="<?php echo e($key); ?>[<?php echo e($key2); ?>]" value="<?php echo e($value2); ?>">
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php elseif($key != '_token'): ?>
                            <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
                <?php echo csrf_field(); ?>
                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12">
                        <div class="my-4 card-header p-0 text-start">
                            <h1 class="semibold t-verde fs-4">Creando más vida con Vuelve</h1>
                        </div>
                        <div class="card card-plain metodos-pagos ">
                            <div class="card-header pb-0  ps-0 text-start">
                                <h2 class="f-weight text-dark fs-4">Detalle de pago</h2>
                                <p class="mt-4 text-sm">Selecciona como quieres hacer tu pago</p>
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div
                                            class="select-pasarela d-flex rounded-3 border align-items-center p-3 "
                                            data-id="cardPayment_visa">
                                            <div class="me-3">
                                                <img src="../../../assets/img/master.png" alt="">
                                            </div>
                                            <div class="me-3">
                                                <img src="../../../assets/img/visa.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pasarela">
                                <div id="mercadopago" class="cardPayment cardPayment_visa">
                                    <h5 class="my-4 font-weight-bold">Pago con tarjeta</h5>
                                    <div id="wallet_container"></div>
                                    <div id="cardPaymentBrick_container"></div>
                                </div>
                            </div>

                            <div class="text-md-end mt-4">
                                <a href="<?php echo e(route('registrosiemprejuntos_cuotas')); ?>" class="mx-1 btn btn-outline-dark btn-lg fs-6 w semibold">Volver</a>
                                
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="d-flex justify-content-between align-items-center">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">
                                    6
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="f-weight text-xs">Datos</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Mascota</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Recojo</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Extras</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Cuotas</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Pago</h6>
                            </div>
                        </div>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-xl-5 col-lg-7 col-md-12 h-100">
                        <div id="imgloquiero" class=" pe-0 text-center justify-content-center flex-column">
                            <div
                                class="position-relative bg-success h-100 p-5 border-radius-lg d-flex flex-column justify-content-center overflow-hidden">
                                <div class="rounded-top bg-white-transparent">
                                    <div class="m-4">
                                        <div class="row justify-content-between">
                                            <div class="col-12">
                                                <h4 class="semibold text-start text-white">Resumen</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="my-2">
                                    <img src="../../assets/img//mi-servicio.png" alt="">
                                </div>
                                <div class="mb-3 mx-4">
                                    <h4 class="semibold text-start text-white">Servicio <br>Siempre Juntos</h4>
                                </div>


                                <input type="hidden" id="precio-cuota" name="precio-cuota" value="cuota">
                                <div class="bg-white-transparent-2">
                                    <div class="p-4">
                                        <div class="row justify-content-between d-none">
                                            <div class="col-6">
                                                <h6 class="normal text-start text-white">Pago Total</h6>
                                            </div>
                                            <div class="col-4">
                                                <h6 class="normal text-start text-white text-end">
                                                    S/.<?php echo e($precioTotal); ?></h6>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="rounded-bottom bg-white-transparent">
                                    <div class="p-4">
                                        <div class="row justify-content-between">
                                            <div class="col-6">
                                                <h4 class="semibold text-start text-white" id="texto-total">
                                                    Total a pagar</h4>

                                            </div>
                                            <div class="col-4">
                                                <h4 class="semibold text-start text-white text-end ">
                                                    S/.<?php echo e($precioTotal); ?></h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>


                                <div class="rounded border border-light-subtle mt-7">
                                    <p class="normal m-3 fs-6 text-white">Muchas gracias por confiar en nosotros y ser
                                        parte de esta familia sostenible. 🌍♻</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://sdk.mercadopago.com/js/v2"></script>
    <script>
        $(function () {
            $('input[type="radio"]').click(function () {
                $(".metodos-pagos label").removeClass('active');
                $(this).parent().parent().addClass('active');
                let id = $(this).val();
                $("#" + id).removeClass('hide');
            });


            const data = JSON.parse('<?php echo str_replace('&quot;', '"', $data); ?>');

            const precioTotal = <?php echo e($precioTotal); ?>;

            console.log('data', data);

            const mp = new MercadoPago('<?php echo e(config('services.mercadopago.public_key')); ?>', {
                locale: 'es-PE'
            });
            const bricksBuilder = mp.bricks();

            const renderCardPaymentBrick = async (bricksBuilder) => {
                const settings = {
                    initialization: {
                        amount: precioTotal, // monto total a pagar
                    },
                    callbacks: {
                        onReady: () => {
                            /*
                              Callback llamado cuando Brick está listo.
                              Aquí puedes ocultar cargamentos de su sitio, por ejemplo.
                            */
                        },
                        onSubmit: (cardFormData) => {
                            cardFormData.method = 'mercadopago';
                            cardFormData.data = data;
                            cardFormData.monto = precioTotal;
                            console.log('cardFormData', cardFormData);
                            $.ajax({
                                method: "POST",
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                },
                                url: "<?php echo e(route('registrosiemprejuntos_processpayment')); ?>",
                                data: cardFormData,
                                success: function (result) {
                                    console.log('result', result);
                                    if (isValidJSON(result)) {
                                        let data = JSON.parse(result);
                                        console.log(data);
                                        if (data.status == 'approved' && data.status_detail == 'accredited') {
                                            alert('Se realizó el pago correctamente');

                                            if (data.redirect_url) {
                                                // Redirige al init_point de Mercado Pago para autorizar la 2da cuota
                                                window.location.href = data.redirect_url;
                                            } else {
                                                // Si no hay redirección, redirige al dashboard o encuestas
                                                const id_user = $('#id_user').val();
                                                if (id_user) {
                                                    window.location.href = "<?php echo e(route('inicio')); ?>";
                                                } else {
                                                    window.location.href = "<?php echo e(route('encuestas')); ?>";
                                                }
                                            }

                                        } else if (['error', 'rejected'].includes(data.status)) {
                                            alert(data.message);
                                            // location.reload();
                                        } else {
                                            alert('Hubo un error. Vuelve a intentarlo.');
                                        }
                                    } else {
                                        alert(result);
                                        // location.reload();
                                    }
                                },
                                error: function (e) {
                                    console.log('error', e);
                                }
                            });
                        },
                        onError: (error) => {
                            // callback llamado para todos los casos de error de Brick
                            console.error(error);
                        },
                    },
                };
                window.cardPaymentBrickController = await bricksBuilder.create(
                    'cardPayment',
                    'cardPaymentBrick_container',
                    settings,
                );
            };
            renderCardPaymentBrick(bricksBuilder);

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.web', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/registro/siemprejuntos/pago-total.blade.php ENDPATH**/ ?>