<section id="tab1" class="tab-panel">
    <div class="row">
        <div class="col-12 col-lg-8">
            <div class="card z-index-2 d-none d-sm-block">
                <div class="p-5 row">
                    <div class="col-lg-5 my-3">
                        <div class="text-center text-lg-start">
                            <div class="normal">SERVICIO</div>
                            <h1 class="font-weight-bold t-verde"><?php echo e($servicio->nombre_servicio); ?></h1>
                            
                            <?php if($pedido->con_entrega == 1): ?>
                                <p class="text-secondary text-sm"><span class="me-2">+ </span> T R A S L A D O
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-7">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="text-start">
                                <?php if($servicio->id_servicio == 1): ?>

                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Recojo de mascota a domicilio</p>
                                    </div>
                                    <div class=" d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Traslado a nuestro Compostario</p>
                                    </div>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Proceso de compostaje de 3 meses</p>
                                    </div>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Maceta con planta y su nombre</p>
                                    </div>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Print de su huella en una piedra</p>
                                    </div>
                                <?php else: ?>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Tranquilidad: Despídete del estrés de organizar los detalles cuando llegue el momento.</p>
                                    </div>
                                    <div class=" d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Sostenibilidad: Contribuye al medio ambiente con un proceso respetuoso y ecológico.</p>
                                    </div>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Acompañamiento personalizado: Te brindamos apoyo integral en cada paso.</p>
                                    </div>
                                    <div class="d-flex">
                                        <i class="fs-8 normal fa-regular fa-circle-check t-verde m-2"></i>
                                        <p class="fs-8 semibold mt-1">Ahorro: Al contratar el servicio con anticipación, obtienes un precio preferencial.</p>
                                    </div>

                                <?php endif; ?>
                                
                                
                                
                                
                                
                                
                            </div>
                        </div>
                    </div>
                    <div class="col-12">
                        <p class="fs-8 semibold mt-1">Podrás escoger los modelos de tus productos en la pestaña catálogo.</p>
                    </div>
                </div>
            </div>
            <div class="mt-4">
                <h6 class="font-weight-bold">Servicio <?php echo e($servicio->nombre_servicio); ?></h6>
                <!-- card extras-->

                <div class="card z-index-2 mt-4">
                    <div class="accordion-1">
                        <div class="container py-4">
                            <div class="row d-flex">
                                <div class="col-12 mb-4">
                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($pedidos_servicios->color1) && isset($pedidos_servicios->planta) ? 'active' : ''); ?>">
                                        <div class="escoger-maceta">
                                            <div class="colors position-relative p-0 row row">
                                                <?php if($pedidos_servicios->modelo): ?>
                                                    <?php
                                                        $maceta = DB::table('maceta_modelo')->where('id_maceta', $pedidos_servicios->modelo)->first();
                                                    ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4 ">
                                                        <p class="f-weight mb-2 text-center text-sm">Maceta</p>
                                                        <div class="servicios-items-image active d-flex justify-content-center align-items-center">
                                                            <img src="<?php echo e(asset('assets/img/'. $maceta->modelo )); ?>" height="120">
                                                        </div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($maceta->nombre); ?></p>
                                                            <p class="d-block text-xs mb-0 text-center">Altura: <?php echo e($maceta->altura); ?> <br> Diametro: <?php echo e($maceta->diametro); ?></span>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                        <p class="f-weight mb-2 text-center text-sm">Maceta</p>
                                                        <div class="servicios-items-image d-flex justify-content-center align-items-center"></div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"></p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($pedidos_servicios->planta): ?>
                                                    <?php
                                                        $planta = DB::table('maceta_planta')->where('id_planta', $pedidos_servicios->color1)->first();
                                                    ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4 ">
                                                        <p class="f-weight mb-2 text-center text-sm">Planta</p>
                                                        <div class="servicios-items-image active d-flex justify-content-center align-items-center">
                                                            <img src="<?php echo e(asset('assets/img/'. $planta->modelo )); ?>" height="120">
                                                        </div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($planta->nombre); ?></p>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                        <p class="f-weight mb-2 text-center text-sm">Planta</p>
                                                        <div class="servicios-items-image d-flex justify-content-center align-items-center"></div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"></p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($pedidos_servicios->color1): ?>
                                                    <?php
                                                        $color1 = DB::table('maceta_color1')->where('id_maceta', $pedidos_servicios->color1)->first();
                                                    ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4 ">
                                                        <p class="f-weight mb-2 text-center text-sm">Color Primario</p>
                                                        <div class="servicios-items-image active d-flex justify-content-center align-items-center">
                                                            <img src="<?php echo e(asset('assets/img/'. $color1->modelo )); ?>" height="120">
                                                        </div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($color1->nombre); ?></p>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                        <p class="f-weight mb-2 text-center text-sm">Color Primario</p>
                                                        <div class="servicios-items-image d-flex justify-content-center align-items-center"></div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"></p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if($pedidos_servicios->color2): ?>
                                                    <?php
                                                        $color2 = DB::table('maceta_color2')->where('id_maceta', $pedidos_servicios->color2)->first();
                                                    ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4 ">
                                                        <p class="f-weight mb-2 text-center text-sm">Color Secundario</p>
                                                        <div class="servicios-items-image active d-flex justify-content-center align-items-center">
                                                            <div class="color-servi" style="background: <?php echo e($color2->color); ?>"></div>
                                                        </div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($color2->nombre); ?></p>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                        <p class="f-weight mb-2 text-center text-sm">Color Secundario</p>
                                                        <div class="servicios-items-image d-flex justify-content-center align-items-center"></div>
                                                        <div class="servicios-items-description">
                                                            <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                            <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"></p>
                                                        </div>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if(isset($compostaje->id_tipo)): ?>
                                    <div class="col-12 col-lg-4">
                                        <div class="border rounded-4 p-2 h-100">
                                            <div class="m-3">
                                                <p class="f-weight mb-2 text-center text-sm">Mi Compost</p>
                                                <div class="text-center">
                                                    <div class="r">
                                                        <?php if($compostaje->id_tipo == 1): ?>
                                                            <img width="80" src="<?php echo e(asset('assets/img/bolso.png')); ?>" class="mb-3 img-fluid no-select">
                                                            <p class="normal text-center text-xs mb-0">Quiero recibir una bolsa con el compost de mi mascota.(entre 0,5 y 1 kg)</p>
                                                        <?php elseif($compostaje->id_tipo == 2): ?>
                                                            <img width="80" src="<?php echo e(asset('assets/img/bolso-grande.png')); ?>" class="mb-3 img-fluid no-select">
                                                            <p class="normal text-center text-xs mb-0">Quiero recibir todo el compost de mi mascota. (aprox. el 30% de su peso)</p>
                                                        <?php elseif($compostaje->id_tipo == 3): ?>
                                                            <img width="80" src="<?php echo e(asset('assets/img/icon__arbol.svg')); ?>" class="mb-3 img-fluid no-select">
                                                            <p class="normal text-center text-xs mb-0">Quiero que sea donado a proyectos de forestación.</p>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
            <div class="mt-4">
                <h6 class="font-weight-bold">Pedidos Extras</h6>
                <?php if(isset($extras)): ?>
                    <div class="card z-index-2 mt-4">
                        <div class="accordion-1">
                            <div class="container py-4">
                                <?php
                                    $contador = 1;
                                ?>
                                <?php $__currentLoopData = $extras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extra): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        //dd($extra);
                                    ?>
                                    <?php if($extra->id_producto == 1): ?>
                                        <div class="border rounded-4  mb-4 <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Maceta adicional con compost de mi mascota </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body  p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                                                        <?php
                                                                            $maceta_color1 = DB::table('maceta_color1')->where('id_maceta', $extra->color1)->first();
                                                                            $maceta_color2 = DB::table('maceta_color2')->where('id_maceta', $extra->color2)->first();
                                                                            $maceta_modelo = DB::table('maceta_modelo')->where('id_maceta', $extra->modelo)->first();
                                                                            $maceta_planta = DB::table('maceta_planta')->where('id_planta', $extra->planta)->first();
                                                                        ?>
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Maceta</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($maceta_modelo): ?>
                                                                                            <img height="120" src="<?php echo e(asset('assets/img/'. $maceta_modelo->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($maceta_modelo->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Planta</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($maceta_planta): ?>
                                                                                            <img height="120" src="<?php echo e(asset('assets/img/'. $maceta_planta->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($maceta_planta->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Color Primario</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($maceta_color1): ?>
                                                                                            <img height="120" src="<?php echo e(asset('assets/img/'. $maceta_color1->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($maceta_color1->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">

                                                                                    <p class="f-weight mb-2 text-center text-sm">Color Secundario</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <div class="color-servi" style="background: <?php echo e($maceta_color2->color ?? ''); ?>"></div>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($maceta_color2->nombre ?? ''); ?></p>
                                                                                    </div>

                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($extra->id_producto == 2): ?>
                                        <div class="border rounded-4  mb-4 <?php echo e(isset($extra->retrato) ? 'active' : ''); ?>">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Cuadro de acuarela del retrato de mi mascota </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body  p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($extra->retrato) ? 'active' : ''); ?>">
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Retrato</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($extra->retrato): ?>
                                                                                            <img height="110" src="<?php echo e(asset(str_replace('public', 'storage', $extra->retrato))); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($extra->id_producto == 3): ?>
                                        <div class="border rounded-4  mb-4 <?php echo e(isset($extra->retrato) ? 'active' : ''); ?>">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Maceta con el retrato de mi mascota </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body  p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($extra->retrato) ? 'active' : ''); ?>">
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Retrato</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($extra->retrato): ?>
                                                                                            <img height="110" src="<?php echo e(asset(str_replace('public', 'storage', $extra->retrato))); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($extra->id_producto == 4): ?>
                                        <div class="border rounded-4  mb-4 <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Dije hecho con resina y compost de mi mascota </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body  p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                                                        <?php
                                                                            $dije_color = DB::table('dije_color')->where('id_color', $extra->color1)->first();
                                                                            $dije_modelo = DB::table('dije_modelo')->where('id_modelo', $extra->modelo)->first();
                                                                            $dije_intensidad = DB::table('dije_intensidad')->where('id_intensidad', $extra->intensidad)->first();
                                                                        ?>
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($dije_modelo): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $dije_modelo->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Tipo:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($dije_modelo->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($dije_color): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $dije_color->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($dije_color->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($dije_intensidad): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $dije_intensidad->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Intensidad del Compost:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($dije_intensidad->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($extra->id_producto == 5): ?>
                                        <div class="border rounded-4  mb-4 <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Llavero hecho con resina y compost de mi mascota </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body  p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-sm-4 cont-macetaplanta <?php echo e(isset($extra->color1) ? 'active' : ''); ?>">
                                                                        <?php
                                                                            $llavero_color = DB::table('llavero_color')->where('id_color', $extra->color1)->first();
                                                                            $llavero_modelo = DB::table('llavero_modelo')->where('id_modelo', $extra->modelo)->first();
                                                                            $llavero_intensidad = DB::table('llavero_intensidad')->where('id_intensidad', $extra->intensidad)->first();
                                                                        ?>
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($llavero_modelo): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $llavero_modelo->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Tipo:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($llavero_modelo->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($llavero_color): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $llavero_color->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Color:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($llavero_color->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <?php if($llavero_intensidad): ?>
                                                                                            <img height="110" src="<?php echo e(asset('assets/img/'. $llavero_intensidad->modelo )); ?>">
                                                                                        <?php endif; ?>
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Intensidad del Compost:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold"><?php echo e($llavero_intensidad->nombre ?? ''); ?></p>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php elseif($extra->id_producto == 6): ?>
                                        <div class="border rounded-4  mb-4 active">
                                            <div class="accordion" id="accordionRental-<?php echo e($contador); ?>">
                                                <div class="accordion-item">
                                                    <h5 class="accordion-header" id="heading-<?php echo e($contador); ?>">
                                                        <button
                                                            class="accordion-button font-weight-bold text-dark"
                                                            type="button" data-bs-toggle="collapse"
                                                            data-bs-target="#collapse-<?php echo e($contador); ?>" aria-expanded="true"
                                                            aria-controls="collapse-<?php echo e($contador); ?>">
                                                            <p class="f-weight mb-0 pe-5">Extra #<?php echo e($contador); ?>: Maceta de papel </p>
                                                            <i class="collapse-close fa-solid fa-angle-up text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                            <i class="collapse-open fa-solid fa-angle-down text-xs position-absolute end-0 me-3 border rounded-2 p-1"
                                                               aria-hidden="true"></i>
                                                        </button>
                                                    </h5>
                                                    <div id="collapse-<?php echo e($contador); ?>" class="accordion-collapse collapse"
                                                         aria-labelledby="heading-<?php echo e($contador); ?>"
                                                         data-bs-parent="#accordionRental-<?php echo e($contador); ?>">
                                                        <div class="accordion-body p-2 p-md-4">
                                                            <div class="row">
                                                                <div class="col-12">
                                                                    <div class="rounded-4 p-2 p-md-4 cont-macetaplanta active">
                                                                        <div class="escoger-maceta">
                                                                            <div class="colors position-relative p-0 row">
                                                                                <div class="servicios-items col-6 col-sm-3 col-sm-4">
                                                                                    <p class="f-weight mb-2 text-center text-sm">Maceta</p>
                                                                                    <div class="servicios-items-image d-flex justify-content-center align-items-center">
                                                                                        <img height="120" src="<?php echo e(asset('assets/img/modelo_e.png')); ?>">
                                                                                    </div>
                                                                                    <div class="servicios-items-description">
                                                                                        <span class="d-block mt-2 text-sm text-center">Modelo:</span>
                                                                                        <p class="d-block mt-1 mb-0 text-md text-center font-weight-bold">Papel</p>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                        $contador++;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>

                    </div>
                <?php else: ?>
                    <div class="card z-index-2 mt-4">
                        <div class="accordion-1">
                            <div class="container pt-4 pb-4">
                                <p class="w-100 m-0 p-2 text-center">No hay productos extras asociados a tu mascota</p>
                            </div>
                        </div>
                    </div>

                <?php endif; ?>


            </div>
        </div>
        <div class="col-12 col-lg-4 ">
            <div class="card bg-success d-none d-lg-block">
                <div>
                    <h6 class="semibold text-white p-3 m-0 pb-0">Resumen</h6>
                    <hr>
                    <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="">
                            <div class="mx-4 mx-lg-4 mx-xxl-5 my-4">
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Servicio</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e($pago['pago_peso']); ?></h6>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Extra</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e(floatval($pago['pago_extra'])); ?></h6>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Recojo</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e($pago['costo_envio']); ?>

                                        </h6>
                                    </div>
                                </div>
                                <?php if(!empty($pago['fee_adicional'])): ?>
                                    <div class="d-none row justify-content-between">
                                        <hr>
                                        <div class="col-6">
                                            <h6 class="normal text-start text-white fs-7">Fee adicional (10%)</h6>
                                        </div>
                                        <div class="col-6">
                                            <h6 class="normal text-start text-white text-end fs-7">
                                                S/.<?php echo e($pago['fee_adicional']); ?>

                                            </h6>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="mx-4 mx-lg-4 mx-xxl-5 my-3">
                                <div class="row justify-content-between">
                                    <div class="col-5">
                                        <h5 class="semibold text-start text-white">Total</h5>
                                    </div>
                                    <div class="col-7">
                                        <h4 class="semibold text-start text-white text-end ">
                                            S/.<?php echo e(floatval($pago['total_pagar'])); ?>

                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <div class="row">
                <div class="col-12 col-md-6 col-lg-12 mt-4">
                    
                    <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                        <div class="row align-items-center h-100">
                            <div class="col-12 col-xl-1"></div>
                            <div class="col-4 col-xl-3">
                                <img src="<?php echo e(asset('assets/img/visita-mascota.png')); ?>" alt="" class="w-100">
                            </div>
                            <div class="col-8">
                                <div class="">
                                    <div class="mb-3">
                                        <p class="h5 ">Visita a tu</br><span class="t-verde">mascota</span></p>
                                    </div>
                                    <div class="">
                                        <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal" data-bs-target="#prom-2">
                                            Agendar visita
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal modal-lg fade" id="prom-2" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content p-4">
                                <h6>Visita a tu mascota en nuestro compostario durante su primer mes de transformación y acompaña su proceso.</h6>
                                <p><strong>Para agendar la visita de tu mascota, ten en cuenta los siguientes detalles 🌱:</strong></p>
                                <p>📅 Horarios de visitas:</p>
                                <ul>
                                    <li>Viernes: De 11:00 a.m. a 1:00 p.m. y de 2:00 p.m. a 4:30 p.m.</li>
                                    <li>Sábados: De 10:00 a.m. a 12:00 p.m.</li>
                                    <li>Es necesario coordinar previamente todas las visitas.</li>
                                </ul>
                                <p>Cuando elijas el día de tu visita te enviaremos un correo con toda la información necesaria para que tu día de visita sea especial 🫶🌱. ¡Te esperamos! 💚</p>
                                <div class="row mb-2">
                                    <div class="col-3"></div>
                                    <div class="col-3">
                                        <button type="button" class="w-100 btn active-btn btn-sm mb-0 btn-visita" data-tab="agendar-visita" id="btn-visita">Agendar visita</button>
                                    </div>
                                    <div class="col-3">
                                        <button type="button" class="w-100 btn btn-sm mb-0 btn-visita" data-tab="agendar-googlemaps" id="btn-ubicacion">Ubicación</button>
                                    </div>
                                    <div class="col-3"></div>
                                </div>
                                <div class="agendar-visita p-3">
                                    <p class="text-xs text-center">Selecciona una fecha y horario de preferencia</p>
                                    <form method="POST" class="d-s">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-6">
                                                <input type="hidden" name="visitascal" id="visitascal" readonly style="display: none">
                                                <input type="hidden" name="mascota" value="<?php echo e($mascota->id_mascota); ?>">
                                                <input type="hidden" name="pedido" value="<?php echo e($pedido->id_pedido); ?>">
                                                <input type="hidden" name="usuario" value="<?php echo e($usuario->id); ?>">
                                                <input type="hidden" name="agendar-visita" value="agendar-visita">
                                            </div>
                                            <div class="col-6">
                                                <div class="row " id="horarios">

                                                </div>
                                                <div class="row">
                                                    <div class="col-12">
                                                        <div class="row">
                                                            <div class="col-3"></div>
                                                            <div class="col-6">
                                                                <button type="sumbit" id="btn-agendar-visita" class="w-100 btn btn-success btn-md mt-3 mb-0 hide">
                                                                    Agendar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="agendar-googlemaps p-3 hide">
                                    <p class="text-xs text-center">Nos puedes encontrar en Google Maps como Vuelve Compostario</p>
                                    <div class="mb-2">
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d7797.977173782153!2d-76.8697967!3d-12.2490514!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9105c9b2d3db227f%3A0x8ebe705fb47de4bf!2sVuelve%20Compostario%20de%20Mascotas!5e0!3m2!1ses!2spe!4v1739214345375!5m2!1ses!2spe"
                                            width="100%" height="300" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-12 mt-4">
                    <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                        <div class="row align-items-center h-100">
                            <div class="col-12 col-xl-1"></div>
                            <div class="col-4 col-xl-3">
                                <img src="<?php echo e(asset('assets/img/volver-mascota.png')); ?>" alt="" class="w-100">
                            </div>
                            <div class="col-8">
                                <div class="">
                                    <div class="mb-3">
                                        <p class="h5 ">Te ofrecemos diferentes opciones para el retorno del compost de tu <span class="t-verde">mascota</span></p>
                                    </div>
                                    <div class="">
                                        <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal" data-bs-target="#proc-compostaje">
                                            Seleccionar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="modal modal-lg fade" id="proc-compostaje" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content p-4">
                                <p><strong>Proceso de compostaje para mi mascota:</strong></p>
                                <?php if(isset($compostaje->id_tipo)): ?>
                                    <p>Gracias por tu elección, <?php echo e($mascota->nombre_mascota); ?> estará pronto a tu lado</p>
                                <?php else: ?>
                                    <p>Dependiendo del peso de tu mascota, su proceso de compostaje tendrá como resultado un aproximado entre 3 a 15 kg de compost. Puedes escoger las siguientes opciones para recibir su compost:</p>
                                    <form action="" method="post">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="compostaje" value="<?php echo e($pedido->id_compostaje); ?>">
                                        <input type="hidden" name="proc-compostaje" value="proc-compostaje">
                                        <p class="text-sm">Escoge la opción que desees:</strong>
                                        <div class="row mt-2 mb-2">
                                            <div class="col-md-6 mb-2">
                                                <label class="m-0 rounded-3 p-2 proc-compostaje-items bg-success-bj w-100 border" for="una-bolsa" style="cursor: pointer;">
                                                    <div class="p-3">
                                                        <div class="row">
                                                            <div class="col-4 text-center">
                                                                <img src="/assets/img/bolso.png" height="120" class="" alt="bolsa">
                                                            </div>
                                                            <div class="col-8">
                                                                <p></p>
                                                                <p class="normal text-secondary text-sm">Solo quiero recibir un bolsa con el compost de mi mascota (entre 0.5 y 1 kg)</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </label>
                                                <input type="radio" name="tipo" class="opacity-0 position-absolute proc-compostaje-item" id="una-bolsa" value="1" checked>
                                            </div>
                                            <div class="col-md-6 mb-2">
                                                <label class="m-0 rounded-3 p-2 proc-compostaje-items w-100 border" for="donado" style="cursor: pointer;">
                                                    <div class="p-3">
                                                        <div class="row">
                                                            <div class="col-5">
                                                                <img src="/assets/img/icon__arbol.svg" height="120" class="" alt="bolsa">
                                                            </div>
                                                            <div class="col-7">
                                                                <p></p>
                                                                <p class="normal text-secondary text-sm">Quiero que sea donado a proyectos de forestación.</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </label>
                                                <input type="radio" name="tipo" class="opacity-0 position-absolute proc-compostaje-item" id="donado" value="3">
                                            </div>
                                            <div class="col-md-12 mb-2">
                                                <label class="m-0 rounded-3 p-2 proc-compostaje-items w-100 border" for="todo-compost" style="cursor: pointer;">
                                                    <div class="p-3">
                                                        <div class="row">
                                                            <div class="col-4">
                                                                <img src="/assets/img/bolso-grande.png" height="120" class="" alt="bolsa">
                                                            </div>
                                                            <div class="col-8">
                                                                <p></p>
                                                                <p class="normal text-secondary text-sm mb-1">Quiero recibir todo el compost de mi mascota. (aprox. el 30% de su peso)</p>
                                                                <ul class="normal text-secondary text-sm ps-3 mb-0">
                                                                    <li>Mascota pequeña: aprox 1 bolsa.</li>
                                                                    <li>Mascota mediana o grande: aprox 3 -4 bolsas</li>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </label>
                                                <input type="radio" name="tipo" class="opacity-0 position-absolute proc-compostaje-item" id="todo-compost" value="2">
                                            </div>

                                            <div class="col-12">
                                                <div class="row">
                                                    <div class="col-3">
                                                        <button type="submit" class="btn btn-success btn-md mt-3 mb-0" data-bs-toggle="modal" data-bs-target="#proc-compostaje">
                                                            Guardar
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-12 mt-4">
                    <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                        <div class="row align-items-center h-100">
                            <div class="col-12 col-xl-1"></div>
                            <div class="col-4 col-xl-3">
                                <img src="<?php echo e(asset('assets/img/inicio-flores.png')); ?>" alt="" class="w-100">
                            </div>
                            <div class="col-8">
                                <div class="">
                                    <div class="mb-3">
                                        <p class="h5 ">Envíale flores a tu </br><span class="t-verde">mascota</span></p>
                                    </div>
                                    <div class="">
                                        <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal" data-bs-target="#prom-1">
                                            Enviar
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal modal-lg fade" id="prom-1" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog">
                            <div class="modal-content p-4">


                                <?php
                                    use Carbon\Carbon;

                                    $fechaCreacion = Carbon::parse($pedido->fecha_creacion);
                                    $fechaFin = $fechaCreacion->copy()->addMonth(); // Un mes después
                                    $fechaActual = Carbon::now();

                                ?>

                                <?php if($fechaActual->between($fechaCreacion, $fechaFin)): ?>
                                    <h6>Envíale flores a tu mascota a nuestra oficina en Miraflores para que puedan acompañarla en su proceso. </h6>
                                    <p><strong>Te detallamos la información para el envío de flores:</strong></p>
                                    <ul>
                                        <li>Dirección: Calle Grimaldo del Solar 242, Miraflores 🌱.</li>
                                        <li>Días: Martes</li>
                                        <li>Horario: de 8 am a 10 pm</li>
                                        <li>A nombre de: Gonzalo León</li>
                                    </ul>
                                    <p>
                                        <iframe
                                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3900.8221836068865!2d-77.0261531!3d-12.124315899999997!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x9105c81b8ac3a8c9%3A0xad41a3aaefb5e404!2sC.%20Grimaldo%20del%20Solar%20242%2C%20Miraflores%2015074!5e0!3m2!1ses!2spe!4v1739955596271!5m2!1ses!2spe"
                                            width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                                    </p>
                                    <p>Por favor toma en cuenta que solo recibimos flores durante el primer mes de su proceso, ya que el tiempo de compostaje varía de acuerdo a cada mascota🌷💚.</p>
                                    <p><strong>Cuando dejes el ramo es importante considerar lo siguiente:</strong></p>
                                    <ul>
                                        <li>No debe contener envolturas de plástico, te recomendamos usar papel o no poner envoltura</li>
                                        <li>Debes colocar el nombre de tu mascota en el ramo.</li>
                                        <li>Las flores, al ser materia natural y orgánico, se integrarán a su cuna acompañándola en el proceso 💐💚.</li>
                                    </ul>
                                <?php else: ?>
                                    <p>
                                        Muchas gracias por querer enviarle flores a tu mascota, sin embargo, solo recibimos ramos durante el primer mes de su proceso ya que este varía de acuerdo a cada mascota.
                                    </p>
                                    <p>
                                        Seguiremos cuidando muy bien de <?php echo e($mascota->nombre_mascota); ?>.</p>
                                    <p>
                                        Gracias por confiar en nosotros.
                                    </p>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <?php if($pago['forma_pago'] == 'cuotas' ): ?>
                    <div class="mt-4">
                        <div class="card z-index-2 shadow-lg">
                            <div class="row m-2 my-3">
                                <div class="col-md-12">
                                    <div class="row">
                                        <div class=" col-xl-12">


                                            <h5 class="f-weight mb-3 text-dark">Servicio <?php echo e($servicio->nombre_servicio); ?></h5>
                                            <div class="t-verde d-flex align-items-center mb-3">
                                                <i class="fa-regular fa-circle-check fs-4"></i>
                                                <h5 class="t-verde font-weight-bold ms-2 mb-0">Pago en cuotas | Nº de cuotas:</strong> <?php echo e($pago['cantidad_cuotas']); ?></h5>
                                            </div>

                                            <div class="row">
                                                <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kex => $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col-xl-12  cuotax cuota-1">
                                                        <div class="rounded-3 border mb-3 bg-success-bj">
                                                            <div class="row d-flex align-items-center">
                                                                <div class="col-7">
                                                                    <div class="m-3">
                                                                        <h1 class="semibold fs-6 text-secondary2">Pago cuota Nº <?php echo e($kex + 1); ?></h1>
                                                                        <h2 class="normal f-weight text-secondary2">S/. <span class="costo-cuota"><?php echo e($cuota['monto']); ?></span></h2>
                                                                        <div class="d-flex mt-4 align-items-center">
                                                                            <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs"><?php echo e($cuota['fecha_pagada']); ?></h5>
                                                                        </div>
                                                                        <div class="d-flex mt-2 align-items-center">
                                                                            <i class="me-2 fa-solid fa-circle-check text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs">Pagado</h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-5">
                                                                    <div class="pe-4">
                                                                        <?php if($cuota['boleta']): ?>
                                                                            <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                                <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green">
                                                                                    <span class="mb-2 text-center d-block">Boleta</span>
                                                                                    <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                                </p>
                                                                            </a>
                                                                        <?php else: ?>
                                                                            <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green opacity-5">
                                                                                <span class="mb-2 text-xs text-center d-block">Estamos preparando su boleta</span>
                                                                                <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </div>

                                        </div>
                                        <div class="col-12">

                                            <?php if($pago['prod_extras']): ?>
                                                <div class="mt-4">
                                                    <h5 class="f-weight mb-4 text-dark">Productos Extras</h5>
                                                    <div class="card z-index-2 shadow-lg mt-3">
                                                        <div class="row m-2 my-3">
                                                            <div class=" col-xl-12">
                                                                <div>
                                                                    <?php
                                                                        $productosExtras = json_decode($pago['prod_extras'], true); // Decodificar JSON directamente en Blade
//                                                                                         dd($productosExtras);
                                                                    ?>
                                                                    <?php $__currentLoopData = $productosExtras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extraId => $cantidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $productos = DB::table('productos')->where('id_producto',$extraId)->first();
                                                                        ?>
                                                                        <div class="rounded-4 p-2 cont-macetaplanta active mb-2">
                                                                            <div class="row d-flex align-items-center">
                                                                                <div class="col-3 text-center">
                                                                                    <img height="100" src="<?php echo e(asset('assets/img/'.$productos->imagen)); ?>" class="img-fxluid no-select border-radius-lg">
                                                                                </div>
                                                                                <div class="col-5">
                                                                                    <?php echo e($productos->nombre_producto); ?>

                                                                                </div>
                                                                                <div class="col-3">
                                                                                    <p class="mb-0">Cantidad:
                                                                                        <strong>
                                                                                            <?php echo e($cantidad); ?>

                                                                                        </strong>
                                                                                    </p>

                                                                                </div>
                                                                                <div class="col-1">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="mt-4">
                        <div class="card z-index-2 shadow-lg mb-3">
                            <div class="row m-2 my-3">
                                <div class="col-12">
                                    <div class="row">
                                        <div class=" col-12">

                                            <?php if($pago['tipo_pago'] == 'extra'): ?>
                                                <h5 class="f-weight mb-4 text-dark">Productos Extras </h5>
                                            <?php else: ?>
                                                <h5 class="f-weight mb-4 text-dark">Servicio <?php echo e($servicio->nombre_servicio); ?></h5>
                                            <?php endif; ?>

                                            <div class="t-verde d-flex align-items-center mb-2">
                                                <i class="fa-regular fa-circle-check fs-4"></i>
                                                <h5 class="t-verde font-weight-bold ms-2 mb-0">Pago total</h5>
                                            </div>
                                            <div>

                                            </div>
                                            <?php $__currentLoopData = $pago['cuotas']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cuota): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    // @dd($cuota)
                                                ?>
                                                <div class="row">
                                                    <div class="col-xl-12 cuotax cuota-1">
                                                        <div class="rounded-3 border mb-3 bg-success-bj">
                                                            <div class="row d-flex align-items-center">
                                                                <div class="col-7">
                                                                    <div class="m-3">
                                                                        <h1 class="semibold fs-6 text-secondary2">Pago directo</h1>
                                                                        <h2 class="normal f-weight text-secondary2">S/. <span class="costo-cuota"><?php echo e($cuota['monto']); ?></span></h2>
                                                                        <div class="d-flex mt-4 align-items-center">
                                                                            <i class="me-2 fa-regular fa-calendar-days text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs"><?php echo e($cuota['fecha_pagada']); ?></h5>
                                                                        </div>
                                                                        <div class="d-flex mt-2 align-items-center">
                                                                            <i class="me-2 fa-solid fa-circle-check text-secondary2"></i>
                                                                            <h5 class="fs-6 text-secondary2 mb-0 text-xs">Pagado</h5>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-5">
                                                                    <div class="pe-4">
                                                                        <?php if($cuota['boleta']): ?>
                                                                            <a href="<?php echo e(asset('storage/' . $cuota['boleta'])); ?>" target="_blank">
                                                                                <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green">
                                                                                    <span class="mb-2 text-center d-block">Boleta</span>
                                                                                    <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                                </p>
                                                                            </a>

                                                                        <?php else: ?>
                                                                            <p class="p-2 mb-0 image-constance position-relative border-radius-md greese-green opacity-5">
                                                                                <span class="mb-2 text-xs text-center d-block">Estamos preparando su boleta</span>
                                                                                <img src="<?php echo e(asset('assets/img/pdf.png')); ?>" alt="Foto Huella" width="50" class="d-block mx-auto">
                                                                            </p>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                        <?php if($pago['prod_extras']): ?>

                                            <div class="col-12">
                                                <div class="mt-4">
                                                    <?php if($pago['tipo_pago'] == 'servicio'): ?>
                                                        <h5 class="f-weight mb-4 text-dark">Productos Extras </h5>
                                                    <?php endif; ?>
                                                    <div class="card z-index-2 shadow-lg mt-3">
                                                        <div class="row m-2 my-3">
                                                            <div class=" col-xl-12">
                                                                <div>
                                                                    <?php
                                                                        $productosExtras = json_decode($pago['prod_extras'], true); // Decodificar JSON directamente en Blade
//                                                                                             dd($productosExtras);
                                                                    ?>
                                                                    <?php $__currentLoopData = $productosExtras; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extraId => $cantidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $productos = DB::table('productos')->where('id_producto',$extraId)->first();
                                                                        ?>
                                                                        <div class="rounded-4 p-2 cont-macetaplanta active mb-2">
                                                                            <div class="row d-flex align-items-center">
                                                                                <div class="col-3 text-center">
                                                                                    <img height="100" src="<?php echo e(asset('assets/img/'.$productos->imagen)); ?>" class="img-fxluid no-select border-radius-lg">
                                                                                </div>
                                                                                <div class="col-5">
                                                                                    <?php echo e($productos->nombre_producto); ?>

                                                                                </div>
                                                                                <div class="col-3">
                                                                                    <p class="mb-0">Cantidad:
                                                                                        <strong>
                                                                                            <?php echo e($cantidad); ?>

                                                                                        </strong>
                                                                                    </p>

                                                                                </div>
                                                                                <div class="col-1">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        <?php endif; ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="col-12">

            <div class="mt-4 card bg-success z-index-2 mb-4 d-block d-lg-none">
                <div>
                    <h6 class="semibold text-white p-3 m-0 pb-0">Resumenx</h6>
                    <hr>
                    <?php $__currentLoopData = $pagosFinal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pago): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="">
                            <div class="mx-4 mx-lg-4 mx-xxl-5 my-4">
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Servicio</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e($pago['pago_peso']); ?></h6>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Extra</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e(floatval($pago['pago_extra'])); ?></h6>
                                    </div>
                                </div>
                                <div class="row justify-content-between">
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white fs-7">Extra por recojo</h6>
                                    </div>
                                    <div class="col-6">
                                        <h6 class="normal text-start text-white text-end fs-7">
                                            S/.<?php echo e($pago['costo_envio']); ?>

                                        </h6>
                                    </div>
                                </div>
                                <?php if(!empty($pago['fee_adicional'])): ?>
                                    <div class="d-none row justify-content-between">
                                        <hr>
                                        <div class="col-6">
                                            <h6 class="normal text-start text-white fs-7">Fee adicional (10%)</h6>
                                        </div>
                                        <div class="col-6">
                                            <h6 class="normal text-start text-white text-end fs-7">
                                                S/.<?php echo e($pago['fee_adicional']); ?>

                                            </h6>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="mx-4 mx-lg-4 mx-xxl-5 my-3">
                                <div class="row justify-content-between">
                                    <div class="col-5">
                                        <h5 class="semibold text-start text-white">Total</h5>
                                    </div>
                                    <div class="col-7">
                                        <h4 class="semibold text-start text-white text-end ">
                                            S/.<?php echo e($pago['total_pagar']); ?>

                                        </h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /opt/homebrew/var/www/cliente_vuelvecompostario/web-vuelvecompostario/vuelve/resources/views/front/servicio/resumen.blade.php ENDPATH**/ ?>