@extends('front.layouts.user')
@section('content')

<div class="container py-5">
    <div class="row">
        <div class="col-xl-12">
            <!-- card -->
            <div class="card">
                <div class="card-header">
                    <h2 class="f-weight text-dark mt-3">Mi perfil</h2>
                </div>
                <div class="card-body px-0">
                    <div class="nav-tabbar-head w-full">
                        <div class="tabset ps-4 tabset-top">
                            <input type="radio" name="tabset" id="tab1" aria-controls="tab1" checked>
                            <label for="tab1" class="color-grey labeltext">Mi perfil</label>
                            <input type="radio" name="tabset" id="tab2" aria-controls="tab2">
                            <label for="tab2" class="color-grey labeltext">Editar</label>

                            <div class="tab-panels container-fluid mb-5">
                                <section id="tab-1" class="tab-panel">
                                    <div class="row">
                                        <div class="col-xl-2 col-lg-3 col-md-3">
                                            <!-- link de muestra 
                        https://htmlstream.com/preview/front-dashboard-v2.1.1/user-profile-my-profile.html
                        -->
                                            <div class="d-flex justify-content-center avatar-center">
                                                <label class="avatar avatar-xxl avatar-circle">
                                                    <img src="../../assets/img/avatar.png" alt="Image Description">
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col-xl -->

                                        <div class="col-xl-9 col-lg-8 col-md-8">
                                            <!-- datos -->
                                            <div class="mb-4 datos">
                                                <h3 class="f-weight-70 text-dark mb-4">Datos</h3>
                                                <!-- row name -->
                                                <div class="mb-3 row date-profile">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Nombres</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <span class="black-main labeltex f-weight">{{$usuario -> nombres}}</span>
                                                    </div>
                                                </div>
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Apellidos</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <span class="black-main labeltex f-weight">{{$usuario -> apellidos}}</span>
                                                    </div>
                                                </div>
                                                <!-- row date -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Edad</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <span class="black-main labeltex f-weight">{{$usuario -> edad}}</span>
                                                    </div>
                                                </div>
                                                <!-- row phone -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">N° de Celular</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <span class="black-main labeltex f-weight">{{$usuario -> celular}}</span>
                                                    </div>
                                                </div>
                                                <!-- row pet -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Mascota</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <span class="black-main labeltex f-weight">Scamp</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- end date -->

                                            <!-- Email -->
                                            <div class="mt-5 datos">
                                                <h3 class="f-weight-70 text-dark mb-4">Email</h3>
                                                <!-- row name -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Email</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-6">
                                                        <span
                                                            class="black-main labeltex f-weight">{{$usuario -> email}}</span>
                                                    </div>
                                                </div>
                                                <!-- row pass -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Contraseña</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5 col-sm-6">
                                                        <span class="black-main labeltex f-weight">{{$usuario -> contrasena}}</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- end emails col-xl -->
                                    </div>
                                </section>

                                <!-- tabset 2-->
                                <section id="tab-2" class="tab-panel">
                                    <div class="row">
                                        <div class="col-xl-2 col-lg-3 col-md-3">
                                            <!-- link de muestra 
                        https://htmlstream.com/preview/front-dashboard-v2.1.1/user-profile-my-profile.html
                        -->
                                            <div class="d-flex justify-content-center align-items-start w-full h-full
                         position-relative">
                                                <label
                                                    class="avatar avatar-xxl avatar-circle avatar-uploader profile-cover-avatar"
                                                    for="editAvatarUploaderModal">
                                                    <img id="editAvatarImgModal" class="avatar-img"
                                                        src="./../../assets/img/img6.jpg" alt="Image Description">

                                                    <input type="file" class="js-file-attach avatar-uploader-input"
                                                        id="editAvatarUploaderModal" data-hs-file-attach-options="{
                                        &quot;textTarget&quot;: &quot;#editAvatarImgModal&quot;,
                                        &quot;mode&quot;: &quot;image&quot;,
                                        &quot;targetAttr&quot;: &quot;src&quot;,
                                        &quot;allowTypes&quot;: [&quot;.png&quot;, &quot;.jpeg&quot;, &quot;.jpg&quot;]
                                     }">

                                                    <span class="avatar-uploader-trigger shadow-sm">
                                                        <i class="ri-edit-line black-main avatar-uploader-icon"
                                                            style="font-size: 18px;"></i>
                                                        <!-- <i class="ri-edit-line avatar-uploader-icon shadow-sm"></i> -->
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                        <!-- end col-xl -->

                                        <div class="col-xl-9 col-lg-8 col-md-8">
                                            <!-- datos -->
                                            <div class="mb-4 datos">
                                                <h3 class="f-weight-70 text-dark mb-4">Datos</h3>
                                                <!-- row name -->
                                                <div class="mb-3 row date-profile">
                                                    <label class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first col-form-label required">Nombres</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight col-form-label required two-points"
                                                        for="emailaddress">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <input type="text" name="nombresa"
                                                            class="form-control c-princi black-main f-weight"
                                                            placeholder="" value="{{$usuario -> nombres}}">
                                                    </div>
                                                </div>
                                                <div class="mb-3 row date-profile">
                                                    <label class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first col-form-label required">Apellidos</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight col-form-label required two-points"
                                                        for="emailaddress">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <input type="text" name="apellidos"
                                                            class="form-control c-princi black-main f-weight"
                                                            value="{{$usuario -> apellidos}}">
                                                    </div>
                                                </div>
                                                <!-- row date -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight col-form-label required label-first">Edad</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <input type="text" name="edad"
                                                            class="form-control c-princi black-main f-weight"
                                                             value="{{$usuario -> edad}}">
                                                    </div>
                                                </div>
                                                <!-- row phone -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first col-form-label required">N°
                                                        de Celular</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <input type="tel" name="phone"
                                                            class="form-control c-princi black-main f-weight"
                                                            value="{{$usuario -> celular}}">
                                                    </div>
                                                </div>
                                                <!-- row pet -->
                                                <!-- <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first col-form-label required">Mascota</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5">
                                                        <input type="text" name="pets"
                                                            class="form-control c-princi black-main f-weight"
                                                            placeholder="Pets" value="Scamp">
                                                    </div>
                                                </div> -->
                                            </div>
                                            <!-- end date -->

                                            <!-- Email -->
                                            <div class="mt-5 datos">
                                                <h3 class="f-weight-70 text-dark mb-4">Email</h3>
                                                <!-- row name -->
                                                <div class="mb-3 row">
                                                    <label
                                                        class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first">Email</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-6">
                                                        <input type="email"
                                                            class="black-main c-princi f-weight form-control form-control-lg form-control-solid"
                                                            id="emailaddress" placeholder="Email Address"
                                                            name="emailaddress" value="{{$usuario -> email}}">

                                                    </div>
                                                </div>
                                                <!-- row pass -->
                                                <div class="mb-3 row">
                                                    <label class="col-lg-4 col-md-4 labeltext color-grey f-weight label-first form-label required" for="confirmemailpassword">Contraseña</label>
                                                    <label
                                                        class="col-lg-1 col-md-1 labeltext color-grey f-weight two-points">:</label>
                                                    <div class="col-lg-6 col-md-5 col-sm-6">
                                                        <input type="password"
                                                            class="black-main c-princi f-weight form-control form-control-lg form-control-solid"
                                                            name="confirmemailpassword" id="confirmemailpassword" value="{{$usuario -> contrasena}}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- end emails col-xl -->
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                    <!-- end nav bar -->

                </div>
            </div>
            <!-- end card -->
        </div>
        <!-- end row -->
    </div>
</div>


@endsection