@extends('front.layouts.user')
@section('content')

    <div class="modal modal-lg " id="prom-1" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content p-4">

                <h6>Envíale flores a tu mascota a nuestra oficina en Miraflores para que puedan acompañarla
                    en su proceso. </h6>
                <p><strong>Te detallamos la información para el envío de flores:</strong></p>
                <ul>
                    <li>Dirección: Calle Grimaldo del Solar 242, Miraflores 🌱.</li>
                    <li>Días: Martes</li>
                    <li>Horario: de 8 am a 10 pm</li>
                    <li>A nombre de: Gonzalo León</li>
                </ul>
                <p>Por favor toma en cuenta que solo recibimos flores durante el primer mes de su proceso,
                    ya que el tiempo de compostaje varía de acuerdo a cada mascota🌷💚.</p>
            </div>
        </div>
    </div>

    <div class="container-fluid py-4">
        <!-- Card bienvenida + boton -->
        <div class="row mb-4">
            <!-- bienvenida -->
            <div class="col-lg-9 mb-4 ">
                <div class="card bg-success-s z-index-2 med-card" style="position: relative;">
                    <img src="{{ asset('assets/img/comillas-dash.svg') }}" alt="" class="img-atras4">
                    <img src="{{ asset('assets/img/hoja-dash.svg') }}" alt="" class="img-atras3">
                    <div class="row p-3">
                        <div class="col-8 col-sm-7">
                            <div class="m-0 m-sm-4">
                                <h4 class="font-weight-bold mb-4">Estamos contigo, {{$usuario -> nombres}}</h4>
                                <h5 class="normal">Tu mascota nunca se fue, solo vuelve para crear más vida</h5>
                            </div>
                        </div>
                        <div class="col-4 col-sm-5 d-flex align-items-center">
                            <div class="d-flex justify-content-center">
                                <img src="{{ asset('assets/img/image__intro.png') }}" alt="" class="image-dash">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- card nuevo comienzo -->
            <div class="col-lg-3 mb-4">
                <div class="d-none bg-success2 card card-carousel overflow-hidden h-100 p-0"
                     style="position: relative;">
                    <img src="{{ asset('assets/img/huella-dash.svg') }}" alt="" class="img-atras5">
                    <div class="p-3">
                        <div class="d-flex justify-content-center nuevo-comienzo text-center">
                            <h2 class="caps text-white">Un nuevo </br><span class="t-verde">comienzo</span></h2>
                        </div>
                        <div class="text-md-center text-sm-center ">
                            <a type="button" href="{{ url('/servicio-nuevo') }}" class="btn btn-success btn-sm mb-0">
                                Servicio nuevo
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card card-carousel overflow-hidden h-100 p-3 bg-success2 position-relative">
                    <img src="{{ asset('assets/img/huella-dash.svg') }}" alt="" class="img-atras5">
                    <div class="row align-items-center h-100">
                        <div class="col-12 col-xl-1"></div>
                        <div class="col-4">
                            <img src="{{ asset('assets/img/nuevo-servicio.png') }}" alt="" class="w-100">
                        </div>
                        <div class="col-7">
                            <div class="">
                                <div class="mb-3">
                                    <p class="h5 text-white">Un nuevo </br>comienzo</p>
                                </div>
                                <div class="">
                                    <a href="{{ url('/servicio-nuevo') }}" class="btn btn-success btn-md mb-0">
                                        Nuevo servicio
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4 mb-4">
                <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                    <div class="row align-items-center h-100">
                        <div class="col-12 col-xl-1"></div>
                        <div class="col-4 col-lg-3">
                            <img src="{{ asset('assets/img/inicio-flores.png') }}" alt="" class="w-100">
                        </div>
                        <div class="col-8">
                            <div class="">
                                <div class="mb-3">
                                    <p class="h5 ">Envíale flores a tu </br><span class="t-verde">mascota</span></p>
                                </div>
                                <div class="">
                                    <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal"
                                            data-bs-target="#prom-1">
                                        Enviar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal modal-lg fade" id="prom-1" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content p-4">

                            <h6>Envíale flores a tu mascota a nuestra oficina en Miraflores para que puedan acompañarla
                                en su proceso. </h6>
                            <p><strong>Te detallamos la información para el envío de flores:</strong></p>
                            <ul>
                                <li>Dirección: Calle Grimaldo del Solar 242, Miraflores 🌱.</li>
                                <li>Días: Martes</li>
                                <li>Horario: de 8 am a 10 pm</li>
                                <li>A nombre de: Gonzalo León</li>
                            </ul>
                            <p>Por favor toma en cuenta que solo recibimos flores durante el primer mes de su proceso,
                                ya que el tiempo de compostaje varía de acuerdo a cada mascota🌷💚.</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4 mb-4">

                <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                    <div class="row align-items-center">
                        <div class="col-12 col-xl-1"></div>
                        <div class="col-4 col-lg-3">
                            <img src="{{ asset('assets/img/inicio-psi.png') }}" alt="" class="w-100">
                        </div>
                        <div class="col-8">
                            <div class="">
                                <div class="mb-3">
                                    <p class="h5">Te acompañamos en este<span class="t-verde"> momento difícil</span>
                                    </p>
                                    <p class="h6">Apoyo psicológico</p>
                                </div>
                                <div class="">
                                    <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal"
                                            data-bs-target="#prom-3">
                                        Separar cita
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal modal-lg fade" id="prom-3" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content p-4">
                            <p>Sabemos que este puede ser un momento difícil para ti, pero queremos que sepas que no
                                estás sol@. Si en algún momento del proceso necesitas conversar con alguien, te
                                comentamos que trabajamos en alianza con una psicóloga especialista en duelo que puede
                                ayudarte 🫂💚.</p>

                            <p>Nosotros trabajamos de la mano con la Psicóloga especialista en duelo, <strong>Alejandra
                                    Carbonel</strong> para ofrecerte sesiones de terapia donde podrás aprender
                                estrategias para sobrellevar el duelo y conversar sobre este tema en un ambiente seguro
                                .</p>

                            <p>Te recomendamos el paquete de 5 sesiones virtuales personalizadas con Alejandra, por un
                                costo de S/.500.</p>

                            <p>Si deseas conversar con Alejandra, puedes dejarnos tus datos en este formulario y ella se
                                comunicará lo más pronto posible contigo 🫂💚</p>

                            <p><a target="_blank" href="https://forms.gle/5DJqSXBNqtQEvi9V7"
                                  class="btn btn-success fs-6 semibold col-6 col-sm-4"> Separar cita </a></p>

                            <p>Muchas gracias y esperamos poder seguir acompañándote en este proceso y ofrecerte un
                                espacio donde puedas encontrar paz y consuelo.</p>

                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12 col-md-6 col-lg-4 mb-4">

                <div class="card card-carousel overflow-hidden h-100 p-3 bg-success-s">
                    <div class="row align-items-center h-100">
                        <div class="col-12 col-xl-1"></div>
                        <div class="col-4 col-xl-3">
                            <img src="{{ asset('assets/img/visita-mascota.png') }}" alt="" class="w-100">
                        </div>
                        <div class="col-8">
                            <div class="">
                                <div class="mb-3">
                                    <p class="h5 ">Visita a tu</br><span class="t-verde">mascota</span></p>
                                </div>
                                <div class="">
                                    <button type="button" class="btn btn-success btn-md mb-0" data-bs-toggle="modal"
                                            data-bs-target="#prom-2">
                                        Agendar visita
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal modal-lg fade" id="prom-2" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content p-4">
                            <h6>Visita a tu mascota en nuestro compostario durante su primer mes de transformación y
                                acompaña su proceso.</h6>
                            <p><strong>Para agendar la visita de tu mascota, ten en cuenta los siguientes detalles
                                    🌱:</strong></p>
                            <p>📅 Horarios de visitas:</p>
                            <ul>
                                <li>Viernes: De 11:00 a.m. a 1:00 p.m. y de 2:00 p.m. a 4:00 p.m.</li>
                                <li>Sábados: De 10:00 a.m. a 12:00 p.m.</li>
                                <li>Es necesario coordinar previamente todas las visitas.</li>
                            </ul>
                            <p>Cuando elijas el día de tu visita te enviaremos un correo con toda la información
                                necesaria para que tu día de visita sea especial 🫶🌱. ¡Te esperamos! 💚</p>

                        </div>
                    </div>
                </div>
            </div>

        </div>

        <!-- Slider -->
        <h4 class="f-weight mb-3 mt-3">Servicios</h4>
        <div class="row">
            <div class="col-lg-12">
                <!-- card -->
                <div class="card">
                    <!-- card slider -->
                    <div class="p-4 px-sm-5 position-relative">
                        <div class="carousel-items  {{ count($pedidos) > 1 ? 'active-slider' : '' }}">
                            @foreach($pedidos as $pedido)
                                <div class="carouselitem p-0 px-sm-5 ">
                                    <div class="row">
                                        <!-- Description -->
                                        <div class="col-lg-8 ">
                                            <div class="d-flex justify-content-between">
                                                <div
                                                    class="t-verde-o semibold rounded-pill d-flex justify-content-center {{$pedido->estado_pedido === 5 ? 'bg-blue-o' : 'bg-success-s'}}">
                                                    @if($pedido->estado_pedido === 1)
                                                        <div
                                                            class="p-2 px-4 fs-7 d-flex justify-content-center align-items-center">
                                                            <span>Recojo de Mascota</span>
                                                            <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}"
                                                                 alt="" class="ms-1">
                                                        </div>
                                                    @elseif($pedido->estado_pedido === 2)
                                                        <div
                                                            class="p-2 px-4 fs-7 d-flex justify-content-center align-items-center">
                                                            <span>Compostaje</span>
                                                            <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}"
                                                                 alt="" class="ms-1">
                                                        </div>
                                                    @elseif($pedido->estado_pedido === 3)
                                                        <div
                                                            class="p-2 px-4 fs-7 d-flex justify-content-center align-items-center">
                                                            <span>Logística</span>
                                                            <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}"
                                                                 alt="" class="ms-1">
                                                        </div>
                                                    @elseif($pedido->estado_pedido === 4)
                                                        <div
                                                            class="p-2 px-4 fs-7 d-flex justify-content-center align-items-center">
                                                            <span>Entrega de Maceta</span>
                                                            <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}"
                                                                 alt="" class="ms-1">
                                                        </div>
                                                    @elseif($pedido->estado_pedido === 5)
                                                        <div
                                                            class="p-2 px-4 fs-7 d-flex justify-content-center align-items-center text-white">
                                                            <span>Finalizado</span>
                                                            <img src="{{ asset('assets/img/icon_check-white.svg') }}"
                                                                 alt="" class="ms-1">
                                                        </div>
                                                    @endif
                                                </div>

                                            </div>

                                            <!-- Description Thanks-->
                                            <div>
                                                <h2 class="mt-4 f-weight text-dark h3">¡Gracias por confiar <br> en
                                                    <span class="t-verde">Nosotros!</span></h2>
                                                <p class="fs-5 text-dark pt-2 pb-3">Cuidaremos muy bien de <span
                                                        class="f-weight">{{ $pedido->nombre_mascota }}</span> durante su
                                                    proceso de biotransformación.</p>
                                            </div>
                                            <!-- description card-->
                                            <div class="info-description">
                                                <div class="d-none d-sm-block semibold col-lg-10 border border-success rounded-3 c-princi rounded ">
                                                    <div class="row p-4">
                                                        @if ($pedido->fecha_creacion)
                                                            <div
                                                                class="col-sm-4 col-md-5 d-flex align-items-center justify-content-lg-center justify-content-lg-start">
                                                                <div>
                                                                    <h4 class="f-weight">{{ $pedido->fecha_creacion }}</h4>
                                                                    <p class="text-sm normal">Inicio de
                                                                        biotransformación natural</p>
                                                                </div>
                                                            </div>
                                                        @endif
                                                        <div
                                                            class="col-sm-2 col-md-2 d-flex align-items-start justify-content-lg-center justify-content-lg-start">
                                                            <div>
                                                                <h4 class="f-weight">{{ $pedido->edad_mascota }}<span
                                                                        class="normal text-sm"> años</span></h4>
                                                                <p class="text-sm labeltext">Edad</p>
                                                            </div>
                                                        </div>
                                                        <div
                                                            class="col-sm-2 col-md-2 d-none align-items-start justify-content-lg-center justify-content-lg-start">
                                                            <div>
                                                                <h4 class="font-weight-bold">{{$pedido->peso_mascota}}
                                                                    <span class="normal text-sm "> Kg.</span></h4>
                                                                <p class="text-sm labeltext">Peso</p>
                                                            </div>
                                                        </div>
                                                        <div
                                                            class="col-md-3 col-sm-3 d-flex align-items-start justify-content-lg-center justify-content-lg-start">
                                                            <div>
                                                                <h4 class="semibold">{{$pedido->sexo_mascota}}</h4>
                                                                <p class="text-sm labeltext">Sexo</p>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Pets -->
                                        <div class="col-lg-4">
                                            <!-- card info de mascota -->
                                            <div class="card text-center w-100 bg-success-bj border card-height">
                                                <!-- card body image pets -->
                                                <a href="/mis-servicios/{{$pedido->id_pedido}}"
                                                   class="card-body d-flex flex-column justify-content-center">
                                                    <!-- header-->
                                                    <div class="header-label bg-surface-primary">
                                                        <p class="labeltext text-white">Servicio</p>
                                                        @if($pedido->id_servicio == 1)
                                                            <p class="f-weight">Vuelve a Casa</p>
                                                        @else
                                                            <p class="f-weight">Siempre Juntos</p>
                                                        @endif
                                                    </div>

                                                    <div class="d-flex justify-content-center">
                                                        <div class="pt-4 img-mascota">
                                                            @if ($pedido->tipo_mascota == 'Gat@')
                                                                <img src="{{ asset('assets/img/mascotas/gato.svg')}}"
                                                                     width="170" alt="gato">
                                                            @elseif ($pedido->tipo_mascota == 'Perr@')
                                                                <img src="{{ asset('assets/img/mascotas/perro.png')}}"
                                                                     width="170" alt="perro">
                                                            @elseif ($pedido->tipo_mascota == 'Conej@')
                                                                <img src="{{ asset('assets/img/mascotas/conejo.png')}}"
                                                                     width="170" alt="conejo">
                                                            @elseif ($pedido->tipo_mascota == 'Pajarito')
                                                                <img
                                                                    src="{{ asset('assets/img/mascotas/pajarito.png')}}"
                                                                    width="170" alt="pajarito">
                                                            @else
                                                                <img src="{{ asset('assets/img/mascotas/gato.svg')}}"
                                                                     width="170" alt="gato">
                                                            @endif
                                                        </div>
                                                    </div>

                                                    <!-- progress bar -->
                                                    <div class="progress-wrapper rounded-3">
                                                        <div
                                                            class="p-2 d-flex align-items-center justify-content-center">
                                                            @if($pedido->estado_pedido === 1)
                                                                <div class="progress w-75">
                                                                    <div class="progress-bar bg-info" role="progressbar"
                                                                         aria-valuenow="0" aria-valuemin="0"
                                                                         aria-valuemax="0"
                                                                         style="width: 20%;">
                                                                    </div>
                                                                </div>
                                                                <div class="progress-percentage align-items-center">
                                                                    <span
                                                                        class="text-sm f-weight labeltext ms-3">20%</span>
                                                                </div>
                                                            @elseif($pedido->estado_pedido === 2)
                                                                <div class="progress w-75">
                                                                    <div class="progress-bar bg-info" role="progressbar"
                                                                         aria-valuenow="0" aria-valuemin="0"
                                                                         aria-valuemax="0"
                                                                         style="width: 40%;"></div>
                                                                </div>
                                                                <div class="progress-percentage align-items-center">
                                                                    <span
                                                                        class="text-sm f-weight labeltext ms-3">40%</span>
                                                                </div>
                                                            @elseif($pedido->estado_pedido === 3)
                                                                <div class="progress w-75">
                                                                    <div class="progress-bar bg-info" role="progressbar"
                                                                         aria-valuenow="0" aria-valuemin="0"
                                                                         aria-valuemax="0"
                                                                         style="width: 60%;"></div>
                                                                </div>
                                                                <div class="progress-percentage align-items-center">
                                                                    <span
                                                                        class="text-sm f-weight labeltext ms-3">60%</span>
                                                                </div>
                                                            @elseif($pedido->estado_pedido === 4)
                                                                <div class="progress w-75">
                                                                    <div class="progress-bar bg-info" role="progressbar"
                                                                         aria-valuenow="0" aria-valuemin="0"
                                                                         aria-valuemax="0"
                                                                         style="width: 80%;"></div>
                                                                </div>
                                                                <div class="progress-percentage align-items-center">
                                                                    <span
                                                                        class="text-sm f-weight labeltext ms-3">80%</span>
                                                                </div>
                                                            @elseif($pedido->estado_pedido === 5)
                                                                <div class="progress w-75">
                                                                    <div class="progress-bar bg-info" role="progressbar"
                                                                         aria-valuenow="0" aria-valuemin="0"
                                                                         aria-valuemax="0"
                                                                         style="width: 100%;"></div>
                                                                </div>
                                                                <div class="progress-percentage align-items-center">
                                                                    <span
                                                                        class="text-sm f-weight labeltext ms-3">100%</span>
                                                                </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                </a>
                                            </div>
                                            <!-- cend ard body image pet -->
                                        </div>
                                    </div>
                                </div>
                            @endforeach

                        </div>
                        <div
                            class="{{ count($pedidos) > 1 ? 'd-flex' : 'd-none' }} justify-content-center align-items-center rounded-circle option-right-slider"
                            type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="prev">
                            <i class="fa-solid fa-chevron-right"></i>
                        </div>
                        <div
                            class="{{ count($pedidos) > 1 ? 'd-flex' : 'd-none' }} justify-content-center align-items-center rounded-circle option-left-slider"
                            type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide="next">

                            <i class="fa-solid fa-chevron-left"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
