@extends('front.layouts.web')
@section('content')
    <section>

        <div class="page-header py-3">
            <input type="hidden" name="id_user" id="id_user" value="{{$user_id}}">
            <div class="container">
                @if (isset($_GET))
                    @foreach ($_GET as $key => $value)
                        @if ($key != '_token' && is_array($value))
                            @foreach ($value as $key2 => $value2)
                                <input type="hidden" name="{{ $key }}[{{ $key2 }}]" value="{{ $value2 }}">
                            @endforeach
                        @elseif ($key != '_token')
                            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
                        @endif
                    @endforeach
                @endif
                @csrf
                <div class="row">
                    <div class="col-xl-6 col-lg-7 col-md-12">
                        <div class="my-4 card-header p-0 text-start">
                            <h1 class="semibold t-verde fs-4">Creando más vida con Vuelve</h1>
                        </div>
                        <div class="card card-plain metodos-pagos ">
                            <div class="card-header pb-0  ps-0 text-start">
                                <h2 class="f-weight text-dark fs-4">Detalle de pago</h2>
                                <p class="mt-4 text-sm">Selecciona como quieres hacer tu pago</p>
                                <div class="row mt-4">
                                    <div class="col-12">
                                        <div
                                            class="select-pasarela d-flex rounded-3 border align-items-center p-3 "
                                            data-id="cardPayment_visa">
                                            <div class="me-3">
                                                <img src="../../../assets/img/master.png" alt="">
                                            </div>
                                            <div class="me-3">
                                                <img src="../../../assets/img/visa.png" alt="">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="pasarela">
                                <div id="mercadopago" class="cardPayment cardPayment_visa">
                                    <h5 class="my-4 font-weight-bold">Realiza tu pago directamente con tarjeta Visa, Mastercard u otra billetera digital.</h5>
                                    <form method="POST" action="{{route('registrosiemprejuntos_processpaymentsubscription')}}">
                                        @csrf
                                        <div class="p-4">
                                            <input type="hidden" name="data" id="data" value="{{ $data }}">

                                            <p class=" text-xs">Agregar mensaje en pago de cuotas para Siempre Juntos: Las cuotas se cargarán automáticamente el mismo día de cada mes en que realizaste el primer pago (por ejemplo, si te
                                                suscribiste el día 5, se renovará siempre el día 5). Se
                                                realizará de forma mensual durante la cantidad de cuotas que elijas.</p>
                                            <button type="submit" class="btn btn-success btn-lg fs-6">Realizar pedido
                                            </button>
                                        </div>
                                    </form>
                                </div>
                                <div id="yape" class="cardPayment cardPayment_yape d-none">
                                    <form method="POST" action="/process_payment_deposito">
                                        @csrf
                                        <h5 class="my-4 font-weight-bold">Realiza tu pago directamente mediante Yape,
                                            Plin u otra billetera digital.</h5>
                                        <div class="p-4">
                                            <p class="font-weight-bold text-md">Yape o Plin: 937 172 737</p>

                                            <p class="mb-0 text-sm">A nombre de:</p>
                                            <p class="mb-0 font-weight-bold text-sm">Vuelve Compostario Ambiental
                                                SAC</p>
                                            <p class="font-weight-bold text-md">RUC: 20612298727</p>

                                            <input type="hidden" name="data" id="data" value="{{ $data }}">

                                            <p class=" text-xs">Al finalizar el pedido, adjunta tu comprobante de pago
                                                en el siguiente paso para que tu pedido pueda ser confirmado y
                                                procesado.</p>
                                            <button type="submit" class="btn btn-success btn-lg fs-6">Realizar pedido
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <div class="text-md-end mt-4">
                                <a href="{{ route('registrosiemprejuntos_cuotas') }}"
                                   class="mx-1 btn btn-outline-dark btn-lg fs-6 w semibold">Volver</a>
                                {{-- <button type="submit" class="btn btn-success btn-lg fs-6 semibold">Continuar</button> --}}
                            </div>
                        </div>
                        <hr>
                        <div class="">
                            <div class="d-flex justify-content-between align-items-center">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 text-xs normal">
                                    <i class="t-verde fa-solid fa-check"></i></div>
                                <hr class="flex-grow-1 hr-v">
                                <div
                                    class="text-center rounded-circle orden border border-success border-2 bg-success text-white text-xs normal">
                                    6
                                </div>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <h6 class="f-weight text-xs">Datos</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Mascota</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Recojo</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Extras</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Cuotas</h6>
                                <hr class="flex-grow-1 hr-t">
                                <h6 class="f-weight text-xs">Pago</h6>
                            </div>
                        </div>

                    </div>
                    <div class="col-1"></div>
                    <div class="col-xl-5 col-lg-7 col-md-12 h-100">
                        <div id="imgloquiero" class=" pe-0 text-center justify-content-center flex-column">
                            <div
                                class="position-relative bg-success h-100 p-5 border-radius-lg d-flex flex-column justify-content-center overflow-hidden">
                                <div class="rounded-top bg-white-transparent">
                                    <div class="m-4">
                                        <div class="row justify-content-between">
                                            <div class="col-12">
                                                <h4 class="semibold text-start text-white">Resumen</h4>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="my-2">
                                    <img src="../../assets/img//mi-servicio.png" alt="">
                                </div>
                                <div class="mb-3 mx-4">
                                    <h4 class="semibold text-start text-white">Servicio <br>Vuelve a Casa</h4>
                                </div>

                                @if ($_GET['forma-pago'] == 'cuotas')
                                    <input type="hidden" id="precio-cuota" name="precio-cuota" value="cuota">
                                    <div class="bg-white-transparent-2">
                                        <div class="p-4">
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white">Pago 1º Cuota</h6>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="normal text-start text-white text-end">
                                                        S/.{{ $precioTotal }}</h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="rounded-bottom bg-white-transparent">
                                        <div class="p-4">
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h4 class="semibold text-start text-white" id="texto-total">
                                                        Total</h4>

                                                </div>
                                                <div class="col-4">
                                                    <h4 class="semibold text-start text-white text-end ">
                                                        S/.{{ $precioTotal }}</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @else
                                    <div class="bg-white-transparent-2">
                                        <div class="p-4">
                                            <div class="row justify-content-between hide">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white">Servicio</h6>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="normal text-start text-white text-end">
                                                        S/.{{ $_GET['precio-servicio'] }}</h6>
                                                </div>
                                            </div>
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white">Servicio</h6>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="normal text-start text-white text-end">
                                                        S/.{{ $_GET['precio-peso'] }}</h6>
                                                </div>
                                            </div>
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white">Extra</h6>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="normal text-start text-white text-end">
                                                        S/.{{ $_GET['precio-extra'] }}</h6>
                                                </div>
                                            </div>

                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h6 class="normal text-start text-white">Recojo</h6>
                                                </div>
                                                <div class="col-4">
                                                    <h6 class="normal text-start text-white text-end">
                                                        S/.{{ $_GET['precio-recojo'] }}</h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="rounded-bottom bg-white-transparent">
                                        <div class="p-4">
                                            <div class="row justify-content-between">
                                                <div class="col-6">
                                                    <h4 class="semibold text-start text-white" id="texto-total">
                                                        Total</h4>
                                                </div>
                                                <div class="col-4">
                                                    <h4 class="semibold text-start text-white text-end ">
                                                        S/.{{ $_GET['precio-total'] }}</h4>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                @endif


                                <div class="rounded border border-light-subtle mt-7">
                                    <p class="normal m-3 fs-6 text-white">Muchas gracias por confiar en nosotros y ser
                                        parte de esta familia sostenible. 🌍♻</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
