@extends('front.layouts.web')
@section('content')
    <div class="c-princi py-3 py-sm-5">
        <section class="container">
            <h1 class="font-weight-bold fs-2">Nuestros Servicios</h1>
            <div class="row mt-5 d-flex align-items-center">
                <!-- PSJ -->
                <div class="col-lg-2"></div>
                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card  h-100">
                        <div class="card-body px-4 py-4 py-sm-5 text-center">
                            <div class="d-flex justify-content-between flex-column h-100">
                                <div>
                                    <div>
                                        <h1 class="font-weight-bold t-verde mb-4 fs-2">Plan Siempre <br>Juntos</h1>
                                        <p class="mb-4 text-sm">Anticípate y asegura un descanso digno y ecológico para tu
                                            mascota. Nuestro servicio funciona como un seguro: paga de manera anticipada y,
                                            cuando llegue el momento, nos encargamos de todo, desde la recolección hasta el
                                            compostaje sostenible.</p>
                                        <p class="mb-0 text-sm">Por qué elegir nuestro plan para compostaje de mascotas:</p>
                                    </div>
                                    <div class="d-flex justify-content-center mt-3">
                                        <div class="text-start">
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1"><strong>Tranquilidad:</strong> Despídete del
                                                    estrés
                                                    de organizar los detalles cuando llegue el momento.</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1"><strong>Sostenibilidad:</strong> Contribuye al
                                                    medio
                                                    ambiente con un proceso respetuoso y ecológico.</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1"><strong>Acompañamiento personalizado:</strong>
                                                    Te
                                                    brindamos apoyo integral en cada paso.</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1"><strong>Ahorro:</strong> Al contratar el
                                                    servicio con
                                                    anticipación, obtienes un precio preferencial.</p>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="mx-3 text-center">Planifica hoy y vive con la certeza de que estarás preparado
                                        cuando lo necesites.</p>
                                </div>
                                <div class="mt-4 d-flex justify-content-center">
                                    <a href="{{ url('/registro-siempre-juntos') }}"
                                       class="d-lg-block m-0 btn btn-success btn-lg fs-6 semibold">Elegir Servicio</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-lg-4 mb-4">
                    <div class="card  h-100" style="min-height: 891px">
                        <div class="card-body px-4 py-4 py-sm-5 text-center">
                            <!-- vuelve a casa -->
                            <div class="d-flex justify-content-between flex-column h-100">
                                <div>
                                    <div class="">
                                        <h1 class="font-weight-bold t-verde mb-4 fs-2">Vuelve a <br> Casa</h1>
                                        <p class="mb-0 text-sm">Mascota vuelve a casa en una nueva forma de vida, una
                                            hermosa
                                            planta sembrada con su compost.</p>
                                    </div>
                                    <div class="my-4">
                                        <p class="mb-0 text-secondary">DESDE</p>
                                        <h1 class="mb-0 semibold">S/.590</h1>
                                    </div>

                                    <div class="d-flex justify-content-center">
                                        <div class="text-start">
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Recojo de mascota a domicilio</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Traslado a nuestro Compostario</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Proceso de compostaje es entre 2 - 3 meses</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Maceta con planta y su nombre</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Print de su huella en una piedra</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Entrega de planta de vuelta a casa</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="mt-4 d-flex justify-content-center">
                                    <a href="{{ url('/registro-vuelve-a-casa') }}"
                                       class="d-lg-block m-0 btn btn-success btn-lg fs-6 semibold">Elegir Servicio</a>
                                </div>
                            </div>
                        </div>
                        <!-- end -->
                    </div>
                </div>
                <!-- end col 1 -->


            </div>
            <!-- Vuelve cenizas -->
            <div class="row">
                <div class="col-lg-4"></div>
                <div class="col-lg-4 mb-4 opacity-5">
                    <div class="card ">
                        <div class="card-body px-4 py-4 py-sm-5 text-center">
                            <div class="d-flex justify-content-between flex-column h-100">
                                <div>
                                    <div>
                                        <h1 class="font-weight-bold t-verde mb-4 fs-2">Vuelve Cenizas</h1>
                                        <p class="mb-0 text-sm">Para quienes ya han tenido que despedirse de su mascota,
                                            ofrecemos
                                            la posibilidad de transformar sus cenizas en abono, creando así un hermoso
                                            legado que puede convertirse en una planta viva</p>
                                    </div>
                                    <div class="my-2">
                                        <h2 class="mb-0 semibold">S/.390</h2>
                                    </div>
                                    <div class="d-flex justify-content-center">
                                        <div class="text-start">
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Recojo de cenizas domicilio</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Proceso de compostaje de 2 meses</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Maceta con planta y su nombre</p>
                                            </div>
                                            <div class="mt-2 d-flex">
                                                <i class="fs-5 normal fa-regular fa-circle-check t-verde m-2"></i>
                                                <p class="normal mt-1 mb-1">Entrega de planta</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="mt-4 d-flex justify-content-center">
                                    <a href="#"
                                       class="d-lg-block m-0 btn btn-success btn-lg fs-6 semibold">Elegir Servicio</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
@endsection
