@extends('front.layouts.web')
@section('content')
    <section class="container mt-5 mb-6">
        @if (session('exito'))
            <div class="container">
                <div class="alert alert-success white-color" role="alert">
                    {{ session('exito') }}
                </div>
            </div>
        @elseif (session('error'))
            <div class="container">
                <div class="alert alert-danger white-color" role="alert">
                    {{ session('error') }}
                </div>
            </div>
        @endif
        @if (empty($_GET['token']))
            <div class="card-header p-0 py-4 text-center">
                <h1 class="fs-4 semibold t-verde">Gracias por confiar en nosotros para transformar a su mascota en más vida</h1>
            </div>
            <div class="text-center">
                <h4 class="f-weight m-2 mt-3">Crea tu contraseña para completar y activar tu cuenta</h4>
            </div>
            <div>
                <div class="d-flex justify-content-center p-3">
                    <div class="mt-5 col-lg-4 col-md-5 col-12">
                        <div class="mb-4">
                            <label for="fieldPassword1" class="text-dark form-label">Nueva contraseña</label>
                            <input type="password" disabled class="form-control" id="fieldPassword1" minlength="8"
                                   name="password1" placeholder="Escribe aquí">
                            <div>
                                <h6 class="letra3 m-3">Por tu seguridad, considera un mínimo de 8 caracteres.</h6>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="fieldPassword2" class="text-dark form-label">Confirma tu nueva contraseña</label>
                            <input disabled type="password" class="form-control" id="fieldPassword2" name="password2"
                                   placeholder="Escribe aquí">
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-center">

                    <a href="/iniciar-sesion" class="my-4 fs-6 semibold btn btn-success d-flex justify-content-center col-md-2 col-sm-4 col-5">
                        <h6 class="m-1 fw700">Iniciar sesion</h6>
                    </a>

                </div>
            </div>
        @else
            <div class="card-header p-0 py-4 text-center">
                <h1 class="fs-4 semibold t-verde">Gracias por confiar en nosotros para transformar a su mascota en más vida</h1>
            </div>
            <div class="text-center">
                <h4 class="f-weight m-2 mt-3">Crea tu contraseña para completar y activar tu cuenta</h4>
            </div>
            <form method="POST">
                @csrf
                <div class="d-flex justify-content-center p-3">
                    <div class="mt-5 col-lg-4 col-md-5 col-12">
                        <div class="mb-4">
                            <label for="fieldPassword1" class="text-dark form-label">Nueva contraseña</label>
                            <input type="password" class="form-control" id="fieldPassword1" minlength="8"
                                   name="password1" placeholder="Escribe aquí">
                            <div>
                                <h6 class="letra3 m-3">Por tu seguridad, considera un mínimo de 8 caracteres.</h6>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="fieldPassword2" class="text-dark form-label">Confirma tu nueva contraseña</label>
                            <input type="password" class="form-control" id="fieldPassword2" name="password2"
                                   placeholder="Escribe aquí">
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-center">
                    <button type="submit" class="my-4 btn btn-success d-flex justify-content-center col-md-2 col-sm-4 col-5">
                        <h6 class="m-1 fw700">Crear Contraseña</h6>
                    </button>
                </div>
            </form>
        @endif
    </section>
@endsection
