@extends('front.layouts.useradministrador')
@section('content')
<div class="container-fluid">
    @if (session('exito'))
    <div class="mt-4">
        <div class="alert mb-0 alert-success text-white" role="alert">
            {{ session('exito') }}
        </div>
    </div>
    @elseif (session('error'))
    <div class="mt-4">
        <div class="alert mb-0 alert-danger text-white" role="alert">
            {{ session('error') }}
        </div>
    </div>
    @endif
    <div class="row">
        <!-- Head title -->
        <div class="col-xl-12 mt-4">
            <div class="card-header">
                <h4 class="font-weight-bold">Productos</h4>
            </div>
        </div>
        
        <!-- Tabla de Usuarios creados -->
        <div class="col-xl-12 py-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="font-weight-bold">Listado de productos extras</h5>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-flush">
                            <thead class="c-princi">
                                <tr role="row">
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Id</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Nombre del producto</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Imagen</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Precio S/.</span></th>
                                    {{-- <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Almacen</span></th> --}}
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Vendidos</span></th>
                                    {{-- <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Disponible</span></th> --}}
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Opciones</span></th>
                                </tr>
                            </thead>

                            <t-body class="position-relative">
                                @foreach ( $productos as $producto)
                                <tr>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->id_producto}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->nombre_producto}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td"><img height="100" src="{{ asset('assets/img/'.$producto->imagen) }}"> </span></td>
                                    {{-- <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->precio}}</span></td> --}}
                                    <td class="f-weight-50 black-main text-xs producto-id-{{$producto->id_producto}}">
                                        <form action="" method="POST" class="">
                                            @csrf
                                            <input style="width: 50px" type="number" disabled class="text-center input-number" name="stock" id="stock" value="{{$producto->precio}}">
                                            <input type="hidden" class="text-center" name="id_producto" id="id_producto" value="{{$producto->id_producto}}">
                                            <input type="hidden" class="text-center" name="tipo" id="tipo" value="producto">
                                            <br/>
                                            <button type="submit" style="width: 70px" class="btn mt-1 p-1 btn-xs btn-success d-none">Actualizar</button>
                                        </form>
                                    </td>
                                    
                                    
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->total_vendido}}</span></td>
                                    {{-- <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->stock - $producto->total_vendido}}</span></td> --}}
                                    <td class="f-weight-50 black-main text-xs">
                                        <a style="width: 70px" class="nav-link border rounded form-maceta" data-form="producto-id-{{$producto->id_producto}}">
                                            <i class="ri-pencil-line" style="margin: 0 5px"></i>
                                            <span>Editar</span>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                                
                                
                            </t-body>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 py-3">
            <div class="card">
                <div class="card-header">
                    <h5 class="font-weight-bold">Listado de Macetas</h5>
                </div>

                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-flush">
                            <thead class="c-princi">
                                <tr role="row">
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Id</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Nombre de la maceta</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Imagen</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Altura</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Diametro</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Compras</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Almacen</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Vendidos</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Disponible</span></th>
                                    <th class="px-0 text-xs f-weight color-grey"><span class="text-thead">Opciones</span></th>
                                </tr>
                            </thead>

                            <t-body class="position-relative">
                                @foreach ( $productos_maceta as $producto)
                                <tr>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->id_maceta}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->nombre}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td"><img height="100" src="{{ asset('assets/img/'.$producto->modelo) }}"> </span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->altura}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->diametro}}</span></td>
                                    <td class="f-weight-50 black-main text-xs maceta-id-{{$producto->id_maceta}}">
                                        <form action="" method="POST" class="">
                                            @csrf
                                            <input style="width: 50px" type="number" disabled class="text-center input-number" name="almacen" id="stock" value="0">
                                            <input style="width: 50px" type="hidden" class="text-center input-number" name="stock" id="stock-1" value="{{$producto->stock}}">
                                            <input type="hidden" class="text-center" name="id_producto" id="id_producto" value="{{$producto->id_maceta}}">
                                            <input type="hidden" class="text-center" name="tipo" id="tipo" value="maceta">
                                            <br/>
                                            <button type="submit" style="width: 70px" class="btn mt-1 p-1 btn-xs btn-success d-none">Actualizar</button>
                                        </form>
                                    </td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->stock}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->total_registradas}}</span></td>
                                    <td class="f-weight-50 black-main text-xs"><span class="text-td">{{$producto->stock - $producto->total_registradas}}</span></td>
                                    <td class="f-weight-50 black-main text-xs">
                                        <a style="width: 70px" class="nav-link border rounded form-maceta" data-form="maceta-id-{{$producto->id_maceta}}">
                                            <i class="ri-pencil-line" style="margin: 0 4px"></i>
                                            <span>Agregar</span>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </t-body>
                        </table>
                    </div>
                    <!-- <div class="row">
                        <div class="col-xl-12 d-flex justify-content-end mt-3">
                            <a href="" type="button" class="btn">Guardar cambios</a>
                        </div>
                    </div> -->
                </div>
            </div>
        </div>
    </div>
</div>


@endsection