@extends('front.layouts.useradministrador')
@section('content')
    <div class="container-fluid py-4">
        <!-- Navbar tabs Primary-->
        <div class="w-full button-bd d-flex justify-content-between align-items-center py-4">
            <a href="{{ url('/admin/base-de-datos/vuelve-a-casa') }}" class="btn btn-outline-dark h-full py-3">Vuelve a Casa</a>
            {{--        <a href="{{ url('/admin/base-de-datos/vuelve-ceniza') }}" class="btn btn-success h-full py-3">Vuelve Cenizas</a>--}}
            {{--        <a href="{{ url('/admin/base-de-datos/vuelve-solidario') }}" class="btn btn-outline-dark py-3">Vuelve Solidario</a>--}}
            <a href="{{ url('/admin/base-de-datos/plan-siempre-juntos') }}" class="btn btn-outline-dark py-3">Siempre Juntos</a>
        </div>

        <div class="row" style="position: relative;">
            <div class="col-lg-12 mb-4 mb-lg-0">
                <div class="card z-index-2 h-100">
                    <div class="container-fluid py-2">
                        <div class="tab-nav-tabs my-3">
                            <ul class="nav nav-tabs nav.overflow-x mb-4" id="pills-tab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active f-weight" id="pills-usuario-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-usuario" type="button" role="tab"
                                            aria-controls="pills-usuario" aria-selected="true">Datos de usuario
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link f-weight" id="pills-mascota-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-mascota" type="button" role="tab"
                                            aria-controls="pills-mascota" aria-selected="true">Datos de mascota
                                    </button>
                                    <!-- <span class="badge bg-soft-dark text-dark rounded-circle ms-1">3</span> -->
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link f-weight" id="pills-direccion-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-direccion" type="button" role="tab"
                                            aria-controls="pills-direccion" aria-selected="true">Dirección
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link f-weight" id="pills-extras-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-extras" type="button" role="tab" aria-controls="pills-extras"
                                            aria-selected="true">Extras
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link f-weight" id="pills-pago-tab" data-bs-toggle="pill"
                                            data-bs-target="#pills-pago" type="button" role="tab" aria-controls="pills-pago"
                                            aria-selected="true">Pago
                                    </button>
                                </li>
                            </ul>

                            <div class="tab-content" id="pills-tabContent">
                                <!-- usuario -->
                                <div class="tab-pane fade show active" id="pills-usuario" role="tabpanel"
                                     aria-labelledby="pills-usuario-tab" tabindex="0">
                                    <div class="row">
                                        <div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div>
                                                        <table class="table table-flush" id="datatable-search">
                                                            <thead class="bg-grey-10">
                                                            <tr>
                                                                <th class="text-xs f-weight color-grey">N°</th>
                                                                <th class="text-xs f-weight color-grey">Fecha</th>
                                                                <th class="text-xs f-weight color-grey">Nos
                                                                    conocieron
                                                                </th>
                                                                <th class="text-xs f-weight color-grey">Nombre y Ap.
                                                                </th>
                                                                <th class="text-xs f-weight color-grey">Edad</th>
                                                                <th class="text-xs f-weight color-grey">Celular</th>
                                                                <th class="text-xs f-weight color-grey">Email</th>
                                                                <th class="text-xs f-weight color-grey">Opciones
                                                                </th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            @foreach ( $objUsers as $key => $objUser)

                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">{{$key}}</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">{{$objUser -> fecha_creacion}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Instagram</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">{{$objUser -> nombres}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">{{$objUser -> edad}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">{{$objUser -> celular}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                    <span
                                                                        class="my-2 text-sm">{{$objUser -> email}}</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-3 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>

                                                            @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- mascota -->
                                <div class="tab-pane fade" id="pills-mascota" role="tabpanel"
                                     aria-labelledby="pills-mascota-tab" tabindex="0">
                                    <div class="row">
                                        <div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div>
                                                        <div class="table-responsive">
                                                            <table class="table table-flush" id="datatable-search2">
                                                                <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="f-weight color-grey">N°</th>
                                                                    <th class="f-weight color-grey">Nombre</th>
                                                                    <th class="f-weight color-grey">Edad</th>
                                                                    <th class="f-weight color-grey">Peso</th>
                                                                    <th class="f-weight color-grey">F. Fallecimiento
                                                                    </th>
                                                                    <th class="f-weight color-grey">Tipo</th>
                                                                    <th class="f-weight color-grey">Sexo</th>
                                                                    <th class="f-weight color-grey">Motivo de
                                                                        Fallecimiento
                                                                    </th>
                                                                    <th class="f-weight color-grey">Status</th>
                                                                    <th class="f-weight color-grey">Opciones</th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                @foreach ( $objMascotas as $key => $objMascota)

                                                                    <tr>
                                                                        <td>
                                                                            <div class="d-flex align-items-center">
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input"
                                                                                           type="checkbox" id="customCheck1">
                                                                                </div>
                                                                                <p class="text-sm f-weight-50 ms-2 mb-0">{{$key}}
                                                                                </p>
                                                                            </div>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> nombre_mascota}}</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> edad_mascota}}</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> peso_mascota}} Kg.</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> fechavida_mascota}}</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> tipo_mascota}}</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">{{$objMascota -> sexo_mascota}}</span>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main">
                                                                            <span class="my-2 text-sm">Enfermedad</span>
                                                                        </td>
                                                                        <td>
                                                                            <div
                                                                                class="text-white rounded-pill bg-success2 d-flex justify-content-center status-chip">
                                                                                <div class="f-weight-40 py-1 px-3 text-sm">
                                                                                    Recojo
                                                                                    <img src="../../assets/img/recojo_status.svg"
                                                                                         alt="" class="ms-1">
                                                                                </div>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <a class="btn-sm btn-square"><i
                                                                                    class="ri-pencil-line"
                                                                                    style="font-size: 20px;"></i></a>
                                                                            <a type="button"
                                                                               class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                        </td>
                                                                    </tr>
                                                                @endforeach

                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- dirección -->
                                <div class="tab-pane fade" id="pills-direccion" role="tabpanel"
                                     aria-labelledby="pills-direccion-tab" tabindex="0">
                                    <div class="row">
                                        <div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div>
                                                        <div class="table-responsive">
                                                            <table class="table table-flush" id="datatable-search3">
                                                                <thead class="bg-grey-10" style="width: 100%">
                                                                <tr>
                                                                    <th class="f-weight color-grey text-xs">N°</th>
                                                                    <th class="f-weight color-grey text-xs">Día</th>
                                                                    <th class="f-weight color-grey text-xs">Hora</th>
                                                                    <th class="f-weight color-grey text-xs">Distrito
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Dirección
                                                                        exacta
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Veterinaria
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Refugio</th>
                                                                    <th class="f-weight color-grey text-xs">Fecha de
                                                                        entrrega
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Dirección de
                                                                        entrega
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Opciones
                                                                    </th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                @foreach ( $objDirecciones as $key => $objDireccion)

                                                                    <tr>
                                                                        <td>
                                                                            <div class="d-flex align-items-center">
                                                                                <div class="form-check">
                                                                                    <input class="form-check-input"
                                                                                           type="checkbox" id="customCheck1">
                                                                                </div>
                                                                                <span
                                                                                    class="text-sm f-weight-50 ms-2 mb-0 black-main">{{$key}}</span>
                                                                            </div>
                                                                        </td>
                                                                        <td class="f-weight-50 black-main text-sm">
                                                                            Jesús María
                                                                        </td>
                                                                        <td class="f-weight-50 black-main text-sm">{{$objDireccion->direccion_recojo}}</td>
                                                                        <td class="f-weight-50 black-main text-sm">
                                                                            Refugio 1
                                                                        </td>
                                                                        <td class="f-weight-50 black-main my-2 text-sm">
                                                                            00/00/2023
                                                                        </td>
                                                                        <td class="f-weight-50 black-main text-sm">
                                                                            Santiago de Surco
                                                                        </td>
                                                                        <td class="f-weight-50 black-main text-sm">
                                                                        <span class="my-2 text-sm">Avenida Paseo la
                                                                            Castellana 386 Santiago de Surco
                                                                            Municipalidad Metropolitana de Lima LIMA,
                                                                            33</span>
                                                                        </td>
                                                                        <td>
                                                                            <a class="btn-sm btn-square"><i
                                                                                    class="ri-pencil-line"
                                                                                    style="font-size: 20px;"></i></a>
                                                                            <a type="button"
                                                                               class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                        </td>
                                                                    </tr>

                                                                @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- extras -->
                                <div class="tab-pane fade" id="pills-extras" role="tabpanel"
                                     aria-labelledby="pills-extras-tab" tabindex="0">
                                    <div class="row">
                                        <div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div>
                                                        <div class="table-responsive">
                                                            <table class="table table-flush" id="datatable-search4">
                                                                <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="f-weight color-grey">N°</th>
                                                                    <th class="f-weight color-grey">Bolsa de Compost
                                                                    </th>
                                                                    <th class="f-weight color-grey">Maceta</th>
                                                                    <th class="f-weight color-grey">Cuadro</th>
                                                                    <th class="f-weight color-grey">Dije</th>
                                                                    <th class="f-weight color-grey">Llavero</th>
                                                                    <th class="f-weight color-grey">Libro</th>
                                                                    <th class="f-weight color-grey">Color de Maceta</th>
                                                                    <th class="f-weight color-grey">Tipo de Planta</th>
                                                                    <th class="f-weight color-grey">Opciones</th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <p class="text-sm f-weight-50 ms-2 mb-0">001
                                                                            </p>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Lo quiero</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">1</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">0</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Amarillo</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-sm">Pachyphytum
                                                                            Clavifolium</span>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!-- pago -->
                                <div class="tab-pane fade" id="pills-pago" role="tabpanel" aria-labelledby="pills-pago-tab"
                                     tabindex="0">
                                    <div class="row">
                                        <div>
                                            <div class="row">
                                                <div class="col-12">
                                                    <div>
                                                        <div class="table-responsive">
                                                            <table class="table table-flush" id="datatable-search5">
                                                                <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="f-weight color-grey text-xs">N°</th>
                                                                    <th class="f-weight color-grey text-xs">Monto del
                                                                        Servicio
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Extra por
                                                                        horario
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Costo por
                                                                        distrito
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Productos
                                                                        Extras
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Método de
                                                                        Pago
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Pago en
                                                                        Cuotas
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Monto de
                                                                        Cuotas
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Fecha de
                                                                        Pagos
                                                                    </th>
                                                                    <th class="f-weight color-grey text-xs">Opciones
                                                                    </th>
                                                                </tr>
                                                                </thead>
                                                                <tbody>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td>
                                                                        <div class="d-flex align-items-center">
                                                                            <div class="form-check">
                                                                                <input class="form-check-input"
                                                                                       type="checkbox" id="customCheck1">
                                                                            </div>
                                                                            <span
                                                                                class="text-sm f-weight-50 ms-2 mb-0 black-main">001</span>
                                                                        </div>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">S/.600
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">0</td>
                                                                    <td class="f-weight-50 black-main text-sm">Yape</td>
                                                                    <td class="f-weight-50 black-main text-sm">2</td>
                                                                    <td>
                                                                        <li
                                                                            class="dropdown nav-item d-flex align-items-center">
                                                                            <a href="javascript:;" class="nav-link px-0"
                                                                               id="dropdownMenuButton"
                                                                               data-bs-toggle="dropdown"
                                                                               aria-expanded="false">
                                                                                <span
                                                                                    class="my-2 text-sm f-weight-50 black-main">S/.170</span>
                                                                                <i
                                                                                    class="fa-solid fa-chevron-down text-sm ms-5"></i>
                                                                            </a>
                                                                            <ul class="d-flex justify-content-center dropdown-menu dropdown-menu-end py-4"
                                                                                aria-labelledby="dropdownMenuButton">
                                                                                <div>
                                                                                    <div
                                                                                        class="tex-xs semibold text-secondary">
                                                                                        Boleta
                                                                                    </div>
                                                                                    <div
                                                                                        class="f-weight-70 black-main mt-2 mb-3 text-dark">
                                                                                        EB01-154
                                                                                    </div>
                                                                                    <button type="button"
                                                                                            class="btn btn-success btn-sm">Guardar
                                                                                    </button>
                                                                                </div>
                                                                            </ul>
                                                                        </li>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-sm">
                                                                        00/00/2024
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                           class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
