@extends('front.layouts.useradministrador')
@section('content')
<div class="container-fluid py-4">
    <!-- Navbar tabs Primary-->
    <div class="w-full">
        <a href="{{ url('/admin/base-de-datos/vuelve-a-casa') }}" class="btn btn-success h-full py-3 col-3">Vuelve a Casa</a>
        <a href="{{ url('/admin/base-de-datos/plan-siempre-juntos') }}" class="btn btn-outline-dark py-3 col-3">Plan Siempre Juntos</a>
        {{-- <a href="{{ url('/admin/base-de-datos/vuelve-ceniza') }}" class="btn btn-outline-dark h-full py-3">Vuelve Cenizas</a> --}}
        {{-- <a href="{{ url('/admin/base-de-datos/vuelve-solidario') }}" class="btn btn-outline-dark py-3">Vuelve Solidario</a> --}}
    </div>

    <div class="row" style="position: relative;">
        <div class="col-lg-12 mb-4 mb-lg-0">
            <div class="card z-index-2 h-100">
                <div class="container-fluid py-2">
                    <div class="tab-nav-tabs my-3">
                        <ul class="nav nav-tabs nav.overflow-x mb-4" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm active ms-0 f-weight" id="pills-usuario-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-usuario" type="button" role="tab"
                                    aria-controls="pills-usuario" aria-selected="true">Datos de usuario</label>
                            </li>
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm f-weight" id="pills-mascota-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-mascota" type="button" role="tab"
                                    aria-controls="pills-mascota" aria-selected="true">Datos de mascota</label>
                            </li>
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm f-weight" id="pills-direccion-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-direccion" type="button" role="tab"
                                    aria-controls="pills-direccion" aria-selected="true">Dirección de recojo</label>
                            </li>
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm f-weight" id="pills-direccione-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-direccione" type="button" role="tab"
                                    aria-controls="pills-direccione" aria-selected="true">Dirección de entrega</label>
                            </li>
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm f-weight" id="pills-extras-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-extras" type="button" role="tab" aria-controls="pills-extras"
                                    aria-selected="true">Extras</label>
                            </li>
                            <li class="nav-item" role="presentation">
                                <label class="nav-link text-sm f-weight" id="pills-pago-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-pago" type="button" role="tab" aria-controls="pills-pago"
                                    aria-selected="true">Pago</label>
                            </li>
                        </ul>

                        <div class="tab-content" id="pills-tabContent">
                            <!-- usuario -->
                            <div class="tab-pane fade show active" id="pills-usuario" role="tabpanel"
                                aria-labelledby="pills-usuario-tab" tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <table class="table table-flush" id="datatable-search">
                                                        <thead class="bg-grey-10">
                                                            <tr>
                                                                <th class="px-0 text-xs f-weight color-grey">N° de Pedido</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Año</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha°</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Mes</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Correo</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Nombres</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Apellidos</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Celular</th>
                                                                <th class="px-0 text-xs f-weight color-grey">DNI</th>

                                                                <th class="px-0 text-xs f-weight color-grey">Nombre de mascota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Tipo Mascota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha fallecimento</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Peso</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Tipo de compost</th>

                                                                <th class="px-0 text-xs f-weight color-grey">Distrito Recojo</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Dirección</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Método Pago</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Edad mascota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Motivo muerte</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Horario recojo</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cómo te enteraste de nosotros</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cantidad de cuotas</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Dirección de entrega de planta</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Sexo de mi mascota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Edad cliente</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Servicio es de vet aliada</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Nombre Vet</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Monto servicio</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Producto extra</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Movilidad cobrada a cliente</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cobro extra x horario</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Descuentos o cobros adicionales</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Monto total a pagar</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cantidad de cuotas</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Monto Cuota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha pago</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Tipo de pago</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Boleta emitida y enviada</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cuota 1</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cuota 2</th>
                                                                <th class="px-0 text-xs f-weight color-grey">FechaCuota 3</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cuota 4</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Cuenta por cobrar</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Conductor encargado de recojo</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Conductor encargado de entrega planta</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Raza mascota</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha inicio compost</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha cosecha</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Fecha entrega</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Peso compost final (tamizado)</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Envío de encuesta</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Macetas extra</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Maceta con retrato</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Dije</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Llavero</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Acuarela</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Tipo de servicio</th>
                                                                <th class="px-0 text-xs f-weight color-grey">Comentariosth </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            @foreach ( $objUsers as $key => $objUser)
                                                            <tr>
                                                                
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->id_pedido}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->fecha_creacion}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->fecha_creacion}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->fecha_creacion}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->email}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->nombres}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->apellidos}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->celular}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->celular}}</td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->edad}}</td>
                                                                <td class="f-weight-50 black-main text-xs">
                                                                    {{$objUser -> opcion}}
                                                                    @php
                                                                        $objUser -> opcion == 'Otro' ?  print(' - '.$objUser -> otro) : '' ;
                                                                    @endphp
                                                                </td>
                                                                <td class="f-weight-50 black-main text-xs">{{$objUser->fecha_creacion}}</td>
                                                                
                                                                <td>
                                                                    <a class="btn-sm btn-square"><i
                                                                            class="ri-pencil-line"
                                                                            style="font-size: 20px;"></i></a>
                                                                    <a type="button"
                                                                        class="btn-sm btn-square f-weight-50 text-sm ms-3 px-5">Guardar</a>
                                                                </td>
                                                            </tr>
                                                            
                                                            
                                                            @endforeach
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- mascota -->
                            <div class="tab-pane fade" id="pills-mascota" role="tabpanel"
                                aria-labelledby="pills-mascota-tab" tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <div class="table-responsive">
                                                        <table class="table table-flush" id="datatable-search2">
                                                            <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="px-0 text-xs f-weight color-grey">N°</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Nombre</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Edad</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Peso</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">F. Fallecimiento</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Tipo</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Sexo</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Etapa</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Compost</th>
                                                                    <th class="px-0 text-xs f-weight color-grey">Opciones</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ( $objMascotas as $key => $objMascota)
                                                            
                                                                <tr>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objMascota->id_pedido}}</td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> nombre_mascota}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> edad_mascota}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> peso_mascota}} Kg.</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> fecha_creacion}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> tipo_mascota}}</span>
                                                                    </td>
                                                                    <td class="f-weight-50 black-main">
                                                                        <span class="my-2 text-xs">{{$objMascota -> sexo_mascota}}</span>
                                                                    </td>
                                                                    <td>
                                                                        {{-- <div
                                                                            class="text-white rounded-pill bg-success2 d-flex justify-content-center status-chip">
                                                                            <div class="f-weight-40 py-1 px-3 text-xs">
                                                                                Recojo
                                                                                <img src="../../assets/img/recojo_status.svg"
                                                                                    alt="" class="ms-1">
                                                                            </div>
                                                                        </div> --}}
                                                                        <div class="t-verde-o semibold rounded-pill  d-flex justify-content-center {{$objMascota->estado_pedido === 5 ? 'bg-blue-o' : 'bg-success-s'}}">
                                                                            @if($objMascota->estado_pedido === 1)
                                                                            <div class="p-1 fs-7 d-flex justify-content-center align-items-center">
                                                                                <span class="text-xs">Recojo de Mascota</span>
                                                                                <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}" alt="" class="ms-1">
                                                                            </div>
                                                                            @elseif($objMascota->estado_pedido === 2)
                                                                            <div class="p-1 fs-7 d-flex justify-content-center align-items-center">
                                                                                <span class="text-xs">Compostaje</span>
                                                                                <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}" alt="" class="ms-1">
                                                                            </div>
                                                                            @elseif($objMascota->estado_pedido === 3)
                                                                            <div class="p-1 fs-7 d-flex justify-content-center align-items-center">
                                                                                <span class="text-xs">Logística</span>
                                                                                <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}" alt="" class="ms-1">
                                                                            </div>
                                                                            @elseif($objMascota->estado_pedido === 4)
                                                                            <div class="p-1 fs-7 d-flex justify-content-center align-items-center">
                                                                                <span class="text-xs">Entrega de Maceta</span>
                                                                                <img src="{{ asset('assets/img/icon-chips-proceso.svg') }}" alt="" class="ms-1">
                                                                            </div>
                                                                            @elseif($objMascota->estado_pedido === 5)
                                                                            <div class="p-1 fs-7 d-flex justify-content-center align-items-center text-white">
                                                                                <span class="text-xs">Finalizado</span>
                                                                                <img src="{{ asset('assets/img/icon_check-white.svg') }}" alt="" class="ms-1">
                                                                            </div>
                                                                            @endif     
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <div>
                                                                            @if ($objMascota->id_tipo == 1)
                                                                                <p class="normal text-center text-xs mb-0">Bolsa con el compost de mi mascota.(entre 0,5 y 1 kg)</p>
                                                                            @elseif ($objMascota->id_tipo == 2)
                                                                                <p class="normal text-center text-xs mb-0">Todo el compost de mi mascota. (aprox. el 30% de su peso)</p>
                                                                            @elseif ($objMascota->id_tipo == 3)
                                                                                <p class="normal text-center text-xs mb-0">Donado a proyectos de forestación.</p>
                                                                            @endif
                                                                        </div>
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                            class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                                
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>  
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- dirección -->
                            <div class="tab-pane fade" id="pills-direccion" role="tabpanel"
                                aria-labelledby="pills-direccion-tab" tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <div class="table-responsive">
                                                        <table class="table table-flush" id="datatable-search3">
                                                            <thead class="bg-grey-10" style="width: 100%">
                                                                <tr>
                                                                    <th class="f-weight px-0 color-grey text-xs">N° Pedido</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Usuario</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Mascota</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Día</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Hora</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Distrito</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Dirección de recojo</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Opciones</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <!-- 1 -->
                                                                @foreach ( $objDireccionRecojosIda as $key => $objDireccionRecojoIda)
                                                                <tr>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->id_pedido}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->nombres}} {{$objDireccionRecojoIda->apellidos}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->nombre_mascota}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->fecha_recojo}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->horario}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->distrito}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoIda->direccion_recojo}}</td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                            class="btn-sm btn-square f-weight-50 text-xs ms-3 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-direccione" role="tabpanel"
                                aria-labelledby="pills-direccion-tab" tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <div class="table-responsive">
                                                        <table class="table table-flush" id="datatable-search3">
                                                            <thead class="bg-grey-10" style="width: 100%">
                                                                <tr>
                                                                    <th class="f-weight px-0 color-grey text-xs">N° Pedido</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Usuario</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Mascota</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Día</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Hora</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Distrito</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Dirección de entrega</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Opciones</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ( $objDireccionRecojosVuelta as $key => $objDireccionRecojoVuelta)
                                                                <tr>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->id_pedido}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->nombres}} {{$objDireccionRecojoVuelta->apellidos}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->nombre_mascota}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->fecha_recojo}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->horario}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->distrito}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objDireccionRecojoVuelta->direccion_recojo}}</td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                            class="btn-sm btn-square f-weight-50 text-xs ms-3 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- extras -->
                            <div class="tab-pane fade" id="pills-extras" role="tabpanel"
                                aria-labelledby="pills-extras-tab" tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <div class="table-responsive">
                                                        <table class="table table-flush" id="datatable-search4">
                                                            <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="f-weight px-0 color-grey text-xs">N° Pedido</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Usuario</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Mascota</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Maceta</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Cuadro</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Maceta retrato</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Dije</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Llavero</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Maceta de papel</th>
                                                                    {{-- <th class="f-weight px-0 color-grey text-xs">Tipo de Planta</th> --}}
                                                                    <th class="f-weight px-0 color-grey text-xs">Opciones</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ( $objPedidoExtras as $key => $objPedidoExtra)
                                                                <tr>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPedidoExtra->pedido_id}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPedidoExtra->nombres}} {{$objPedidoExtra->apellidos}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPedidoExtra->nombre_mascota}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '1' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '2' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '3' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '4' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '5' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $objPedidoExtra -> producto_id == '6' ?  print('1') : print('0') ;
                                                                        @endphp
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                        <a type="button"
                                                                            class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- pago -->
                            <div class="tab-pane fade" id="pills-pago" role="tabpanel" aria-labelledby="pills-pago-tab"
                                tabindex="0">
                                <div class="row">
                                    <div>
                                        <div class="row">
                                            <div class="col-12">
                                                <div>
                                                    <div class="table-responsive">
                                                        <table class="table table-flush" id="datatable-search5">
                                                            <thead class="bg-grey-10">
                                                                <tr>
                                                                    <th class="f-weight px-0 color-grey text-xs">N° Pedido</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Usuario</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Mascota</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Costo del servicio</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Tipo de producto</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Costo por envió</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Productos extras</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Costo extras</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Forma de pago</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Fee adicional</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Fecha de pago</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Total a pagar</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Estado del pago</th>
                                                                    <th class="f-weight px-0 color-grey text-xs">Opciones</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                @foreach ( $objPagos as $key => $objPago)
                                                                {{-- +"id_pago": 1
                                                                +"id_pedido": null
                                                                +"monto_servicio": 510.0
                                                                +"tipo_pago": null
                                                                +"forma_pago": "total"
                                                                +"fecha_1_pago": "2025-01-11"
                                                                +"fecha_2_pago": null
                                                                +"pago_cuota_1": 1427
                                                                +"pago_cuota_2": null
                                                                +"fee_adicional": null
                                                                +"total_pagar": 1427.8
                                                                +"igv": 217
                                                                +"costo_envio": 10
                                                                +"pago_extra": 100
                                                                +"pago_peso": 590
                                                                +"prod_extras": null --}}
                                                                <tr>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->id_pedido}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->nombres}} {{$objPago->apellidos}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->nombre_mascota}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->pago_peso}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->tipo_pago}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->costo_envio}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                            $extras = json_decode($objPago->prod_extras, true) ?? [];
                                                                            $nombres = [
                                                                                '1' => 'Maceta',
                                                                                '2' => 'Cuadro',
                                                                                '3' => 'Maceta retrato',
                                                                                '4' => 'Dije',
                                                                                '5' => 'Llavero',
                                                                                '6' => 'Maceta de papel',
                                                                            ];
                                                                        @endphp

                                                                        @foreach($extras as $key => $value)
                                                                            <p class="mb-0 f-weight-50 black-main text-xs">{{ $nombres[$key] ?? '' }}</p>
                                                                        @endforeach


                                                                    </td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->pago_extra}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->forma_pago}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->fee_adicional}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->fecha_1_pago}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">{{$objPago->total_pagar}}</td>
                                                                    <td class="f-weight-50 black-main text-xs">
                                                                        @php
                                                                        $forma_pago = $objPago->forma_pago;
                                                                        if($forma_pago == 'total'){
                                                                            print('Pagado');
                                                                        }else{
                                                                            $pago_cuota_1 = $objPago->pago_cuota_1;
                                                                            $pago_cuota_2 = $objPago->pago_cuota_2;
                                                                            if($pago_cuota_1){
                                                                                print('Cuota 1: Pagado </br>');
                                                                            }
                                                                            if($pago_cuota_2){
                                                                                print('Cuota 2: Pagado');
                                                                            }else{
                                                                                print('Cuota 2: Pendiente');
                                                                            }
                                                                        }
                                                                            
                                                                        @endphp
                                                                    </td>
                                                                    <td>
                                                                        <a class="btn-sm btn-square"><i
                                                                                class="ri-pencil-line"
                                                                                style="font-size: 20px;"></i></a>
                                                                            
                                                                        <a type="button"
                                                                            class="btn-sm btn-square f-weight-50 text-sm ms-2 px-5">Guardar</a>
                                                                    </td>
                                                                </tr>
                                                                @endforeach
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


@endsection