<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePagosTable extends Migration
{
    public function up()
    {
        Schema::create('pagos', function (Blueprint $table) {
            //id_pago
            //id_pedido_pago
            //monto_servicio
            //tipo_pago
            //fee_adicional
            //total_pagar
            //igv
            //cantidad_cuotas
            //costo_envio
            //costo_envio_dia
            //costo_envio_hora
            //costo_envio_distrito
            //pago_extra
            //pago_peso
            //prod_extras
            //pago_boleta
            //metodo_pago
            //forma_pago

            $table->id();

            $table->unsignedBigInteger('user_id');
            $table->unsignedBigInteger('id_pedido_pago')->nullable(); // Si se asocia a pedido

            $table->enum('tipo_pago', ['servicio', 'extra'])->default('servicio'); // único = pago de una vez, recurrente = cuotas
            $table->unsignedTinyInteger('cantidad_cuotas')->default(1); // 1 = único

            // Monto base y detalles económicos
            $table->decimal('monto_servicio', 10, 2)->default(0);
            $table->decimal('fee_adicional', 10, 2)->default(0);
            $table->decimal('igv', 10, 2)->default(0);
            $table->decimal('total_pagar', 10, 2)->default(0);

            // Costos de envío
            $table->decimal('costo_envio', 10, 2)->default(0);
            $table->decimal('costo_envio_dia', 10, 2)->default(0);
            $table->decimal('costo_envio_hora', 10, 2)->default(0);
            $table->decimal('costo_envio_distrito', 10, 2)->default(0);

            // Otros extras
            $table->decimal('pago_extra', 10, 2)->default(0);
            $table->decimal('pago_peso', 10, 2)->default(0);
            $table->text('prod_extras')->nullable();

            // Detalles de metodo y estado
            $table->string('metodo_pago', 50)->nullable(); // Mercado Pago, Yape, etc.
            $table->string('forma_pago', 50)->nullable();  // crédito, débito, etc.
            $table->enum('estado', ['pendiente', 'pagado', 'anulado'])->default('pendiente');

            $table->timestamps();

//            $table->foreign('user_id')->references('id')->on('usuario')->onDelete('cascade');
//            $table->foreign('pedido_id')->references('id')->on('pedidos')->nullOnDelete();
        });

    }

    public function down()
    {
        Schema::dropIfExists('pagos');
    }
}
