<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('suscripcion_pagos', function (Blueprint $table) {
            $table->id();
            $table->string('preapproval_id');
            $table->string('payment_id');
            $table->string('payer_email')->nullable();
            $table->decimal('amount', 10, 2)->nullable();
            $table->string('currency')->default('PEN');
            $table->string('status')->nullable();
            $table->timestamp('paid_at')->nullable();

            // Datos adicionales
            $table->unsignedBigInteger('pedido_id')->nullable();
            $table->unsignedBigInteger('user_id')->nullable();

            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('suscripcion_pagos');
    }
};
