<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SeguimientoEtapa8 extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario'],
            'nombre_mascota' => $argsMail['nombre_mascota'],
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Gracias por confiar en nosotros')
            ->view('emails.usuario.seguimiento_etapa_8')
            ->with([
                'data' => $this->data
            ]);
    }
}
