<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistroVisita extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'fecha_visita' => $argsMail['fecha_visita'],
            'horario' => $argsMail['horario'],
            'nombre_usuario' => $argsMail['nombre_persona']
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
                ->subject('Se ha programado tu visita al Compostario')
                ->view('emails.registrar_visita')
                ->with([
                    'data' => $this->data
                ]);
    }
}
