<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistroUsuarioNuevo extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {

        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario'],
            'nombre_mascota' => $argsMail['nombre_mascota'],
            'celular' => $argsMail['celular'],
            'raza_mascota' => $argsMail['raza_mascota'],
            'fecha_recojo' => $argsMail['fecha_recojo'],
            'id_horario' => $argsMail['id_horario'],
            'direccion_recojo' => $argsMail['direccion_recojo'],
            'forma_pago' => $argsMail['forma_pago'],
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
                ->subject('Se ha registrado un nuevo usuario')
                ->view('emails.nuevo_usuario_vuelve')
                ->with([
                    'data' => $this->data
                ]);
    }
}
