<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RegistroConstanciaPago extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail, $imagePaths)
    {

        $this->args = $argsMail;
        $this->imagePaths = $imagePaths;
    }

    /**¡
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
//        return $this
//            ->subject('Se ha enviado la constancia de un nuevo pedido'. $argsMail['id_pedido'])
//            ->view('emails.constancia_envio')
//            ->with([
//                'data' => $this->data
//            ]);

        $email = $this
            ->subject('Se ha enviado la constancia del pedido ' . $this->args['id_pedido'])
            ->view('emails.constancia_envio')
            ->with('args', $this->args);

        // Adjuntar imágenes desde almacenamiento
        foreach ($this->imagePaths as $path) {
            $email->attachFromStorage('public/' . $path);
        }

        return $email;
    }


}
