<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RecojoIdaPaso4 extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario'],
            'nombre_mascota' => $argsMail['nombre_mascota']
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Tu mascota acaba de llegar a nuestro compostario')
            ->view('emails.recojo_ida_paso_4')
            ->with([
                'data' => $this->data
            ]);
    }
}
