<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class EntregaConductorPaso2 extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($argsMail)
    {
        $this->data = [
            'nombre_usuario' => $argsMail['nombre_usuario'],
            'nombre_mascota' => $argsMail['nombre_mascota'],
            'tiempo_llegada' => $argsMail['tiempo_llegada'],
        ];
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this
            ->subject('Nuestro conductor está camino a entregar una mascota')
            ->view('emails.entrega_conductor_paso_2')
            ->with([
                'data' => $this->data
            ]);
    }
}
