<?php

namespace App\Jobs;

use App\Mail\RegistroUsuarioPlanSiempreJuntos;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;

class RevisarSuscripcionesMercadoPago implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        $pagos = DB::table('pagos')
            ->where('estado', 'pendiente')
            ->where('forma_pago', 'cuotas')
            ->where('metodo_pago', 'mercado_pago')
            ->whereNotNull('id_cuota_pago')
            ->get();


        Log::info('🔄 RevisarSuscripcionesMercadoPago', [
            'pagos' => $pagos,
        ]);

//        return false;


//        Log::info('🔎 CONSULTA TOKEN', [
//            'token_prefix' => substr(config('services.mercadopago.access_token'), 0, 10),
//        ]);
        foreach ($pagos as $pago) {

            $response = Http::withToken(config('services.mercadopago.access_token'))
                ->get("https://api.mercadopago.com/preapproval/{$pago->id_cuota_pago}");

            $data = $response->json();

//            Log::info("response: $data  ");

            $charged = $data['summarized']['charged_quantity'] ?? 0;
            $quotas = $data['summarized']['quotas'] ?? 0;

            Log::info("Pago ID: {$pago->id_cuota_pago} - cuotas pagadas: {$charged}/{$quotas}");

            $cuotasRegistradas = DB::table('pagos_cuotas')
                ->where('id_pago', $pago->id_cuota_pago)
                ->count();


            Log::info("$cuotasRegistradas: $cuotasRegistradas  ");


            // 2) si en MP hay más cobradas que en DB, insertar las que faltan
            if ($charged > $cuotasRegistradas) {

                $faltantes = $charged - $cuotasRegistradas;

                for ($i = 1; $i <= $faltantes; $i++) {
                    DB::table('pagos_cuotas')->insert([
                        'id_pago' => $pago->id_cuota_pago,
                        'numero_cuota' => $cuotasRegistradas + $i,
                        'monto' => $pago->monto_servicio / $pago->cantidad_cuotas,
                        'estado' => 'pagado',
                        'fecha_programada' => now(),
                        'fecha_pagada' => now(),
                        'created_at' => now(),
                        'updated_at' => now()
                    ]);
                }
            }

            if ($charged >= $quotas && $quotas > 0) {

                $pedido = DB::table('pedidos')->where('id_pedido', $pago->id_pedido_pago)->first();
                $usuario = DB::table('usuarios')->where('id', $pedido->id_usuario)->first();
                $argsMascota = DB::table('mascotas')->where('id_mascota', $pedido->id_mascota)->first();
//                $argRecojo = DB::table('recojos')->where('id_recojo_ida', $pedido->id_recojo_ida)->first();

                DB::table('pedidos')
                    ->where('id_pedido', $pago->id_pedido_pago)
                    ->update([
                        'estado_pedido' => 1,
                        'pedido_activo' => 1
                    ]);

                DB::table('usuarios')
                    ->where('id', $pedido->id_usuario)
                    ->update([
                        'estado' => 1,
                    ]);

                // Actualizar pagos a COMPLETADO
                DB::table('pagos')
                    ->where('id_cuota_pago', $pago->id_cuota_pago)
                    ->update([
                        'estado' => 'pagado'
                    ]);

                Log::info("Pago completo: {$pago->id_cuota_pago} - cuotas pagadas: {$charged}/{$quotas}");

                $argsMail = [
                    'nombre_usuario' => $usuario->nombres . ' ' . $usuario->apellidos,
                    'nombre_mascota' => $argsMascota->nombre_mascota,
                    'token_reset' => $usuario->token_reset
                ];

                Mail::to($usuario->email)->send(new RegistroUsuarioPlanSiempreJuntos($argsMail));
            }
        }
    }
}
