<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ProcesarPagoMercadoPago implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $paymentId;

    public function __construct($paymentId)
    {
        $this->paymentId = $paymentId;
    }

    public function handle()
    {
        // 1️⃣ Consultar pago en Mercado Pago
        $payment = Http::withToken(config('services.mercadopago.token'))
            ->get("https://api.mercadopago.com/v1/payments/{$this->paymentId}")
            ->json();

        if (($payment['status'] ?? null) !== 'approved') {
            return;
        }

        // 2️⃣ Decodificar external_reference
        $external = json_decode($payment['external_reference'] ?? '', true);

        if (!isset($external['cuota_id'], $external['pago_id'])) {
            Log::warning('External reference inválido', $external ?? []);
            return;
        }

        DB::transaction(function () use ($payment, $external) {

            // 3️⃣ Marcar cuota pagada
            $updated = DB::table('pago_cuotas')
                ->where('id', $external['cuota_id'])
                ->where('estado', 'pendiente')
                ->update([
                    'estado' => 'pagado',
                    'mp_payment_id' => $payment['id'],
                    'fecha_pago' => now(),
                    'updated_at' => now(),
                ]);

            if (!$updated) {
                return;
            }

            // 4️⃣ Verificar si quedan cuotas pendientes
            $pendientes = DB::table('pago_cuotas')
                ->where('pago_id', $external['pago_id'])
                ->where('estado', 'pendiente')
                ->count();

            DB::table('pagos')
                ->where('id', $external['pago_id'])
                ->update([
                    'estado' => $pendientes === 0 ? 'completado' : 'en_proceso',
                    'updated_at' => now(),
                ]);
        });
    }
}
