<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Foundation\Bus\Dispatchable;


class EnviarCorreoProgramado implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $email, $tipo, $data, $pedido_id;

    public function __construct($email, $tipo, $data, $pedido_id)
    {
        $this->email = $email;
        $this->pedido_id = $pedido_id;
        $this->tipo = $tipo;
        $this->data = $data;
    }

    public function handle()
    {
        $mailable = null;

        \Log::info("Procesando correo para {$this->email}, tipo: {$this->tipo}");

        switch ($this->tipo) {
            case 'seguimiento_1':
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 1
                ]);
                break;
            case 'seguimiento_2':
                $mailable = new \App\Mail\SeguimientoEtapa2($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 2
                ]);
                break;
            case 'seguimiento_3':
                $mailable = new \App\Mail\SeguimientoEtapa3($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 3
                ]);
                break;
            case 'seguimiento_4':
                $mailable = new \App\Mail\SeguimientoEtapa4($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 4
                ]);
                break;
            case 'seguimiento_5':
                $mailable = new \App\Mail\SeguimientoEtapa5($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 5
                ]);
                break;
            case 'seguimiento_6':
                $mailable = new \App\Mail\SeguimientoEtapa6($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 6
                ]);
                break;
            case 'seguimiento_7':
                $mailable = new \App\Mail\SeguimientoEtapa7($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 7
                ]);
                break;
            case 'seguimiento_8':
                $mailable = new \App\Mail\SeguimientoEtapa8($this->data);
                DB::table('pedidos')->where('id_recojo_ida', $this->pedido_id)->update([
                    'seguimiento' => 8
                ]);
                break;
        }

        if ($mailable) {
            Mail::to($this->email)->send($mailable);
        }
    }
}
