<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class BloquearPagosDespuesPedido
{
    public function handle(Request $request, Closure $next)
    {
        // Si el usuario ya completó un pedido, no debe acceder a cuotas ni pagos
        if (session()->has('pedido_completado')) {
            return redirect('/registro-vuelve-a-casa'); // Redirige al inicio del registro
        }

        return $next($request);
    }
}
