<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Session;

use Illuminate\Support\Facades\Mail;
use App\Mail\RegistroUsuario;
use App\Mail\RegistroUsuarioPlanSiempreJuntos;
use App\Mail\RegistroConstanciaPago;
use App\Mail\RegistroUsuarioNuevo;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Redirect;

// use App\Mail\RegistroUsuario;
// use App\Mail\RegistroUsuarioNuevo;
use Carbon\Carbon;

// SDK de Mercado Pago
use MercadoPago;

use Illuminate\Support\Facades\Log;

class WebController extends Controller
{
    public function registrar_encuesta(Request $request)
    {

        $pedidoId = $request->query('id'); // Recupera el ID del pedido

        DB::table('pedidos')
            ->where('id_pedido', $pedidoId)
            ->update([
                'encuesta_completada' => date('Y-m-d H:i:s'),
            ]);

        // Redirigir al formulario de Google Forms
        return Redirect::away('https://forms.gle/VvwbBH9PzvgUokZp6');
    }


    public function cerrar_sesion(Request $request)
    {
        $request->session()->flush();
        // return redirect()->route('landing');
        return redirect()->route('iniciar_sesion');
    }

    public function landing()
    {
        return view('front.index');
    }

    public function encuestas(Request $request)
    {

        $data = $request->session()->all();
//        @dd($data);

        $emailSession = Session::get('user_email');
//        @dd($emailSession);

        $email = $emailSession;

//        @dd($email);

        if ($_POST) {
            $data = $request->all();


//            dd($data);

            $finduser = DB::table('usuarios')->where('email', $email)->first();

//            dd($email);

            $argsEncuesta = [
                'id_usuario' => $finduser->id,
                'opcion' => $data['opcion'],
                'otro' => $data['otro'],
                'fecha_creacion' => date('Y-m-d H:i:s')
            ];

            DB::table('encuestas')->insert($argsEncuesta);


            return redirect()->route('encuestas')->with('exito', 'Muchas gracias por responder nuestra encuesta');
            // return dd($data);
        }
        // $user_id = Session::get('user_id');
        return view('front.registro.encuesta');
    }


//    public function registro_vuelve_acasa(Request $request)
//    {
//        // $request->session()->flush();
//        $user_id = Session::get('user_id');
//        // $data = $request->session()->get('argsUsuario');
//
//        // $data = $request->session()->all();
//        // @dd($user_id);
//
//        if ($_POST) {
//
//            $data = $request->all();
//
//            return dd($data);
//            $finduser = DB::table('usuarios')->where('email', $data['email'])->first();
//            if ($finduser) {
//                return redirect()->back()->with('error', 'El correo electrónico ya se encuentra registrado');
//            }
//        }
//
//        $hora_actual = Carbon::now()->addHour()->format('H:i'); // Formato 24h (Ejemplo: "11:00")
//        $hora_limite = "23:00"; // 10:00 PM en formato 24h
//
//        $horarios = DB::table('horarios')->select('horario', 'id_horario', 'costo')->get()->filter(function ($horario) use ($hora_actual, $hora_limite) {
//            $hora_inicio = Carbon::parse(trim(explode('-', $horario->horario)[0]));
//            return $hora_inicio->between($hora_actual, $hora_limite);
//        });
//
//        // @dd($horarios);
//
//        $horario_first = $horarios->first();
//
//
//        // if($user_id){
//
//
//        //   $pedido = DB::table('pedidos')->where('id_usuario', $user_id)->first();
//        //   $recojo = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->join('distritos','recojos.id_distrito','=','distritos.id_distrito')->first();
//        // }else{
//        //   $pedido = '';
//        // }
//        $recojo = '';
//
//        // dd($hora_actual);
//
//        return view('front.registro_vuelve_casa', compact('user_id', 'horarios', 'recojo', 'horario_first'));
//    }
//
//    public function registro_siempre_juntos(Request $request)
//    {
//
//        $user_id = Session::get('user_id');
//        // $data = $request->session()->get('argsUsuario');
//
//        // $data = $request->session()->all();
//        // dd($user_id);
//
//        if ($_POST) {
//
//            $data = $request->all();
//
//            // return dd($data);
//            $finduser = DB::table('usuarios')->where('email', $data['email'])->first();
//            if ($finduser) {
//                return redirect()->back()->with('error', 'El correo electrónico ya se encuentra registrado');
//            }
//        }
//
//        $recojo = '';
//
//        return view('front.registro_siempre_juntos', compact('user_id', 'recojo'));
//    }


    public function cuotas(Request $request)
    {

        $precioExtras = 0;
        $precioRecojo = 0;
        $precioPeso = 0;
        $precioServicio = 0;

        $precioDiaRecojo = 0;
        $precioHoraRecojo = 0;
        $precioDistritoRecojo = 0;


        if (isset($_GET['extra'])) {

            $productos_id = [];

            $productos = DB::table('productos')->where('estado', 1)->get();

            // @dd($productos_id);

            if ($productos) {
                foreach ($productos as $producto) {
                    $productos_id[$producto->id_producto] = $producto->precio;
                }
            }

            $data = $request->all();
            // return dd($data);
            $precioExtras = 0;
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $id => $cantidad) {
                    $precio = $productos_id[$id] * $cantidad;
                    $precioExtras += $precio;
                }
            }
        }

        $registro = $request->session()->get('registro');

        // @dd($registro);

        if ($registro['servicio-vuelve'] == 1) {
            $carbonDate = Carbon::parse($registro['fecha_recojo']);

            // Verificar si es domingo (domingo es 0 en Carbon)
            $esDomingo = $carbonDate->isSunday();
            $esSabado = $carbonDate->isSaturday();

            if ($esSabado || $esDomingo) {
                $precioDiaRecojo += 60;
            } else {
                $precioDiaRecojo += 0;
            }

        }

        if ($registro['servicio-vuelve'] == 2) {
            $precioHoraRecojo += 0;
        }

        if ($registro == null) return redirect()->route('registro');

        // @dd($registro);

        if ($registro['servicio-vuelve'] == 1) {
            $horario = DB::table('horarios')->where('id_horario', $registro['hora_recojo'])->first();
            if ($horario) {
                $precioHoraRecojo += $horario->costo;
            }
        }

        // if($registro['servicio-vuelve'] == 2){
        //   $precioRecojo += 0;
        // }


        $distrito = DB::table('distritos')->where('id_distrito', $registro['distrito_recojo'])->first();
        if ($distrito) {
            $precioDistritoRecojo += $distrito->costo;
        }

        if ($registro['peso_mascota'] < 11) {
            $precioPeso += 590;
        } elseif ($registro['peso_mascota'] > 11 && $registro['peso_mascota'] < 25) {
            $precioPeso += 690;
        } elseif ($registro['peso_mascota'] > 26 && $registro['peso_mascota'] < 100) {
            $precioPeso += 790;
        }

        // $peso = DB::table('pesos')->where('id_peso', $registro['peso_mascota'])->first();
        // if ($peso) {
        //   $precioPeso += $peso->costo;
        // }

        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

        if ($servicio) {
            $precioServicio += $servicio->costo;
        }

        // $precioDiaRecojo = 0;
        // $precioHoraRecojo = 0;
        // $precioDistritoRecojo = 0;
        $precioRecojo += $precioDiaRecojo + $precioHoraRecojo + $precioDistritoRecojo;

        $precioTotal = $precioExtras + $precioPeso + $precioDiaRecojo + $precioHoraRecojo + $precioDistritoRecojo + $precioServicio;

        $precioIgv = round($precioTotal * 0.18, 2);


        return view('front.cuotas', compact('precioExtras', 'precioPeso', 'precioDiaRecojo', 'precioHoraRecojo', 'precioDistritoRecojo', 'precioRecojo', 'precioServicio', 'precioTotal', 'precioIgv'));
    }

    public function pedidos_productos(Request $request)
    {

        $precioExtras = 0;
        $precioRecojo = 0;
        $precioPeso = 0;
        $precioServicio = 0;
        $preference_id = 0;

        $data = $request->all();

        // @dd($data);

        $pageId = $data['id'];

        if (isset($_GET['extra'])) {

            // @dd($_GET['extra']);
            // $data = json_encode($_GET);
            $productos_id = [];
            $productos = DB::table('productos')->where('estado', 1)->get();
            if ($productos) {
                foreach ($productos as $producto) {
                    $productos_id[$producto->id_producto] = $producto->precio;
                }
            }

            // return dd($data);
            $precioExtras = 0;
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $id => $cantidad) {
                    $precio = $productos_id[$id] * $cantidad;
                    $precioExtras += $precio;
                }
            }
            // $data = $request->all();


        }


        $precioTotal = $precioExtras;

        $precioIgv = round($precioTotal * 0.18, 2);


        $data['precio-extra'] = $precioExtras;
        $data['precio-igv'] = $precioIgv;
        $data['precio-total'] = $precioTotal;


        $data = json_encode($data);

        // @dd($data);

        return view('front.servicio.pago_extras', compact('pageId', 'precioExtras', 'precioServicio', 'precioRecojo', 'precioTotal', 'precioIgv', 'precioPeso', 'data', 'preference_id'));
    }

    public function pago_cuota(Request $request)
    {

        $precioExtras = 0;
        $precioRecojo = 0;
        $precioPeso = 0;
        $precioServicio = 0;
        $precioIgv = 0;

        $data = $request->all();

        $preference_id = 0;

        $pageId = $data['id'];

        $precioTotal = $data['pago-cuota'];

        $data['precio-total'] = $precioTotal;


        $data = json_encode($data);

        // @dd($data);

        return view('front.servicio.pago_cuotas', compact('pageId', 'precioTotal', 'data', 'preference_id'));
    }


    public function pago(Request $request)
    {
        // $data = $request->session()->all();
        // $dataJson = $request->query('data'); // Esto es un string JSON

        // return dd($dataJson);

        // $data = json_decode($_GET, true);
        // $data = json_decode($_GET, true);
        // $data = json_encode($_GET, true);

        $data = $request->all();

        // return dd($data);

        // $data = json_decode($dataJson, true)

        // return dd($data);

        // Agrega credenciales
        MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

        // $preference = new MercadoPago\Preference();

        // $item = new MercadoPago\Item();
        // $item->title = 'Suscripción a mi sitio web';
        // $item->quantity = 1;
        // $item->price = $_GET['precio-total'];
        // $item->unit_price = $_GET['precio-total'];
        // $item->currency_id = 'PEN';
        // $preference->items = array($item);
        // $preference->save();

        // $preference_id = $preference->id;


        $formaDePago = $_GET['forma-pago'];

        // return dd($formaDePago);


        if ($formaDePago === "total") {
            $data['numero-cuotas'] = 0;
        }


        $data = json_encode($data, true);

        // return dd($data);

        $preference_id = 0;
        $precioCuota = $_GET['precio-cuota'];

        if ($precioCuota == 0) {
            $precioTotal = $_GET['precio-total'];
        } else {
            $precioTotal = $_GET['precio-cuota'];
        }

        $user_id = Session::get('user_id');

        return view('front.pago', compact('precioTotal', 'preference_id', 'data', 'user_id'));
    }

    public function process_payment_subscription(Request $request)
    {
        // Inicializa Mercado Pago

        $registro = $request->session()->get('registro');
        $data = $request->all();
//        print_r($data);die;
//        @dd($registro);
//        die;
        $data = json_decode($data['data'], true); // true para obtener array asociativo
//        @dd($data);die;
//        $argsUsuario = [
//            'nombres' => $registro['nombres'],
//            'apellidos' => $registro['apellidos'],
//            'edad' => $registro['edad'],
//            'celular' => $registro['celular'],
//            'email' => $registro['email'],
//            'token_reset' => $token_reset,
//            // 'contrasena' => sha1($registro['contrasena']),
//            'estado' => 1,
//            'fecha_creacion' => date('Y-m-d H:i:s')
//        ];

//        $argsPagos = [
//            'monto_servicio' => $data['precio-servicio'],
//            'id_pedido_pago' => $pedido_id,
//            'forma_pago' => $data['forma-pago'],
//            'tipo_pago' => 'servicio',
//            'cantidad_cuotas' => $data['numero-cuotas'],
//            'fecha_1_pago' => date('Y-m-d H:i:s'),
//            'pago_cuota_1' => $data['precio-cuota'],
//            'total_pagar' => $data['precio-total'],
//            'igv' => $data['precio-igv'],
//            'costo_envio' => $data['precio-recojo'],
//            'pago_extra' => $data['precio-extra'],
//            'pago_peso' => $data['precio-peso'],
//            'fee_adicional' => $data['fee-adicional'],
//            'costo_envio_dia' => $data['precio-diarecojo'],
//            'costo_envio_hora' => $data['precio-horarecojo'],
//            'costo_envio_distrito' => $data['precio-distritorecojo'],
//            'metodo_pago' => 'transferencia',
//            //'prod_extras' => json_encode($filteredExtras) ?? null
//        ];

        MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));
        $preapproval = new MercadoPago\Preapproval();

        $emailCliente = $registro['email']; // Debes capturarlo en el frontend
//        $montoCuota = $data['precio-cuota'];
        $montoCuota = 2.00;


        $preapproval->back_url = route('encuestas'); // Ruta a la que vuelven luego del pago
        $preapproval->reason = '(Total: ' . $data['precio-total'] . ' Soles) Paga en 2 cuotas de : ';
//        $preapproval->reason = 'Producto X - 2 cuotas de S/ 100 (total S/ 200)';
        $preapproval->payer_email = $emailCliente;
        $preapproval->external_reference = 'cuota_doble_' . uniqid();

        $preapproval->auto_recurring = [
            "frequency" => 1,
            "frequency_type" => "months",
            "transaction_amount" => $montoCuota,
            "currency_id" => "PEN",
            "start_date" => now()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
//            "end_date" => now()->addMonth()->addDays(2)->endOfDay()->format('Y-m-d\TH:i:s.000P'),
            "end_date" => now()->addDays(2)->endOfDay()->format('Y-m-d\TH:i:s.000P'), // ⏱ margen hasta 2 días después
            "repetitions" => 2 // ✅ Solo 2 pagos: hoy y en 1 mes
        ];

        try {
            $preapproval->save();

            if ($preapproval->init_point) {
                // Redirige al cliente para autorizar los cobros
                return redirect($preapproval->init_point);
            } else {
                Log::error('❌ Error al generar preapproval', (array)$preapproval);
                return back()->with('error', 'No se pudo generar el enlace de pago en cuotas.');
            }
        } catch (\Exception $e) {
            Log::error('❌ Excepción al crear preapproval', ['mensaje' => $e->getMessage()]);
            return back()->with('error', 'Error al iniciar el pago.');
        }
    }

    public function process_payment_deposito(Request $request)
    {
        // $user_id = $request->session()->get('user_id');

        // return dd($user_id);
        $registro = $request->session()->get('registro');
        $data = $request->all();
        // print_r($data);die;
        // @dd($registro);

        $data = json_decode($data['data'], true); // true para obtener array asociativo


        // $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        // return dd($user_id);

        if ($data['_token']) {

            // print_r($payment);die;

            // ----------------- Pago aprobado
            // Registro usuario
            // $user_id = Session::get('user_id');

            $token_reset = time();

            // @dd($user_id, $registro);
            // if (!$user_id) {
            $argsUsuario = [
                'nombres' => $registro['nombres'],
                'apellidos' => $registro['apellidos'],
                'edad' => $registro['edad'],
                'celular' => $registro['celular'],
                'email' => $registro['email'],
                'token_reset' => $token_reset,
                // 'contrasena' => sha1($registro['contrasena']),
                'estado' => 1,
                'fecha_creacion' => date('Y-m-d H:i:s')
            ];
            Session::put('argsUsuario', $argsUsuario);
            $user_id = DB::table('usuarios')->insertGetId($argsUsuario);
            Session::put('user_id', $user_id);
            // Session::put('argsUsuario', $argsUsuario);
            // }

            // Registro mascota
            $argsMascota = [
                'nombre_mascota' => $registro['nombre_mascota'],
                'edad_mascota' => $registro['edad_mascota'],
                'peso_mascota' => $registro['peso_mascota'],
                'sexo_mascota' => $registro['sexo_mascota'],
                'raza_mascota' => $registro['raza_mascota'],
                'muerte_mascota' => $registro['muerte_mascota'],
                'id_usuario' => $user_id,
                'tipo_mascota' => $registro['tipo_mascota'],
                'fecha_creacion' => date('Y-m-d')
            ];
            $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

            // Registro recojo
            $argsRecojo = [
                'fecha_recojo' => $registro['fecha_recojo'],
                'id_horario' => $registro['hora_recojo'],
                'id_distrito' => $registro['distrito_recojo'],
                'direccion_recojo' => $registro['direccion_recojo'],
                'id_usuario' => $user_id,
                'id_mascota' => $mascota_id,
                'etapa' => 1,
                // Asignacion fija
                'estado' => 1,
                // 'estado_etapa' => 1,
                'id_conductor' => 3,
                'conductor_confirmado' => 1,
            ];

            $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
            // $argsRecojo["etapa"] = 2;
            // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);

            // use Carbon\Carbon;
            $fechaBase = Carbon::parse(date('Y-m-d')); // Fecha actual
            $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas
            $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

            // echo $fechaFormateada;

            $argsCompostaje = [
                'id_mascota' => $mascota_id,
                'estado' => 1,
                // 'estado_etapa' => 0,
                // Asignacion fija
                'id_operario' => 1,
                'operario_confirmado' => 1,
                'fin_tentativo' => $fechaFormateada
            ];

            $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);

            // Registrar pedido
            $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

            $argsPedido = [
                'estado_pedido' => 1,
                'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
                'id_recojo_ida' => $recojo_ida_id,
                // 'id_recojo_vuelta' => $recojo_vuelta_id,
                'id_mascota' => $mascota_id,
                'id_usuario' => $user_id,
                'id_compostaje' => $compostaje_id,
                // 'fecha_recojo' => $registro['fecha_recojo'],
                'id_horario' => $registro['hora_recojo'],
                'acompaniar_mascota' => $registro['acompaniar_mascota'],
                'traslado_mascota' => $registro['traslado_mascota'],
                // 'direccion_recojo' => $registro['direccion_recojo'],
                // 'con_entrega' => $registro['con_entrega'] == 'true' ? 1 : 0,
                'fecha_creacion' => date('Y-m-d H:i:s'),
                'pedido_activo' => 0,
            ];
            // if ($registro['nuevaDireccion'] == 'true') {
            //   $argsPedido['direccion_entrega'] = $registro['nueva_direccion'];
            // } else {
            //   $argsPedido['direccion_entrega'] = $registro['direccion_recojo'];
            // }
            $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


            $argsPagos = [
                'monto_servicio' => $data['precio-servicio'],
                'id_pedido_pago' => $pedido_id,
                'forma_pago' => $data['forma-pago'],
                'tipo_pago' => 'servicio',
                'cantidad_cuotas' => $data['numero-cuotas'],
                'fecha_1_pago' => date('Y-m-d H:i:s'),
                'pago_cuota_1' => $data['precio-cuota'],
                'total_pagar' => $data['precio-total'],
                'igv' => $data['precio-igv'],
                'costo_envio' => $data['precio-recojo'],
                'pago_extra' => $data['precio-extra'],
                'pago_peso' => $data['precio-peso'],
                'fee_adicional' => 0,
                'costo_envio_dia' => $data['precio-diarecojo'],
                'costo_envio_hora' => $data['precio-horarecojo'],
                'costo_envio_distrito' => $data['precio-distritorecojo'],
                'metodo_pago' => 'transferencia',
                //'prod_extras' => json_encode($filteredExtras) ?? null
            ];

            if (isset($data['extra'])) {
                $filteredExtras = array_filter($data['extra'], function ($value) {
                    return intval($value) >= 1;
                });

                $argsPagos['prod_extras'] = json_encode($filteredExtras);

            }


            if ($data['forma-pago'] == 'total') {
                $argsPagos['pago_cuota_1'] = $data['precio-total'];
            }

            if ($data['forma-pago'] == 'cuotas') {
                $fecha = strtotime('+1 month', strtotime(date('Y-m-d')));
                $fecha_formateada = date('Y-m-d', $fecha);
                $argsPagos['fecha_2_pago'] = $fecha_formateada;
            }

            // @dd($argsPagos);

            $pagos_id = DB::table('pagos')->insertGetId($argsPagos);


            // AQUI REVISAR
            $argsServicio = [
                'pedido_id' => $pedido_id,
                'producto_id' => 1,
                'servicio_id' => $registro['servicio-vuelve'],
                'pedido_tipo' => 'servicio',
                'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                'created_at' => date('Y-m-d H:i:s')
            ];

            // Insertamos una fila por cada unidad del producto
            DB::table('pedidos_productos')->insert($argsServicio);

            // if($servicio->id_servicio == 1 || $servicio->id_servicio == 3){

            // }


            // Registrar items extras
            if (isset($data['extra'])) {
                foreach ($data['extra'] as $producto_id => $cantidad) {
                    // $argsExtra = [
                    //   'pedido_id' => $pedido_id,
                    //   'producto_id' => $producto_id,
                    //   'cantidad' => $cantidad,
                    //   'created_at' => date('Y-m-d H:i:s')
                    // ];
                    // DB::table('pedidos_productos')->insert($argsExtra);
                    for ($i = 0; $i < $cantidad; $i++) {
                        $argsExtra = [
                            'pedido_id' => $pedido_id,
                            'producto_id' => $producto_id,
                            'servicio_id' => $registro['servicio-vuelve'],
                            'pedido_tipo' => 'extra',
                            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                            'created_at' => date('Y-m-d H:i:s')
                        ];

                        // Insertamos una fila por cada unidad del producto
                        DB::table('pedidos_productos')->insert($argsExtra);
                    }
                }
            }

            if ($registro['servicio-vuelve'] == 1) {
                // if (!$user_id) {
                $argsMail = [
                    'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                    'nombre_mascota' => $argsMascota['nombre_mascota'],
                    'hora_recojo' => $registro['hora_recojo'],
                    'acompaniar_mascota' => $argsPedido['acompaniar_mascota'],
                    'token_reset' => $token_reset
                ];

                $argsMailUsuarioNuevo = [
                    'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                    'celular' => $registro['celular'],
                    'nombre_mascota' => $argsMascota['nombre_mascota'],
                    'raza_mascota' => $argsMascota['raza_mascota'],
                    'fecha_recojo' => $registro['fecha_recojo'],
                    'id_horario' => $registro['hora_recojo'],
                    'direccion_recojo' => $registro['direccion_recojo'],
                    'forma_pago' => 'Mercado Pago',
                ];

                // @dd($argsMail);


                Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
                Mail::to($registro['email'])->send(new RegistroUsuario($argsMail));
                //$request->session()->flush();
                // Mail::to(config('mail.admin_address'))->send(new RegistroUsuario($argsMail));
                // }
            }

            if ($registro['servicio-vuelve'] == 2) {
                // if (!$user_id) {
                $argsMail = [
                    'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                    'nombre_mascota' => $argsMascota['nombre_mascota'],
                    'token_reset' => $token_reset
                ];

                $argsMailUsuarioNuevo = [
                    'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                    'celular' => $registro['celular'],
                    'nombre_mascota' => $argsMascota['nombre_mascota'],
                    'raza_mascota' => $argsMascota['raza_mascota'],
                    'fecha_recojo' => $registro['fecha_recojo'],
                    'id_horario' => $registro['hora_recojo'],
                    'direccion_recojo' => $registro['direccion_recojo'],
                    'forma_pago' => 'Mercado Pago',
                ];

                // @dd($argsMail);


                Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));

                // @dd($argsMail);

                Mail::to($registro['email'])->send(new RegistroUsuarioPlanSiempreJuntos($argsMail));
                // Mail::to(config('mail.admin_address'))->send(new RegistroUsuario($argsMail));
                // }
            }

            return redirect()->route('pedido_realizado', ['orden' => $pedido_id]);


        } else {
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'message' => 'No se encontró un, comunícate con soporte'
            ]);
        }

    }

    public function process_payment(Request $request)
    {
        // $user_id = $request->session()->get('user_id');

        // return dd($user_id);

        $data = $request->all();

        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {
                    // @dd($registro);
                    $registro = $request->session()->get('registro');

                    $payment = new MercadoPago\Payment();
                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();

                    // print_r($payment);die;

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }


                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        $token_reset = time();

                        // @dd($user_id, $registro);
                        // if (!$user_id) {
                        $argsUsuario = [
                            'nombres' => $registro['nombres'],
                            'apellidos' => $registro['apellidos'],
                            'edad' => $registro['edad'],
                            'celular' => $registro['celular'],
                            'email' => $registro['email'],
                            'token_reset' => $token_reset,
                            // 'contrasena' => sha1($registro['contrasena']),
                            'estado' => 1,
                            'fecha_creacion' => date('Y-m-d H:i:s')
                        ];
                        Session::put('argsUsuario', $argsUsuario);
                        $user_id = DB::table('usuarios')->insertGetId($argsUsuario);
                        Session::put('user_id', $user_id);
                        // Session::put('argsUsuario', $argsUsuario);
                        // }

                        // Registro mascota
                        $argsMascota = [
                            'nombre_mascota' => $registro['nombre_mascota'],
                            'edad_mascota' => $registro['edad_mascota'],
                            'peso_mascota' => $registro['peso_mascota'],
                            'sexo_mascota' => $registro['sexo_mascota'],
                            'raza_mascota' => $registro['raza_mascota'],
                            'muerte_mascota' => $registro['muerte_mascota'],
                            'id_usuario' => $user_id,
                            'tipo_mascota' => $registro['tipo_mascota'],
                            'fecha_creacion' => date('Y-m-d')
                        ];
                        $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

                        // Registro recojo
                        $argsRecojo = [
                            'fecha_recojo' => $registro['fecha_recojo'],
                            'id_horario' => $registro['hora_recojo'],
                            'id_distrito' => $registro['distrito_recojo'],
                            'direccion_recojo' => $registro['direccion_recojo'],
                            'id_usuario' => $user_id,
                            'id_mascota' => $mascota_id,
                            'etapa' => 1,
                            // Asignacion fija
                            'estado' => 1,
                            // 'estado_etapa' => 1,
                            'id_conductor' => 3,
                            'conductor_confirmado' => 1,
                        ];

                        $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
                        // $argsRecojo["etapa"] = 2;
                        // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);

                        // use Carbon\Carbon;
                        $fechaBase = Carbon::parse(date('Y-m-d')); // Fecha actual
                        $fechaNueva = $fechaBase->addWeeks(6); // Sumar 6 semanas
                        $fechaFormateada = $fechaNueva->format('Y-m-d'); // Formato YYYY-MM-DD

                        // echo $fechaFormateada;

                        $argsCompostaje = [
                            'id_mascota' => $mascota_id,
                            'estado' => 1,
                            // 'estado_etapa' => 0,
                            // Asignacion fija
                            'id_operario' => 1,
                            'operario_confirmado' => 1,
                            'fin_tentativo' => $fechaFormateada
                        ];

                        $compostaje_id = DB::table('compostajes')->insertGetId($argsCompostaje);

                        // Registrar pedido
                        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

                        $argsPedido = [
                            'estado_pedido' => 1,
                            'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
                            'id_recojo_ida' => $recojo_ida_id,
                            // 'id_recojo_vuelta' => $recojo_vuelta_id,
                            'id_mascota' => $mascota_id,
                            'id_usuario' => $user_id,
                            'id_compostaje' => $compostaje_id,
                            // 'fecha_recojo' => $registro['fecha_recojo'],
                            'id_horario' => $registro['hora_recojo'],
                            'acompaniar_mascota' => $registro['acompaniar_mascota'],
                            'traslado_mascota' => $registro['traslado_mascota'],
                            // 'direccion_recojo' => $registro['direccion_recojo'],
                            // 'con_entrega' => $registro['con_entrega'] == 'true' ? 1 : 0,
                            'fecha_creacion' => date('Y-m-d H:i:s')
                        ];
                        // if ($registro['nuevaDireccion'] == 'true') {
                        //   $argsPedido['direccion_entrega'] = $registro['nueva_direccion'];
                        // } else {
                        //   $argsPedido['direccion_entrega'] = $registro['direccion_recojo'];
                        // }
                        $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


                        $argsPagos = [
                            'monto_servicio' => $data['data']['precio-servicio'],
                            'id_pedido_pago' => $pedido_id,
                            'forma_pago' => $data['data']['forma-pago'],
                            'tipo_pago' => 'servicio',
                            'metodo_pago' => 'mercado_pago',
                            'cantidad_cuotas' => $data['data']['numero-cuotas'],
                            'fecha_1_pago' => date('Y-m-d H:i:s'),
                            'pago_cuota_1' => $data['data']['precio-cuota'],
                            'total_pagar' => $data['data']['precio-total'],
                            'igv' => $data['data']['precio-igv'],
                            'costo_envio' => $data['data']['precio-recojo'],
                            'pago_extra' => $data['data']['precio-extra'],
                            'pago_peso' => $data['data']['precio-peso'],
                            'fee_adicional' => 0,
                            'costo_envio_dia' => $data['data']['precio-diarecojo'],
                            'costo_envio_hora' => $data['data']['precio-horarecojo'],
                            'costo_envio_distrito' => $data['data']['precio-distritorecojo']
                            //'prod_extras' => json_encode($filteredExtras) ?? null
                        ];

                        if (isset($data['data']['extra'])) {
                            $filteredExtras = array_filter($data['data']['extra'], function ($value) {
                                return intval($value) >= 1;
                            });

                            $argsPagos['prod_extras'] = json_encode($filteredExtras);

                        }


                        if ($data['data']['forma-pago'] == 'total') {
                            $argsPagos['pago_cuota_1'] = $data['data']['precio-total'];
                        }

                        if ($data['data']['forma-pago'] == 'cuotas') {
                            $fecha = strtotime('+1 month', strtotime(date('Y-m-d')));
                            $fecha_formateada = date('Y-m-d', $fecha);
                            $argsPagos['fecha_2_pago'] = $fecha_formateada;
                        }

                        // @dd($argsPagos);

                        $pagos_id = DB::table('pagos')->insertGetId($argsPagos);


                        // AQUI REVISAR
                        $argsServicio = [
                            'pedido_id' => $pedido_id,
                            'producto_id' => 1,
                            'servicio_id' => $registro['servicio-vuelve'],
                            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                            'created_at' => date('Y-m-d H:i:s')
                        ];

                        // Insertamos una fila por cada unidad del producto
                        DB::table('pedidos_servicios')->insert($argsServicio);

                        // if($servicio->id_servicio == 1 || $servicio->id_servicio == 3){

                        // }


                        // Registrar items extras
                        if (isset($data['data']['extra'])) {
                            foreach ($data['data']['extra'] as $producto_id => $cantidad) {
                                // $argsExtra = [
                                //   'pedido_id' => $pedido_id,
                                //   'producto_id' => $producto_id,
                                //   'cantidad' => $cantidad,
                                //   'created_at' => date('Y-m-d H:i:s')
                                // ];
                                // DB::table('pedidos_productos')->insert($argsExtra);
                                for ($i = 0; $i < $cantidad; $i++) {
                                    $argsExtra = [
                                        'pedido_id' => $pedido_id,
                                        'producto_id' => $producto_id,
                                        'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                                        'created_at' => date('Y-m-d H:i:s')
                                    ];

                                    // Insertamos una fila por cada unidad del producto
                                    DB::table('pedidos_productos')->insert($argsExtra);
                                }
                            }
                        }

                        if ($registro['servicio-vuelve'] == 1) {
                            // if (!$user_id) {
                            $argsMail = [
                                'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                                'nombre_mascota' => $argsMascota['nombre_mascota'],
                                'hora_recojo' => $registro['hora_recojo'],
                                'acompaniar_mascota' => $argsPedido['acompaniar_mascota'],
                                'token_reset' => $token_reset
                            ];

                            $argsMailUsuarioNuevo = [
                                'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                                'celular' => $registro['celular'],
                                'nombre_mascota' => $argsMascota['nombre_mascota'],
                                'raza_mascota' => $argsMascota['raza_mascota'],
                                'fecha_recojo' => $registro['fecha_recojo'],
                                'id_horario' => $registro['hora_recojo'],
                                'direccion_recojo' => $registro['direccion_recojo'],
                                'forma_pago' => 'Mercado Pago',
                            ];

                            // @dd($argsMail);

                            Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
                            Mail::to($registro['email'])->send(new RegistroUsuario($argsMail));
                            // }
                        }

                        if ($registro['servicio-vuelve'] == 2) {
                            // if (!$user_id) {
                            $argsMail = [
                                'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                                'nombre_mascota' => $argsMascota['nombre_mascota'],
                                'token_reset' => $token_reset
                            ];

                            $argsMailUsuarioNuevo = [
                                'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                                'celular' => $registro['celular'],
                                'nombre_mascota' => $argsMascota['nombre_mascota'],
                                'nombre_mascota' => $argsMascota['nombre_mascota'],
                                'raza_mascota' => $argsMascota['raza_mascota'],
                                'fecha_recojo' => $registro['fecha_recojo'],
                                'id_horario' => $registro['hora_recojo'],
                                'direccion_recojo' => $registro['direccion_recojo'],
                                'forma_pago' => 'Mercado Pago',
                            ];

                            // @dd($argsMail);

                            Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
                            Mail::to($registro['email'])->send(new RegistroUsuarioPlanSiempreJuntos($argsMail));


                            //$request->session()->flush();
                            // Mail::to(config('mail.admin_address'))->send(new RegistroUsuario($argsMail));
                            // }

//                            $response = array(
//                                "request" => $request,
//                                "payment_id" => $payment->id,
//                                "status" => $payment->status,
//                                "status_detail" => $payment->status_detail,
//                                "data" => $data,
//                                "registro" => $registro,
//                                'redirect_url' => $preapproval->init_point
//                            );
                        }

                        // Crear suscripción automática para la segunda cuota
                        $preapproval = new MercadoPago\Preapproval();
                        $preapproval->back_url = 'https://tusitio.com/mi-cuenta'; // Cambia por tu página real
                        $preapproval->reason = 'Segunda cuota producto';
                        $preapproval->external_reference = 'cuota_2_user_' . $payerForm['email'];
                        $preapproval->payer_email = $payerForm['email'];
                        $preapproval->auto_recurring = [
                            "frequency" => 1,
                            "frequency_type" => "months",
                            "transaction_amount" => $data['data']['precio-cuota'], // 2da cuota
                            "currency_id" => "PEN",
                            "start_date" => now()->addMonth()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
                            "end_date" => now()->addMonth()->addDays(2)->endOfDay()->format('Y-m-d\TH:i:s.000P')
                        ];
                        $preapproval->save();

                        if ($preapproval->init_point) {

                            $response = array(
                                "request" => $request,
                                "data" => $data,
                                "registro" => $registro,
                                'redirect_url' => $preapproval->init_point,
                                'status' => 'approved',
                                'status_detail' => $payment->status_detail,
                                'payment_id' => $payment->id,
                            );

                            echo json_encode($response);


                        } else {
                            Log::error('Preapproval error:', [
                                'status' => $preapproval->status,
                                'init_point' => $preapproval->init_point,
                                'error' => $preapproval->error,
                                'cause' => $preapproval->cause ?? 'n/a'
                            ]);

                            return response()->json([

                                'status' => 'approved',
                                'message' => 'Pago realizado, pero no se pudo programar el segundo cobrox.',
                                'payment_id' => $payment->id

                            ]);


                        }


                    }

//                    echo json_encode($response);

                    // $payment->transaction_amount = (float) $data['transaction_amount'];
                    // $payment->token = $data['token'];
                    // $payment->description = "Test Silk Shirt";
                    // $payment->installments = 1;
                    // $payment->payment_method_id = $data['payment_method_id'];
                    // $payment->payer = $data['payer'];

                    // $payment->save();

                    // echo $payment->status;
                    // echo json_encode($payment);

                    // Step 7: Handle exceptions
                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;


            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }

    public function process_payment_extras(Request $request)
    {
        $user_id = $request->session()->get('user_id');

        // return dd($user_id);

        $data = $request->all();
//        @dd($data);
        // print_r($data);die;
        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        // return dd($user_id);

        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {

                    $payment = new MercadoPago\Payment();
                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }

                    $registro = $request->session()->get('registro');

                    $response = array(
                        "request" => $request,
                        "payment_id" => $payment->id,
                        "status" => $payment->status,
                        "status_detail" => $payment->status_detail,
                        "data" => $data,
                        "registro" => $registro
                    );

                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        // Registro usuario
                        $user_id = Session::get('user_id');
                        $token_reset = time();

                        $pedido_id = $data['data']['id'];

                        $filteredExtras = array_filter($data['data']['extra'], function ($value) {
                            return intval($value) >= 1;
                        });


                        $argsPagos = [
                            'forma_pago' => 'total',
                            'id_pedido_pago' => $pedido_id,
                            'tipo_pago' => 'extra',
                            'fecha_1_pago' => date('Y-m-d H:i:s'),
                            'total_pagar' => $data['data']['precio-total'],
                            'igv' => $data['data']['precio-igv'],
                            'pago_extra' => $data['data']['precio-total'],
                            'prod_extras' => json_encode($filteredExtras),
                        ];

                        $pagos_id = DB::table('pagos')->insertGetId($argsPagos);

                        // Registrar items extras
                        if (isset($data['data']['extra'])) {
                            foreach ($data['data']['extra'] as $producto_id => $cantidad) {
                                // $argsExtra = [
                                //   'pedido_id' => $pedido_id,
                                //   'producto_id' => $producto_id,
                                //   'cantidad' => $cantidad,
                                //   'created_at' => date('Y-m-d H:i:s')
                                // ];
                                // DB::table('pedidos_productos')->insert($argsExtra);
                                for ($i = 0; $i < $cantidad; $i++) {
                                    $argsExtra = [
                                        'pedido_id' => $pedido_id,
                                        'pago_id' => $pagos_id,
                                        'producto_id' => $producto_id,
                                        'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                                        'created_at' => date('Y-m-d H:i:s')
                                    ];

                                    // Insertamos una fila por cada unidad del producto
                                    DB::table('pedidos_productos')->insert($argsExtra);
                                }
                            }
                        }

                    }

                    echo json_encode($response);

                    // $payment->transaction_amount = (float) $data['transaction_amount'];
                    // $payment->token = $data['token'];
                    // $payment->description = "Test Silk Shirt";
                    // $payment->installments = 1;
                    // $payment->payment_method_id = $data['payment_method_id'];
                    // $payment->payer = $data['payer'];

                    // $payment->save();

                    // echo $payment->status;
                    // echo json_encode($payment);

                    // Step 7: Handle exceptions
                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;


                $client = new PaymentClient();
                $request_options = new RequestOptions();
                $request_options->setCustomHeaders(["X-Idempotency-Key: <SOME_UNIQUE_VALUE>"]);

                $payment = $client->create([
                    "transaction_amount" => (float)$data['precio-total'],
                    "token" => $data['_token'],
                    "description" => 'Prueba compra',
                    "installments" => 1,
                    "payment_method_id" => $data['payment_method_id'],
                    "issuer_id" => $data['issuer_id'],
                    "payer" => $data['payer']
                ], $request_options);
                echo implode($payment);
                die;


                //createPreapproval($reason, $back_url = null)
                $preapproval = MercadoPago()->preapproval();
                // $preapproval = MercadoPago()->createPreapproval('Parenteen 1 mes');
                $preapproval = MercadoPago()->createPreapproval('Premium');
                //  $preapproval = MercadoPago()->preapproval();

                //createPreapproval($reason, $back_url = null)
                $preapproval->preapproval_plan_id = $plan->mp_plan_id;
                $preapproval->reason = $plan->reason;
                $preapproval->external_reference = $plan->external_reference;
                // if ($plan->frecuencia == 1) {
                // } else {
                //   $preapproval->reason = $plan->frecuencia.' Meses';
                //   $preapproval->external_reference = $plan->frecuencia.'M';
                // }
                $preapproval->payer_email = $usuario->email;
                $preapproval->card_token_id = $data['token'];
                // $preapproval->payer_email = 'hola@vuelvecompostario.com';
                $argsmp = [
                    "frequency" => $plan->frecuencia,
                    "frequency_type" => "months",
                    "start_date" => date('Y-m-d H:i:s'),
                    "transaction_amount" => $data['monto'],
                    "currency_id" => "PEN"
                ];
                if ($plan->dias_espera > 1) {
                    $argsmp["free_trial"] = [
                        "frequency" => $plan->dias_espera,
                        "frequency_type" => "days"
                    ];
                }
                $preapproval->auto_recurring = $argsmp;
                $preapproval->status = 'authorized';
                $preapproval->back_url = 'https://parenteen.net/pagoexitoso';

                // print_r($preapproval);die;
                $preapproval->save();


                if (empty($data['cupon'])) $data['cupon'] = '';
                $args = [
                    'idplan' => $plan->idplan,
                    'fecha_inicio' => date('Y-m-d H:i:s'),
                    'fecha_fin' => date('Y-m-d H:i:s', strtotime('+' . $plan->frecuencia . ' months')),
                    'fecha_ultimo_pago' => date('Y-m-d H:i:s'),
                    'estado' => 1,
                    'idusuario' => $user_id,
                    'cupon' => $data['cupon'],
                    'payment_method_id' => $data['payment_method_id'],
                    'identification_number' => $data['payer']['identification']['number'],
                    'identification_type' => $data['payer']['identification']['type'],
                    'token' => $data['token']
                ];
                if (!empty($preapproval->id)) {
                    $args['payment_id'] = $preapproval->id;
                } else {
                    echo json_encode([
                        'id' => 0,
                        'status' => 'error',
                        'error' => '',
                        'message' => 'Hubo un error y no se pudo realizar la suscripción'
                    ]);
                    die;
                }
                DB::table('suscripciones')->insert($args);

                // Registrar a mailchimp
                $data_mailchimp = [
                    'nombres' => $usuario->nombres,
                    'email' => $usuario->email,
                    'status' => 'subscribed'
                ];

                $apiKey = '983cf1e8ba2376b1f02bd548be7de885-us5';
                $listId = '63dd237e45';

                $memberId = md5(strtolower($data_mailchimp['email']));
                $dataCenter = substr($apiKey, strpos($apiKey, '-') + 1);
                $url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listId . '/members/' . $memberId;

                $json = json_encode([
                    'email_address' => $data_mailchimp['email'],
                    'status' => $data_mailchimp['status'], //"subscribed","unsubscribed","cleaned","pending"
                    'merge_fields' => [
                        'NOMBRE' => $data_mailchimp['nombres'],
                        'APELLIDO' => $data_mailchimp['nombres']
                    ]
                ]);

                $ch = curl_init($url);

                curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

                $result = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);

                echo json_encode([
                    'id' => 1,
                    'status' => 'approved',
                    'status_detail' => 'accredited'
                ]);
            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }

    public function process_payment_cuotas(Request $request)
    {
        $user_id = $request->session()->get('user_id');

        // return dd($user_id);

        $data = $request->all();
        // @dd($data);
        // print_r($data);die;
        $usuario = DB::table('usuarios')->where('id', $user_id)->first();

        // return dd($user_id);

        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {

                    $payment = new MercadoPago\Payment();
                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }

                    $registro = $request->session()->get('registro');

                    $response = array(
                        "request" => $request,
                        "payment_id" => $payment->id,
                        "status" => $payment->status,
                        "status_detail" => $payment->status_detail,
                        "data" => $data,
                        "registro" => $registro
                    );

                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        // Registro usuario
                        $user_id = Session::get('user_id');
                        $token_reset = time();

                        $pedido_id = $data['data']['id'];
                        $pago_id = $data['data']['id-pago'];
                        $pago_cuota = $data['data']['pago-cuota'];

                        // Registrar items extras

                        DB::table('pagos')->where('id_pago', $pago_id)->update([
                            'pago_cuota_2' => $pago_cuota,

                        ]);

                    }

                    echo json_encode($response);


                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;


                $client = new PaymentClient();
                $request_options = new RequestOptions();
                $request_options->setCustomHeaders(["X-Idempotency-Key: <SOME_UNIQUE_VALUE>"]);

                $payment = $client->create([
                    "transaction_amount" => (float)$data['precio-total'],
                    "token" => $data['_token'],
                    "description" => 'Prueba compra',
                    "installments" => 1,
                    "payment_method_id" => $data['payment_method_id'],
                    "issuer_id" => $data['issuer_id'],
                    "payer" => $data['payer']
                ], $request_options);
                echo implode($payment);
                die;


                //createPreapproval($reason, $back_url = null)
                $preapproval = MercadoPago()->preapproval();
                // $preapproval = MercadoPago()->createPreapproval('Parenteen 1 mes');
                $preapproval = MercadoPago()->createPreapproval('Premium');
                //  $preapproval = MercadoPago()->preapproval();

                //createPreapproval($reason, $back_url = null)
                $preapproval->preapproval_plan_id = $plan->mp_plan_id;
                $preapproval->reason = $plan->reason;
                $preapproval->external_reference = $plan->external_reference;
                // if ($plan->frecuencia == 1) {
                // } else {
                //   $preapproval->reason = $plan->frecuencia.' Meses';
                //   $preapproval->external_reference = $plan->frecuencia.'M';
                // }
                $preapproval->payer_email = $usuario->email;
                $preapproval->card_token_id = $data['token'];
                // $preapproval->payer_email = 'hola@vuelvecompostario.com';
                $argsmp = [
                    "frequency" => $plan->frecuencia,
                    "frequency_type" => "months",
                    "start_date" => date('Y-m-d H:i:s'),
                    "transaction_amount" => $data['monto'],
                    "currency_id" => "PEN"
                ];
                if ($plan->dias_espera > 1) {
                    $argsmp["free_trial"] = [
                        "frequency" => $plan->dias_espera,
                        "frequency_type" => "days"
                    ];
                }
                $preapproval->auto_recurring = $argsmp;
                $preapproval->status = 'authorized';
                $preapproval->back_url = 'https://parenteen.net/pagoexitoso';

                // print_r($preapproval);die;
                $preapproval->save();


                if (empty($data['cupon'])) $data['cupon'] = '';
                $args = [
                    'idplan' => $plan->idplan,
                    'fecha_inicio' => date('Y-m-d H:i:s'),
                    'fecha_fin' => date('Y-m-d H:i:s', strtotime('+' . $plan->frecuencia . ' months')),
                    'fecha_ultimo_pago' => date('Y-m-d H:i:s'),
                    'estado' => 1,
                    'idusuario' => $user_id,
                    'cupon' => $data['cupon'],
                    'payment_method_id' => $data['payment_method_id'],
                    'identification_number' => $data['payer']['identification']['number'],
                    'identification_type' => $data['payer']['identification']['type'],
                    'token' => $data['token']
                ];
                if (!empty($preapproval->id)) {
                    $args['payment_id'] = $preapproval->id;
                } else {
                    echo json_encode([
                        'id' => 0,
                        'status' => 'error',
                        'error' => '',
                        'message' => 'Hubo un error y no se pudo realizar la suscripción'
                    ]);
                    die;
                }
                DB::table('suscripciones')->insert($args);

                // Registrar a mailchimp
                $data_mailchimp = [
                    'nombres' => $usuario->nombres,
                    'email' => $usuario->email,
                    'status' => 'subscribed'
                ];

                $apiKey = '983cf1e8ba2376b1f02bd548be7de885-us5';
                $listId = '63dd237e45';

                $memberId = md5(strtolower($data_mailchimp['email']));
                $dataCenter = substr($apiKey, strpos($apiKey, '-') + 1);
                $url = 'https://' . $dataCenter . '.api.mailchimp.com/3.0/lists/' . $listId . '/members/' . $memberId;

                $json = json_encode([
                    'email_address' => $data_mailchimp['email'],
                    'status' => $data_mailchimp['status'], //"subscribed","unsubscribed","cleaned","pending"
                    'merge_fields' => [
                        'NOMBRE' => $data_mailchimp['nombres'],
                        'APELLIDO' => $data_mailchimp['nombres']
                    ]
                ]);

                $ch = curl_init($url);

                curl_setopt($ch, CURLOPT_USERPWD, 'user:' . $apiKey);
                curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_TIMEOUT, 10);
                curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'PUT');
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $json);

                $result = curl_exec($ch);
                $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                curl_close($ch);

                echo json_encode([
                    'id' => 1,
                    'status' => 'approved',
                    'status_detail' => 'accredited'
                ]);
            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }


    public function iniciar_sesion(Request $request)
    {
        return view('front.usuario.iniciar_sesion');
    }

    public function loginaction(Request $request)
    {
        $data = $request->all();
        // return dd($data);
        $password = $data['password'];
        $usuario = DB::table('usuarios')->where('email', $data['email'])->where('estado', 1)
            ->where(function ($query) use ($password) {
                $query->where('contrasena', $password)
                    ->orWhere('contrasena', sha1($password));
            })->first();
        if ($usuario) {
            Session::put('user_id', $usuario->id);
            if (isset($data['redirect']) && $data['redirect'] == 'registro-paso-2') {
                return redirect()->route('registro', ['paso' => 2]);
            }
            return redirect()->route('inicio');
        } else {
            return redirect()->back()->with('error', 'No se encontró el usuario y/o contraseña');
        }
    }

    public function recuperar_contrasena(Request $request)
    {

        // $user_id = session('user_id');
        // $usuario = DB::table('usuarios')->where('idusuario', $user_id)->first();


        // return view('front.recuperar_contrasena', compact('precioServicio', 'precioExtras','precioTotal'));
        return view('front.usuario.recuperar_contrasena');
    }

    function cambiar_contrasena(Request $request)
    {
        if ($_POST) {
            $data = $request->all();
            // return dd($data);
            if (!empty($data['password1']) && !empty($data['password2'])) {
                if ($data['password1'] != $data['password2']) {
                    return redirect()->back()->with('error', 'Las contraseñas deben ser indénticas');
                } else {
                    $usuario = DB::table('usuarios')->where('token_reset', $data['token'])->update([
                        'contrasena' => sha1($data['password1'])
                    ]);
                    return redirect()->route('cambiar-contrasena')->with('exito', 'Se cambió correctamente la contraseña');
                }
            } else {
                $token_reset = time();
                DB::table('usuarios')->where('email', $data['email'])->update([
                    'token_reset' => $token_reset
                ]);

                Mail::to($data['email'])->send(new ResetContrasena($data['email'], $token_reset));
                return redirect()->route('cambiar-contrasena')->with('exito', 'Se envío un correo para continuar con el proceso');
            }
        } else if (!empty($_GET['token'])) {
            $usuario = DB::table('usuarios')->where('token_reset', $_GET['token'])->first();
            // if (!$usuario) return redirect()->route('landing');
        }
        return view('front.cambiar_contrasena');
    }

    public function servicio_nuevo(Request $request)
    {

        $user_id = Session::get('user_id');
        $data = $request->session()->get('argsUsuario');

        $hora_actual = Carbon::now()->addHour()->format('H:i'); // Formato 24h (Ejemplo: "11:00")
        $hora_limite = "23:00"; // 10:00 PM en formato 24h

        $horarios = DB::table('horarios')->select('horario', 'id_horario', 'costo')->get()->filter(function ($horario) use ($hora_actual, $hora_limite) {
            $hora_inicio = Carbon::parse(trim(explode('-', $horario->horario)[0]));
            return $hora_inicio->between($hora_actual, $hora_limite);
        });

        $horario_first = $horarios->first();

        $pedido = DB::table('pedidos')->where('id_usuario', $user_id)->first();

        $recojo = DB::table('recojos')->where('id_recojo', $pedido->id_recojo_ida)->join('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')->first();


        // dd($data);

        if ($_POST) {

            $data = $request->all();

            return dd($data);
            $finduser = DB::table('usuarios')->where('email', $data['email'])->first();
            if ($finduser) {
                return redirect()->back()->with('error', 'El correo electrónico ya se encuentra registrado');
            } else {

                $argsUsuario = [
                    'nombres' => $data['nombres'],
                    'apellidos' => $data['apellidos'],
                    'edad' => $data['edad'],
                    'celular' => $data['celular'],
                    'email' => $data['email'],
                    // 'contrasena' => sha1($data['contrasena']),
                    'estado' => 1,
                    'fecha_creacion' => date('Y-m-d H:i:s')
                ];


                Session::put('argsUsuario', $argsUsuario);


                DB::table('usuarios')->insert($argsUsuario);
                Session::put('user_id', $finduser->idusuario);

                $argsMascota = [
                    'nombre_mascota' => $data['nombre_mascota'],
                    'edad_mascota' => $data['edad_mascota'],
                    'tipo_mascota' => $data['tipo_mascota'],
                    'peso_mascota' => $data['peso_mascota'],
                    'sexo_mascota' => $data['sexo_mascota'],
                    'fecha_recojo' => $data['fecha_recojo'],

                    'fecha_recojo' => $data['fecha_recojo'],
                    'hora_recojo' => $data['hora_recojo'],
                    'distrito_recojo' => $data['distrito_recojo'],
                    'direccion_recojo' => $data['direccion_recojo'],
                    'id_usuario' => $user_id,

                ];

                DB::table('mascotas')->insert($argsMascota);


            }
        }


        // @dd($horarios);


        return view('front.servicionuevo_vuelve_casa', compact('user_id', 'horarios', 'horario_first', 'recojo'));
    }


    public function registro_exitoso(Request $request)
    {
        $data = $request->session()->all();

        $userServicio = Session::get('user_servicio');

        if ($userServicio) {
            $servicios = $userServicio;
            $request->session()->flush();
        } else {
            return redirect()->route('iniciar_sesion');
        }

        return view('front.registro-exitoso', compact('servicios'));
    }

    public function pedido_realizado(Request $request)
    {

        // $user_id = Session::get('user_id');
        $data = $request->all();

        if ($_POST) {

            $data = $request->all();

//            @dd($data);
            $usuarioConstancia = DB::table('usuarios')
                ->where('id_usuario', $data['id_usuario'])
                ->first();

//            @dd($usuarioConstancia);

            $imagePaths = [];

            foreach ($request->file('foto_entrega') as $image) {
                $uniqueFileName = uniqid() . '_' . $image->getClientOriginalName();
                $imagePath = $image->storeAs('pagos-constancias', $uniqueFileName, 'public');

//                DB::table('pagos_constancias')->insert([
//                    'id_pago' => $data['id_pago'],
//                    'foto' => $imagePath,
//                    'fecha_creacion' => now(),
//                ]);

                $imagePaths[] = $imagePath; // <== Guardamos la ruta

            }

//            @dd($imagePaths);


            $argsMailConstantancia = [
                'nombre_usuario' => $usuarioConstancia->nombres . ' ' . $usuarioConstancia->apellidos,
                'celular' => $usuarioConstancia->celular,
                'id_pedido' => $data['id_pedido'],
                'email' => $usuarioConstancia->email,
                'dni' => $usuarioConstancia->dni,
                'forma_pago' => 'Yape o Plim'
            ];

            // @dd($argsMail);

            Mail::to(config('mail.admin_address'))->send(new RegistroConstanciaPago($argsMailConstantancia, $imagePaths));

            return redirect()->route('encuestas')->with('constancia', 'Se han enviado los comprobantes exitosamente. Nuestro equipo está validando los pagos. Puede apoyarnos respondiendo la siguiente encuesta.');

        }


        $pedido = DB::table('pedidos')
            ->where('id_pedido', $data['orden'])
            ->first();

        $pago = DB::table('pagos')
            ->where('id_pedido_pago', $data['orden'])
            ->first();


        return view('front.pedido_realizado', compact('pedido', 'pago'));
    }

//   Route::get('/registro-exitoso', function () {
//     return view('front.registro-exitoso');
// })->name('registro-exitoso');


}
