<?php

namespace App\Http\Controllers;

use App\Mail\RegistroConstanciaPago;
use App\Mail\RegistroUsuario;
use App\Mail\RegistroUsuarioNuevo;
use App\Mail\RegistroUsuarioPlanSiempreJuntos;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Mail;
use Session;

// SDK de Mercado Pago
use MercadoPago;


class RegistroSiempreJuntos extends Controller
{
    public function registroSiemprejuntos(Request $request)
    {

//        $user_id = Session::get('user_id');
        // $data = $request->session()->get('argsUsuario');

        // $data = $request->session()->all();
        // dd($user_id);

        if ($_POST) {

            $data = $request->all();

            // return dd($data);
            $finduser = DB::table('usuarios')->where('email', $data['email'])->first();
            if ($finduser) {
                return redirect()->back()->with('error', 'El correo electrónico ya se encuentra registrado');
            }
        }

//        $recojo = '';

        return view('front.registro_siempre_juntos');
    }

    public function registroSiemprejuntosCuotas(Request $request)
    {

        if ($_POST) {
            $data = $request->all();
            session(['registro' => $data]);
//            @dd($data);
            Session::put('user_email', $data['email']);
            Session::put('user_servicio', 2);
        }


//        "_token" => "eO5AUWugpjJwteYDEBrvGnwLnFsPSN0soAdM1WrN"
//        "servicio-vuelve" => "2"
//        "nombres" => "4343"
//        "apellidos" => "3232"
//        "celular" => "3232"
//        "email" => "332d32@gmail.comdd"
//        "terminoscon" => "on"
//        "consideracionesplan" => "on"
//        "nombre_mascota" => "reik"
//        "tipo_mascota" => "Conej@"
//        "edad_mascota" => "322"
//        "sexo_mascota" => "Hembra"
//        "peso_mascota" => "222"
//        "raza_mascota" => "22"
//        "fecha_recojo" => null
//        "hora_recojo" => null
//        "traslado_mascota" => null
//        "servicio-recojo" => null
//        "acompaniar_mascota" => null
//        "distrito_recojo" => "6"
//        "direccion_recojo" => "222222"

//        if ($registro == null) return redirect()->route('registro');


        $precioPeso = 690;
        $precioServicio = 690;

//        if ($registro['peso_mascota'] < 11) {
//            $precioPeso += 590;
//            $precioServicio += 590;
//        } elseif ($registro['peso_mascota'] > 11 && $registro['peso_mascota'] < 25) {
//            $precioPeso += 690;
//            $precioServicio += 690;
//        } elseif ($registro['peso_mascota'] > 26) {
//            $precioPeso += 790;
//            $precioServicio += 790;
//        }


//        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();
//
//        if ($servicio) {
//            $precioServicio += $servicio->costo;
//        }

        $precioRecojo = 0;
        $precioExtras = 0;

        $precioDiaRecojo = 0;
        $precioHoraRecojo = 0;
        $precioDistritoRecojo = 0;

        $precioRecojo += $precioDiaRecojo + $precioHoraRecojo + $precioDistritoRecojo;

        $precioTotal = $precioPeso + $precioRecojo;

        $precioIgv = round($precioTotal * 0.18, 2);

//        @dd($precioTotal);


        return view('front.registro.siemprejuntos.cuotas', compact('precioExtras', 'precioPeso', 'precioDiaRecojo', 'precioHoraRecojo', 'precioDistritoRecojo', 'precioRecojo', 'precioServicio', 'precioTotal', 'precioIgv'));
    }

    public function registroSiemprejuntosPago(Request $request)
    {
        // $data = $request->session()->all();
        // $dataJson = $request->query('data'); // Esto es un string JSON

        // return dd($dataJson);

        // $data = json_decode($_GET, true);
        // $data = json_decode($_GET, true);
        // $data = json_encode($_GET, true);

        $data = $request->all();
//        $registro = $request->session()->get('registro');

//        @dd($data);


//        Session::put('user_email', $registro['email']);
//        Session::put('user_servicio', 1);


//        @dd($registro);
//        @dd($);

        // $data = json_decode($dataJson, true)

//        return dd($data);
        if ($data['forma-pago'] == 'total') {

            $registro = $request->session()->get('registro');

//            "_token" => "OLw8Lgu0HD1Kz9d4eACUgyrYuNI70BK6r5jxt5qd"
//            "forma-pago" => "total"
//            "precio-servicio" => "690"
//            "precio-total" => "690"
//            "cant-cuota" => "0"
//            "precio-cuota" => "690"
//            "precio-igv" => "124.20"
//            "fee-adicional" => "0"
//            "precio-recojo" => "0"
//            "precio-diarecojo" => "0"
//            "precio-horarecojo" => "0"
//            "precio-distritorecojo" => "0"

            MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

            // $preference = new MercadoPago\Preference();

            // $item = new MercadoPago\Item();
            // $item->title = 'Suscripción a mi sitio web';
            // $item->quantity = 1;
            // $item->price = $_GET['precio-total'];
            // $item->unit_price = $_GET['precio-total'];
            // $item->currency_id = 'PEN';
            // $preference->items = array($item);
            // $preference->save();

            // $preference_id = $preference->id;


//            $formaDePago = $_GET['forma-pago'];

            // return dd($formaDePago);


            $data['numero-cuotas'] = 1;


            $data = json_encode($data, true);

//            @dd($registro);

            $preference_id = 0;

//            $precioCuota = $_GET['precio-cuota'];
            $precioTotal = $_GET['precio-cuota'];

//            if ($precioCuota == 0) {
//                $precioTotal = $_GET['precio-total'];
//            } else {
//            }

            $user_id = Session::get('user_id');

            return view('front.registro.siemprejuntos.pago-total', compact('precioTotal', 'preference_id', 'data', 'user_id'));

        } else {
            // Agrega credenciales
            $registro = $request->session()->get('registro');

//            return dd($registro);

            MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

            // $preference = new MercadoPago\Preference();

            // $item = new MercadoPago\Item();
            // $item->title = 'Suscripción a mi sitio web';
            // $item->quantity = 1;
            // $item->price = $_GET['precio-total'];
            // $item->unit_price = $_GET['precio-total'];
            // $item->currency_id = 'PEN';
            // $preference->items = array($item);
            // $preference->save();

            // $preference_id = $preference->id;


            $formaDePago = $_GET['forma-pago'];

            // return dd($formaDePago);


            if ($formaDePago === "total") {
                $data['numero-cuotas'] = 0;
            }


            $data = json_encode($data, true);

            // return dd($data);

            $preference_id = 0;
            $precioCuota = $_GET['precio-cuota'];

            if ($precioCuota == 0) {
                $precioTotal = $_GET['precio-total'];
            } else {
                $precioTotal = $_GET['precio-cuota'];
            }

            $user_id = Session::get('user_id');

            return view('front.registro.siemprejuntos.pago-cuotas', compact('precioTotal', 'preference_id', 'data', 'user_id'));
        }

    }

    public function registroSiemprejuntosPaymentSubscription(Request $request)
    {
        // Inicializa Mercado Pago

        $registro = $request->session()->get('registro');

        $data = $request->all();
        $data = json_decode($data['data'], true); // true para obtener array asociativo

        $token_reset = time();

        $pagos_id = 'pago_' . uniqid();

        $argsUsuario = [
            'nombres' => $registro['nombres'],
            'apellidos' => $registro['apellidos'],
            'edad' => $registro['edad'],
            'dni' => $registro['dni'],
            'celular' => $registro['celular'],
            'email' => $registro['email'],
            'token_reset' => $token_reset,
            // 'contrasena' => sha1($registro['contrasena']),
            'estado' => 0,
            'fecha_creacion' => date('Y-m-d H:i:s')
        ];
        Session::put('argsUsuario', $argsUsuario);
        $user_id = DB::table('usuarios')->insertGetId($argsUsuario);
        Session::put('user_id', $user_id);
//

        // Registro mascota
        $argsMascota = [
            'nombre_mascota' => $registro['nombre_mascota'],
            'edad_mascota' => $registro['edad_mascota'],
            'peso_mascota' => $registro['peso_mascota'],
            'sexo_mascota' => $registro['sexo_mascota'],
            'raza_mascota' => $registro['raza_mascota'],
//                            'muerte_mascota' => $registro['muerte_mascota'],
            'id_usuario' => $user_id,
            'tipo_mascota' => $registro['tipo_mascota'],
            'fecha_creacion' => date('Y-m-d')
        ];
        $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

//      Registro recojo
        $argsRecojo = [
//                            'fecha_recojo' => $registro['fecha_recojo'],
//                            'id_horario' => $registro['hora_recojo'],
            'id_distrito' => $registro['distrito_recojo'],
            'direccion_recojo' => $registro['direccion_recojo'],
            'id_usuario' => $user_id,
            'id_mascota' => $mascota_id,
            'etapa' => 0,
            // Asignacion fija
            'estado' => 0,
            // 'estado_etapa' => 1,
            'id_conductor' => 0,
            'conductor_confirmado' => 0,
        ];

        $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
        // $argsRecojo["etapa"] = 2;
        // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);


        // Registrar pedido
        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

        $argsPedido = [
            'estado_pedido' => 0,
            'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
            'id_recojo_ida' => $recojo_ida_id,
            // 'id_recojo_vuelta' => $recojo_vuelta_id,
            'id_mascota' => $mascota_id,
            'id_usuario' => $user_id,
            'pedido_activo' => 2,
            'fecha_creacion' => date('Y-m-d H:i:s')
        ];

        $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


        $argsPagos = [
            'user_id' => $user_id,
            'monto_servicio' => $data['precio-servicio'],
            'id_pedido_pago' => $pedido_id,
//            'id_cuota_pago' => $pagos_id,
            'forma_pago' => $data['forma-pago'],
            'tipo_pago' => 'servicio',
            'metodo_pago' => 'mercado_pago',
            'cantidad_cuotas' => $data['cant-cuota'],
//            'fecha_1_pago' => date('Y-m-d H:i:s'),
//            'pago_cuota_1' => $data['precio-cuota'],
            'total_pagar' => $data['precio-total'],
            'igv' => $data['precio-igv'],
            'costo_envio' => $data['precio-recojo'],
//            'pago_extra' => 0,
            'pago_peso' => $data['precio-total'],
            'fee_adicional' => 0,
            'costo_envio_dia' => $data['precio-diarecojo'],
            'costo_envio_hora' => $data['precio-horarecojo'],
            'costo_envio_distrito' => $data['precio-distritorecojo'],
            'estado' => 'pendiente',
            'created_at' => now(),
            'updated_at' => now()
        ];


        $numeroCuotas = $data['cant-cuota'];


        $pagos_id_db = DB::table('pagos')->insertGetId($argsPagos);


        // AQUI REVISAR
        $argsServicio = [
            'pedido_id' => $pedido_id,
            'producto_id' => 1,
            'servicio_id' => 2,
            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
            'created_at' => date('Y-m-d H:i:s')
        ];

        // Insertamos una fila por cada unidad del producto
        DB::table('pedidos_servicios')->insert($argsServicio);


        // Activar o Desactivar Correos
        $argsMail = [
            'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
            'nombre_mascota' => $argsMascota['nombre_mascota'],
            'token_reset' => $token_reset
        ];

        $argsMailUsuarioNuevo = [
            'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
            'celular' => $registro['celular'],
            'nombre_mascota' => $argsMascota['nombre_mascota'],
            'raza_mascota' => $argsMascota['raza_mascota'],
            'fecha_recojo' => $registro['fecha_recojo'],
            'id_horario' => $registro['hora_recojo'],
            'direccion_recojo' => $registro['direccion_recojo'],
            'forma_pago' => 'Mercado Pago',
        ];


//        Esto se envia despues de validar -->>

        Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
//        Mail::to($registro['email'])->send(new RegistroUsuarioPlanSiempreJuntos($argsMail));
//
//        <<--


        MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));
        $preapproval = new MercadoPago\Preapproval();

        $emailCliente = $registro['email']; // Debes capturarlo en el frontend
//        $montoCuota = $data['precio-cuota'];
        $montoCuota = 2.00;


        $preapproval->back_url = route('encuestas'); // Ruta a la que vuelven luego del pago
        $preapproval->reason = '(Total: ' . $data['precio-total'] . ' Soles) Paga en ' . $numeroCuotas . ' cuotas de : ';
//        $preapproval->reason = 'Producto X - 2 cuotas de S/ 100 (total S/ 200)';
        $preapproval->payer_email = $emailCliente;


        $preapproval->external_reference = json_encode([
            'pedido_id' => $pedido_id, // Debes definirlo tú, ejemplo: ID de tu orden en la BD
            'pagos_id' => $pagos_id, // Debes definirlo tú, ejemplo: ID de tu orden en la BD
            'monto' => $data['precio-cuota'],
            'email' => $registro['email'],
            'nombre_mascota' => $registro['nombre_mascota']
        ]);


//        OFICIAL

//        $preapproval->auto_recurring = [
//            "frequency" => 1,
//            "frequency_type" => "months",
//            "transaction_amount" => $montoCuota,
//            "currency_id" => "PEN",
//            "start_date" => now()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
//            "end_date" => now()->addMonths($numeroCuotas - 1)->endOfDay()->format('Y-m-d\TH:i:s.000P'),
//            "repetitions" => $numeroCuotas // ✅ Solo 2 pagos: hoy y en 1 mes
//        ];

        $preapproval->auto_recurring = [
            "frequency" => 1,
            "frequency_type" => "days", // Cobros diarios
            "transaction_amount" => $montoCuota,
            "currency_id" => "PEN",
            "start_date" => now()->startOfDay()->format('Y-m-d\TH:i:s.000P'),
            "end_date" => now()->addMonths($numeroCuotas - 1)->endOfDay()->format('Y-m-d\TH:i:s.000P'),
            "repetitions" => $numeroCuotas // Hoy y mañana
        ];


        try {
            $preapproval->save();

            $preapprovalId = $preapproval->id;

            DB::table('pagos')->where('id', $pagos_id_db)->update([
                'id_cuota_pago' => $preapprovalId,
            ]);


            if ($preapproval->init_point) {
                // Redirige al cliente para autorizar los cobros
                return redirect($preapproval->init_point);
            } else {
                Log::error('❌ Error al generar preapproval', (array)$preapproval);
                return back()->with('error', 'No se pudo generar el enlace de pago en cuotas.');
            }
        } catch (\Exception $e) {
            Log::error('❌ Excepción al crear preapproval', ['mensaje' => $e->getMessage()]);
            return back()->with('error', 'Error al iniciar el pago.');
        }
    }

    public function registroSiemprejuntosPayment(Request $request)
    {

        $data = $request->all();
        $registro = $request->session()->get('registro');

//        @dd($data);
//        @dd($registro);

        try {

            if ($data['token']) {

                MercadoPago\SDK::setAccessToken(config('services.mercadopago.access_token'));

                try {
                    // @dd($registro);
//                    $registro = $request->session()->get('registro');

                    $pagos_id = 'pago_' . uniqid();

                    $payment = new MercadoPago\Payment();
//                    $payment->transaction_amount = $data['transaction_amount'];
                    $payment->transaction_amount = 2.00;
                    $payment->token = $request->token;
                    $payment->description = "Compra de productos";
                    $payment->installments = (int)$request->installments;
                    $payment->payment_method_id = $request->payment_method_id;
                    $payment->issuer_id = (int)$request->issuer_id;
                    $payment->external_reference = json_encode([
                        'monto' => $data['data']['precio-total'],
                        'pagos_id' => $pagos_id,
                        'email' => $registro['email'],
                        'nombre_mascota' => $registro['nombre_mascota']
                    ]);

                    $payer = new MercadoPago\Payer();
                    $payerForm = $data['payer'];
                    $payer->email = $payerForm['email'];
                    $payer->identification = array(
                        "type" => $payerForm['identification']['type'],
                        "number" => $payerForm['identification']['number']
                    );
                    $payment->payer = $payer;
                    $payment->save();


//                    print_r($payment);
//                    die;

                    if ($payment->id === null) {
                        $error_message = 'Unknown error cause';
                        if (isset($payment->error)) {
                            $error_message = $payment->error->message;
                        }
                        echo $error_message;
                        die;
                    }


                    if ($payment->status == 'approved') {
                        // ----------------- Pago aprobado

                        $token_reset = time();

                        $argsUsuario = [
                            'nombres' => $registro['nombres'],
                            'apellidos' => $registro['apellidos'],
                            'edad' => $registro['edad'],
                            'dni' => $registro['dni'],
                            'celular' => $registro['celular'],
                            'email' => $registro['email'],
                            'token_reset' => $token_reset,
                            // 'contrasena' => sha1($registro['contrasena']),
                            'estado' => 1,
                            'fecha_creacion' => date('Y-m-d H:i:s')
                        ];
//                        Session::put('argsUsuario', $argsUsuario);
                        $user_id = DB::table('usuarios')->insertGetId($argsUsuario);
//                        Session::put('user_id', $user_id);
                        // Session::put('argsUsuario', $argsUsuario);
                        // }

                        // Registro mascota
                        $argsMascota = [
                            'nombre_mascota' => $registro['nombre_mascota'],
                            'edad_mascota' => $registro['edad_mascota'],
                            'peso_mascota' => $registro['peso_mascota'],
                            'sexo_mascota' => $registro['sexo_mascota'],
                            'raza_mascota' => $registro['raza_mascota'],
//                            'muerte_mascota' => $registro['muerte_mascota'],
                            'id_usuario' => $user_id,
                            'tipo_mascota' => $registro['tipo_mascota'],
                            'fecha_creacion' => date('Y-m-d')
                        ];
                        $mascota_id = DB::table('mascotas')->insertGetId($argsMascota);

//                        // Registro recojo
                        $argsRecojo = [
//                            'fecha_recojo' => $registro['fecha_recojo'],
//                            'id_horario' => $registro['hora_recojo'],
                            'id_distrito' => $registro['distrito_recojo'],
                            'direccion_recojo' => $registro['direccion_recojo'],
                            'id_usuario' => $user_id,
                            'id_mascota' => $mascota_id,
                            'etapa' => 0,
                            // Asignacion fija
                            'estado' => 0,
                            // 'estado_etapa' => 1,
                            'id_conductor' => 0,
                            'conductor_confirmado' => 0,
                        ];

                        $recojo_ida_id = DB::table('recojos')->insertGetId($argsRecojo);
                        // $argsRecojo["etapa"] = 2;
                        // $recojo_vuelta_id = DB::table('recojos')->insertGetId($argsRecojo);


                        // Registrar pedido
                        $servicio = DB::table('servicios')->where('slug', $registro['servicio-vuelve'])->first();

                        $argsPedido = [
                            'estado_pedido' => 1,
                            'id_servicio' => $registro['servicio-vuelve'], // Vuelve ceniza
                            'id_recojo_ida' => $recojo_ida_id,
                            // 'id_recojo_vuelta' => $recojo_vuelta_id,
                            'id_mascota' => $mascota_id,
                            'id_usuario' => $user_id,
                            'pedido_activo' => 1,
                            'fecha_creacion' => date('Y-m-d H:i:s')
                        ];

                        $pedido_id = DB::table('pedidos')->insertGetId($argsPedido);


                        $argsPagos = [
                            'user_id' => $user_id,
                            'monto_servicio' => $data['data']['precio-servicio'],
                            'id_pedido_pago' => $pedido_id,
                            'id_cuota_pago' => $pagos_id,
                            'forma_pago' => $data['data']['forma-pago'],
                            'tipo_pago' => 'servicio',
                            'metodo_pago' => 'mercado_pago',
                            'cantidad_cuotas' => $data['data']['numero-cuotas'],
                            'total_pagar' => $data['data']['precio-total'],
                            'igv' => $data['data']['precio-igv'],
                            'costo_envio' => $data['data']['precio-recojo'],
                            'pago_extra' => 0,
                            'pago_peso' => $data['data']['precio-total'],
                            'fee_adicional' => 0,
                            'costo_envio_dia' => $data['data']['precio-diarecojo'],
                            'costo_envio_hora' => $data['data']['precio-horarecojo'],
                            'costo_envio_distrito' => $data['data']['precio-distritorecojo'],
                            'estado' => 'pagado',
                            'created_at' => now(),
                            'updated_at' => now(),
                            //'prod_extras' => json_encode($filteredExtras) ?? null
                        ];

                        // @dd($argsPagos);

                        $pagos_id_db = DB::table('pagos')->insertGetId($argsPagos);

                        DB::table('pagos_cuotas')->insert([
                            'id_pago' => $pagos_id,
                            'numero_cuota' => 1,
                            'fecha_programada' => now(),
                            'fecha_pagada' => now(),
                            'monto' => $data['data']['precio-total'],
                            'estado' => 'pagado',
                            'boleta' => null,
                            'created_at' => now(),
                            'updated_at' => now(),
                        ]);


                        // AQUI REVISAR
                        $argsServicio = [
                            'pedido_id' => $pedido_id,
                            'producto_id' => 1,
                            'servicio_id' => 2,
                            'cantidad' => 1, // Siempre 1 porque cada unidad será un registro
                            'created_at' => date('Y-m-d H:i:s')
                        ];

                        // Insertamos una fila por cada unidad del producto
                        DB::table('pedidos_servicios')->insert($argsServicio);


                        // Activar o Desactivar Correos
                        $argsMail = [
                            'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                            'nombre_mascota' => $argsMascota['nombre_mascota'],
                            'token_reset' => $token_reset
                        ];

                        $argsMailUsuarioNuevo = [
                            'nombre_usuario' => $registro['nombres'] . ' ' . $registro['apellidos'],
                            'celular' => $registro['celular'],
                            'nombre_mascota' => $argsMascota['nombre_mascota'],
                            'raza_mascota' => $argsMascota['raza_mascota'],
                            'fecha_recojo' => $registro['fecha_recojo'],
                            'id_horario' => $registro['hora_recojo'],
                            'direccion_recojo' => $registro['direccion_recojo'],
                            'forma_pago' => 'Mercado Pago',
                        ];

                        // @dd($argsMail);

                        Mail::to(config('mail.admin_address'))->send(new RegistroUsuarioNuevo($argsMailUsuarioNuevo));
                        Mail::to($registro['email'])->send(new RegistroUsuarioPlanSiempreJuntos($argsMail));

//                        DB::table('pagos_cuotas')->insert([
//                            'id_pago' => $pagos_id,
//                            'numero_cuota' => 1,
//                            'fecha_programada' => date('Y-m-d H:i:s'),
//                            'fecha_pagada' => date('Y-m-d H:i:s'),
//                            'monto' => $data['data']['precio-cuota'],
//                            'estado' => 'pagado',
//                            'boleta' => null,
//                            'created_at' => now(),
//                            'updated_at' => now(),
//                        ]);


                        $response = array(
                            "request" => $request,
                            "payment_id" => $payment->id,
                            "status" => $payment->status,
                            "status_detail" => $payment->status_detail,
                            "data" => $data,
                            "registro" => $registro
                        );

                        echo json_encode($response);
                    }

                } catch (MPApiException $e) {
                    echo "Status code: " . $e->getApiResponse()->getStatusCode() . "\n";
                    echo "Content: ";
                    var_dump($e->getApiResponse()->getContent());
                    echo "\n";
                } catch (\Exception $e) {
                    echo "Error: " . $e->getMessage();
                }
                die;


            } else {
                echo json_encode([
                    'id' => 0,
                    'status' => 'error',
                    'message' => 'No se encontró un plan, comunícate con soporte'
                ]);
            }

        } catch (\Exception $e) {
            print_r($e);
            die;
            echo json_encode([
                'id' => 0,
                'status' => 'error',
                'error' => json_encode($e),
                'message' => 'Hubo un error al validar el pago, puedes volver a intentarlo con otra tarjeta'
            ]);
        }
    }


}
