<?php

namespace App\Http\Controllers;

use App\Mail\EntregaConductorPaso2;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Mail;
use App\Mail\RecojoIdaPaso1;
use App\Mail\RecojoIdaPaso2;
use App\Mail\RecojoIdaPaso3;
use App\Mail\RecojoIdaPaso4;
use App\Mail\ConfirmarAcompanamiento;
use App\Mail\NoConfirmarAcompanamiento;
use App\Mail\EntregaPaso2;
use App\Mail\EntregaPaso3;

// use App\Mail\EntregaPaso4;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;
use Session;

class ConductorController extends Controller
{
    //
    public function iniciar_sesion(Request $request)
    {
        return view('front.conductor.iniciar_sesion');
    }

    public function loginaction(Request $request)
    {
        $data = $request->all();
        //return dd($data);
        $password = $data['password'];
        $usuario = DB::table('conductores')->where('email', $data['email'])
            ->where(function ($query) use ($password) {
                $query->where('contrasena', $password)
                    ->orWhere('contrasena', sha1($password));
            })->first();
        if ($usuario) {
            Session::put('user_id', $usuario->id_conductor);
            // return redirect()->route('operario_inicio');
            return response()->json(['message' => 'Usuario registrado correctamente']);

        } else {
            return response()->json(['message' => 'No se encontró el usuario y/o contraseña']);
        }
    }

    public function inicio(Request $request)
    {

        $conductor_id = $request->session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        // $recojos = DB::table('recojos')->where('id_conductor', $conductor_id)->get();
        $recojos = DB::table('recojos')
            ->where('id_conductor', $conductor_id)
            // ->where('etapa' , 1)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->select(
                'usuarios.nombres',
                'usuarios.apellidos',
                'mascotas.nombre_mascota',
                'mascotas.edad_mascota',
                'mascotas.peso_mascota',
                'mascotas.tipo_mascota',
                'mascotas.sexo_mascota',
                'recojos.id_recojo',
                'horarios.horario',
                'distritos.distrito',
                'recojos.fecha_recojo',
                'recojos.etapa',
                'recojos.estado')
            ->orderByDesc('recojos.fecha_recojo')
            ->get();

        $fechaLimite = Carbon::now()->subDays(15); // Fecha hace 15 días

        $recojos15dias = DB::table('recojos')
            ->where('id_conductor', $conductor_id)
            ->whereDate('fecha_recojo', '>=', $fechaLimite)
            // ->where('etapa' , 1)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->select(
                'usuarios.nombres',
                'usuarios.apellidos',
                'mascotas.nombre_mascota',
                'mascotas.edad_mascota',
                'mascotas.peso_mascota',
                'mascotas.tipo_mascota',
                'mascotas.sexo_mascota',
                'recojos.id_recojo',
                'horarios.horario',
                'distritos.distrito',
                'recojos.fecha_recojo',
                'recojos.etapa',
                'recojos.estado')
            ->orderByDesc('recojos.fecha_recojo')
            ->get();

        $mesActual = Carbon::now()->month;

        $recojos1mes = DB::table('recojos')
            ->where('id_conductor', $conductor_id)
            ->whereMonth('fecha_recojo', $mesActual)
            // ->where('etapa' , 1)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->select(
                'usuarios.nombres',
                'usuarios.apellidos',
                'mascotas.nombre_mascota',
                'mascotas.edad_mascota',
                'mascotas.peso_mascota',
                'mascotas.tipo_mascota',
                'mascotas.sexo_mascota',
                'recojos.id_recojo',
                'horarios.horario',
                'distritos.distrito',
                'recojos.fecha_recojo',
                'recojos.etapa',
                'recojos.estado')
            ->orderByDesc('recojos.fecha_recojo')
            ->get();

        $inicioSemana = Carbon::now()->startOfWeek(); // Lunes de esta semana
        $finSemana = Carbon::now()->endOfWeek(); // Domingo de esta semana

        $recojos7dias = DB::table('recojos')
            ->where('id_conductor', $conductor_id)
            ->whereBetween('fecha_recojo', [$inicioSemana, $finSemana])
            // ->where('etapa' , 1)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->select(
                'usuarios.nombres',
                'usuarios.apellidos',
                'mascotas.nombre_mascota',
                'mascotas.edad_mascota',
                'mascotas.peso_mascota',
                'mascotas.tipo_mascota',
                'mascotas.sexo_mascota',
                'recojos.id_recojo',
                'horarios.horario',
                'distritos.distrito',
                'recojos.fecha_recojo',
                'recojos.etapa',
                'recojos.estado')
            ->orderByDesc('recojos.fecha_recojo')
            ->get();

        // @dd($recojos);

        $mascotas = DB::table('mascotas')->get();

        return view('front.conductor.inicio', compact('recojos', 'mascotas', 'conductor', 'recojos15dias', 'recojos7dias', 'recojos1mes'));
    }

    public function cerrar_sesion_conductor(Request $request)
    {
        $request->session()->flush();
        // return redirect()->route('landing');
        return redirect()->route('conductor_iniciar_sesion');
    }

    public function actividades(Request $request)
    {

        $conductor_id = $request->session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        $recojosPorHacer = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 1)->get();
        $recojosEnCurso = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 2)->get();
        $recojosCompletados = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 3)->get();


        // @dd($recojosPorHacer);

        return view('front.conductor.actividades', compact('recojosPorHacer', 'recojosEnCurso', 'recojosCompletados', 'conductor'));
    }

    public function recojo_de_mascotas(Request $request)
    {

        $conductor_id = $request->session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        $recojosPorHacer = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 1)->get();
        $recojosEnCurso = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 2)->get();
        $recojosCompletados = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 3)->get();


        // @dd($recojosPorHacer);

        return view('front.conductor.actividades_recojo', compact('recojosPorHacer', 'recojosEnCurso', 'recojosCompletados', 'conductor'));
    }

    public function entrega_de_mascotas(Request $request)
    {

        $conductor_id = $request->session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        $recojosPorHacer = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 1)->get();
        $recojosEnCurso = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 2)->get();
        $recojosCompletados = DB::table('recojos')->where('id_conductor', $conductor_id)->where('estado', 3)->get();


        // @dd($recojosPorHacer);

        return view('front.conductor.actividades_entrega', compact('recojosPorHacer', 'recojosEnCurso', 'recojosCompletados', 'conductor'));
    }

    public function actividades_recojo_id($id)
    {
        // var_dump($id);

        $conductor_id = session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }
        // $recojo = DB::table('recojos')->where('id_recojo', $id)->first();

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        // $mascota = DB::table('mascotas')->where('id_mascota', $recojo->id_mascota)->first();
        // $usuario = DB::table('usuarios')->where('id', $recojo->id_usuario)->first();

        $pedido_id = DB::table('pedidos')->where('id_recojo_ida', $id)->first();

        // @dd($pedido_id);

        $recojo = DB::table('recojos')
            ->where('id_recojo', $id)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->first();

        // var_dump($recojo);

//        $response = Http::withToken(config('services.mercadopago.access_token'))
//            ->get('https://api.mercadopago.com/v1/payments/119350696103');
//
//        $resultados = $response->json();
//
//
//        @dd($pedido_id);


        return view('front.conductor.actividades_recojo_id', compact('conductor', 'recojo', 'pedido_id'));
    }

    public function actividades_entrega_id($id)
    {
        // var_dump($id);

        $conductor_id = session()->get('user_id');

        $conductor_id = DB::table('conductores')->where('id_conductor', $conductor_id)->first();
        if (!$conductor_id) {
            return redirect()->route('conductor_iniciar_sesion');
        } else {
            $conductor_id = session()->get('user_id');
        }
        // $recojo = DB::table('recojos')->where('id_recojo', $id)->first();

        $conductor = DB::table('conductores')->where('id_conductor', $conductor_id)->first();

        // $mascota = DB::table('mascotas')->where('id_mascota', $recojo->id_mascota)->first();
        // $usuario = DB::table('usuarios')->where('id', $recojo->id_usuario)->first();

        $pedido_id = DB::table('pedidos')->where('id_recojo_vuelta', $id)->first();

        // @dd($pedido_id);

        $recojo = DB::table('recojos')
            ->where('id_recojo', $id)
            // ->leftJoin('conductores','recojos.id_conductor','=','conductores.id_conductor')
            ->leftJoin('usuarios', 'recojos.id_usuario', '=', 'usuarios.id')
            ->leftJoin('mascotas', 'recojos.id_mascota', '=', 'mascotas.id_mascota')
            ->leftJoin('horarios', 'recojos.id_horario', '=', 'horarios.id_horario')
            ->leftJoin('distritos', 'recojos.id_distrito', '=', 'distritos.id_distrito')
            ->first();

        // var_dump($recojo);

//        $response = Http::withToken(config('services.mercadopago.access_token'))
//            ->get('https://api.mercadopago.com/v1/payments/119350696103');
//
//        $resultados = $response->json();
//
//
//        @dd($pedido_id);


        return view('front.conductor.actividades_entrega_id', compact('conductor', 'recojo', 'pedido_id'));
    }

    public function confirmar_recojo_ida(Request $request)
    {
        $data = $request->all();
//        var_dump($data);
        // //return dd($data);
        // $password = $data['password'];

        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'id_conductor' => $data['id_conductor'],
            'conductor_confirmado' => $data['confirmacion'],
            'estado' => 1,
        ]);

//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function confirmar_acompanamiento(Request $request)
    {
        $data = $request->all();
        // @dd($data);
        // //return dd($data);
        // $password = $data['password'];

        $argsMail = [
            'nombre_usuario' => $data['nombre_usuario']
        ];

        if ($data['disponibilidad'] == 1) {
            Mail::to($data['email'])->send(new ConfirmarAcompanamiento($argsMail));
        }

        if ($data['disponibilidad'] == 0) {
            Mail::to($data['email'])->send(new NoConfirmarAcompanamiento($argsMail));
        }


        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'acompaniamento_confirmado' => $data['disponibilidad'],
        ]);


//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function registro_actividad_recojo_ida_paso1(Request $request)
    {
        $data = $request->all();
        // @dd($data);
        // //return dd($data);
        // $password = $data['password'];

        $argsMail = [
            'email' => $data['email'],
            'tiempo_llegada' => $data['tiempo_llegada']
        ];


        Mail::to($data['email'])->send(new RecojoIdaPaso1($argsMail));

        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 2,
            'tiempo_llegada' => $data['tiempo_llegada'],
        ]);

        DB::table('pedidos')->where('id_recojo_ida', $data['id_recojo'])->update([
            'estado_pedido' => 1,
            'seguimiento' => 1
        ]);

//        $plantillas = [
//            ['tipo' => 'seguimiento_1', 'dias' => 0],
//        ];
//
//        foreach ($plantillas as $p) {
//            DB::table('emails_programados')->insert([
//                'user_id' => $data['id_usuario'],
//                'email' => $data['email'],
//                'pedido_id' => $data['id_pedido'],
//                'tipo' => $p['tipo'],
//                'data' => json_encode([
//                    'nombre_usuario' => $data['nombre_usuario'],
//                    'nombre_mascota' => $data['nombre_mascota'],
//                ]),
//                'enviar_en' => now()->addDays($p['dias']),
//            ]);
//        }


//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function registro_actividad_recojo_ida_paso2(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 2,

        ]);

        // DB::table('pedidos')->where('id_recojo_ida', $data['id_recojo'])->update([
        //     'estado_pedido' => 1,
        // ]);
        // $argsMail = [
        //     'email' => $data['email'],
        //     'tiempo_llegada' => $data['tiempo_llegada']
        // ];

        Mail::to($data['email'])->send(new RecojoIdaPaso2());

//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function registro_actividad_recojo_ida_paso3(Request $request)
    {
        $data = $request->all();
//        var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 2,

        ]);

        $argsMail = [
            'nombre_usuario' => $data['nombre_usuario'],
            'nombre_mascota' => $data['nombre_mascota']
        ];

        Mail::to($data['email'])->send(new RecojoIdaPaso3($argsMail));


//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function registro_actividad_recojo_ida_paso4(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
//        @dd($data);
        // $password = $data['password'];
        $file_fotoentrega = $request->file('foto_entrega');

        if ($file_fotoentrega) {
            $originalFileName = $file_fotoentrega->getClientOriginalName();
            $path = $file_fotoentrega->storeAs('conductor-foto', $originalFileName, 'public'); // Guarda en storage/app/public/
            DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
                // 'estado_etapa' => $data['estado_etapa'],
                // 'estado' => 3,
                'foto_entrega' => $path

            ]);


        }

        if (isset($data['etapa_recojo']) && $data['etapa_recojo'] == 1) {
            DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
                'estado_etapa' => $data['estado_etapa'],
                'estado' => 3,
            ]);

            $argsMail = [
                'nombre_usuario' => $data['nombre_usuario'],
                'nombre_mascota' => $data['nombre_mascota']
            ];

            Mail::to($data['email'])->send(new RecojoIdaPaso4($argsMail));


        }

        if (isset($data['etapa_recojo']) && $data['etapa_recojo'] == 2) {

            DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
                'estado_etapa' => $data['estado_etapa'],
                'estado' => 3,
            ]);

            // Original

//            $plantillas = [
//                ['tipo' => 'seguimiento_7', 'dias' => 0],
//                ['tipo' => 'seguimiento_8', 'dias' => 14],
//            ];

            // QA

            $plantillas = [
                ['tipo' => 'seguimiento_7', 'dias' => 0],
                ['tipo' => 'seguimiento_8', 'dias' => 1],
            ];

            foreach ($plantillas as $p) {
                DB::table('emails_programados')->insert([
                    'user_id' => $data['id_usuario'],
                    'email' => $data['email'],
                    'pedido_id' => $data['id_pedido'],
                    'tipo' => $p['tipo'],
                    'data' => json_encode([
                        'nombre_usuario' => $data['nombre_usuario'],
                        'nombre_mascota' => $data['nombre_mascota'],
                    ]),
                    'enviar_en' => now()->addDays($p['dias']),
                ]);
            }

            DB::table('pedidos')->where('id_recojo_vuelta', $data['id_recojo'])->update([
                'estado_pedido' => 5,
            ]);
        }

//        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
    }

    public function registro_actividad_entrega_paso1(Request $request)
    {
        $data = $request->all();
        // @dd($data);
        // //return dd($data);
        // $password = $data['password'];

        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 1,
        ]);

        DB::table('pedidos')->where('id_recojo_vuelta', $data['id_recojo'])->update([
            'estado_pedido' => 4,
        ]);


////        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
        return redirect()->back();
    }

    public function registro_actividad_entrega_paso2(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 2,
            'tiempo_llegada' => $data['tiempo_llegada']

        ]);


        $argsMail = [
            'email' => $data['email'],
            'tiempo_llegada' => $data['tiempo_llegada'],
            'nombre_usuario' => $data['nombre_usuario'],
            'nombre_mascota' => $data['nombre_mascota']
        ];

        Mail::to(config('mail.admin_address'))->send(new EntregaConductorPaso2($argsMail));

        Mail::to($data['email'])->send(new EntregaPaso2($argsMail));

////        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
        return redirect()->back();
    }

    public function registro_actividad_entrega_paso3(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'estado_etapa' => $data['estado_etapa'],
            'estado' => 2,
        ]);


        $argsMail = [
            'nombre_usuario' => $data['nombre_usuario'],
            'nombre_mascota' => $data['nombre_mascota']
        ];

        Mail::to($data['email'])->send(new EntregaPaso3($argsMail));

////        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
        return redirect()->back();
    }

    public function confirmar_recojo_regreso(Request $request)
    {
        $data = $request->all();
        // var_dump($data);
        // //return dd($data);
        // $password = $data['password'];
        DB::table('recojos')->where('id_recojo', $data['id_recojo'])->update([
            'conductor_confirmado' => $data['confirmacion'],
            'estado' => 2,
        ]);

        $argsMail = [
            'email' => $data['email'],
            'tiempo_llegada' => $data['tiempo_llegada']
        ];


        Mail::to($data['email'])->send(new RecojoIdaPaso1($argsMail));


////        return redirect()->route('conductor_actividades_id', $data['id_recojo']);
        return redirect()->back();
        return redirect()->back();
    }


}
