<?php

namespace App\Console;

use App\Jobs\RevisarCorreosPendientes;
use App\Jobs\RevisarSuscripcionesMercadoPago;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\DB;
use App\Jobs\EnviarCorreoProgramado;
use Illuminate\Support\Facades\Bus;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {

//        $schedule->job(new RevisarCorreosPendientes)->dailyAt('06:00');
        $schedule->job(new RevisarCorreosPendientes)
            ->everyThirtyMinutes()
            ->between('08:00', '22:00')
            ->withoutOverlapping()
            ->onOneServer();
//        $schedule->job(new RevisarSuscripcionesMercadoPago)->dailyAt('06:10');
        $schedule->job(new RevisarSuscripcionesMercadoPago)
            ->dailyAt('03:30')
            ->withoutOverlapping()
            ->onOneServer();

    }

    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        require base_path('routes/console.php');
    }
}
